/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.PlayerNotifications;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketAspectPool
extends AbstractPacket {
    private String key;
    private Short amount;
    private Short total;
    private static long lastSound = 0L;

    public PacketAspectPool() {
    }

    public PacketAspectPool(String key, Short amount, Short total) {
        this.key = key;
        this.amount = amount;
        this.total = total;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.key);
        buffer.writeShort((int)this.amount.shortValue());
        buffer.writeShort((int)this.total.shortValue());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.amount = buffer.readShort();
        this.total = buffer.readShort();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        boolean success;
        if (Aspect.getAspect(this.key) != null && (success = Thaumcraft.proxy.getPlayerKnowledge().setAspectPool(player.func_70005_c_(), Aspect.getAspect(this.key), this.total)) && this.amount > 0) {
            String text = StatCollector.func_74838_a((String)"tc.addaspectpool");
            text = text.replaceAll("%s", this.amount + "");
            text = text.replaceAll("%n", Aspect.getAspect(this.key).getName());
            PlayerNotifications.addNotification(text, Aspect.getAspect(this.key));
            for (int a = 0; a < this.amount; ++a) {
                PlayerNotifications.addAspectNotification(Aspect.getAspect(this.key));
            }
            if (System.currentTimeMillis() > lastSound) {
                player.func_85030_a("random.orb", 0.1f, 0.9f + player.field_70170_p.field_73012_v.nextFloat() * 0.2f);
                lastSound = System.currentTimeMillis() + 100L;
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
    }
}

