/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.io.File;
import net.minecraft.block.BlockDispenser;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.client.lib.RenderEventHandler;
import thaumcraft.common.CommonProxy;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigAspects;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigEntities;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigRecipes;
import thaumcraft.common.config.ConfigResearch;
import thaumcraft.common.items.BehaviorDispenseAlumetum;
import thaumcraft.common.lib.CreativeTabThaumcraft;
import thaumcraft.common.lib.CustomCropHarvesting;
import thaumcraft.common.lib.Utils;
import thaumcraft.common.lib.events.CommandThaumcraft;
import thaumcraft.common.lib.events.EventHandlerEntity;
import thaumcraft.common.lib.events.EventHandlerRunic;
import thaumcraft.common.lib.events.EventHandlerWorld;
import thaumcraft.common.lib.events.ServerTickEventsFML;
import thaumcraft.common.lib.network.EventHandlerNetwork;
import thaumcraft.common.lib.network.PacketPipeline;
import thaumcraft.common.lib.research.PlayerKnowledge;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.world.ComponentWizardTower;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.lib.world.VillageManager;

@Mod(modid="Thaumcraft", name="Thaumcraft", version="4.1.1.14", dependencies="required-after:Forge@[10.12.0.1056,);required-after:Baubles@[1.0.0.13,)")
public class Thaumcraft {
    public static final String MODID = "Thaumcraft";
    public static final String MODNAME = "Thaumcraft";
    public static final String VERSION = "4.1.1.14";
    @SidedProxy(clientSide="thaumcraft.client.ClientProxy", serverSide="thaumcraft.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="Thaumcraft")
    public static Thaumcraft instance;
    ResearchManager researchManager;
    public ThaumcraftWorldGenerator worldGen;
    public EventHandlerWorld worldEventHandler;
    public EventHandlerNetwork networkEventHandler;
    public ServerTickEventsFML serverTickEvents;
    public EventHandlerEntity entityEventHandler;
    public EventHandlerRunic runicEventHandler;
    public RenderEventHandler renderEventHandler;
    public File modDir;
    public static final PacketPipeline packetPipeline;
    public static final Logger log;
    public static boolean isHalloween;
    public static CreativeTabs tabTC;
    public boolean aspectShift = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        event.getModMetadata().version = VERSION;
        this.modDir = event.getModConfigurationDirectory();
        try {
            Config.initialize(event.getSuggestedConfigurationFile());
        }
        catch (Exception e) {
            log.error("Thaumcraft has a problem loading it's configuration");
        }
        finally {
            if (Config.config != null) {
                Config.save();
            }
        }
        Thaumcraft.proxy.playerKnowledge = new PlayerKnowledge();
        Thaumcraft.proxy.researchManager = new ResearchManager();
        this.worldEventHandler = new EventHandlerWorld();
        this.serverTickEvents = new ServerTickEventsFML();
        this.entityEventHandler = new EventHandlerEntity();
        this.runicEventHandler = new EventHandlerRunic();
        this.renderEventHandler = new RenderEventHandler();
        this.networkEventHandler = new EventHandlerNetwork();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.worldEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.worldEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.entityEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)this.runicEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.networkEventHandler);
        GameRegistry.registerFuelHandler((IFuelHandler)this.worldEventHandler);
        FMLCommonHandler.instance().bus().register((Object)this.serverTickEvents);
        this.worldGen = new ThaumcraftWorldGenerator();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldGen, (int)0);
        ThaumcraftApi.registerScanEventhandler(new ScanManager());
        Config.save();
        ConfigBlocks.init();
        ConfigItems.init();
        try {
            MapGenStructureIO.func_143031_a(ComponentWizardTower.class, (String)"TCVillageTower");
        }
        catch (Throwable e) {
            log.error("[Thaumcraft] Village tower could not be registered.");
        }
        proxy.registerHandlers();
        this.worldGen.initialize();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        packetPipeline.initialise();
        proxy.registerDisplayInformation();
        Config.registerBiomes();
        ConfigEntities.init();
        BlockDispenser.field_149943_a.func_82595_a((Object)ConfigItems.itemResource, (Object)new BehaviorDispenseAlumetum());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        VillageManager villageManager = new VillageManager();
        VillagerRegistry.instance().registerVillagerId(ConfigEntities.entWizardId);
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)villageManager);
        VillagerRegistry.instance().registerVillageTradeHandler(ConfigEntities.entWizardId, (VillagerRegistry.IVillageTradeHandler)villageManager);
        proxy.registerKeyBindings();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ConfigEntities.initEntitySpawns();
        Config.initModCompatibility();
        ConfigItems.postInit();
        ConfigRecipes.init();
        ConfigAspects.init();
        ConfigResearch.init();
        Config.initLoot();
        Config.initMisc();
        ImmutableList messages = FMLInterModComms.fetchRuntimeMessages((Object)this);
        for (FMLInterModComms.IMCMessage message : messages) {
            String[] t;
            ItemStack crop;
            if (message.key.equals("harvestStandardCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CustomCropHarvesting.addStandardCrop(crop, crop.func_77960_j());
                log.warn("Adding standard crop support for [" + crop.func_82833_r() + "]");
            }
            if (message.key.equals("harvestClickableCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CustomCropHarvesting.addClickableCrop(crop, crop.func_77960_j());
                log.warn("Adding clickable crop support for [" + crop.func_82833_r() + "]");
            }
            if (message.key.equals("harvestStackedCrop") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CustomCropHarvesting.addStackedCrop(crop, crop.func_77960_j());
                log.warn("Adding stacked crop support for [" + crop.func_82833_r() + "]");
            }
            if (message.key.equals("nativeCluster") && message.isStringMessage() && (t = message.getStringValue().split(",")) != null && t.length == 5) {
                try {
                    ItemStack ore = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[0])), 1, Integer.parseInt(t[1]));
                    ItemStack cluster = new ItemStack(Item.func_150899_d((int)Integer.parseInt(t[2])), 1, Integer.parseInt(t[3]));
                    Utils.addSpecialMiningResult(ore, cluster, Float.parseFloat(t[4]));
                    log.warn("Adding [" + cluster.func_82833_r() + "] to special result list for [" + ore.func_82833_r() + "]");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (message.key.equals("lampBlacklist") && message.isItemStackMessage()) {
                crop = message.getItemStackValue();
                CustomCropHarvesting.blacklistLamp(crop, crop.func_77960_j());
                log.warn("[Thaumcraft] Blacklisting [" + crop.func_82833_r() + "] for lamp of growth");
            }
            if (message.key.equals("dimensionBlacklist") && message.isStringMessage() && (t = message.getStringValue().split(":")) != null && t.length == 2) {
                try {
                    this.worldGen.addDimBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                    log.warn("Blacklisting dimension [" + Integer.parseInt(t[0]) + "] to only spawn TC content at level [" + Integer.parseInt(t[1]) + "]");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!message.key.equals("biomeBlacklist") || !message.isStringMessage() || (t = message.getStringValue().split(":")) == null || t.length != 2 || BiomeGenBase.func_150568_d((int)Integer.parseInt(t[0])) == null) continue;
            try {
                this.worldGen.addBiomeBlacklist(Integer.parseInt(t[0]), Integer.parseInt(t[1]));
                log.warn("Blacklisting [" + BiomeGenBase.func_150568_d((int)Integer.parseInt((String)t[0])).field_76791_y + "] to only spawn TC content at level [" + Integer.parseInt(t[1]) + "]");
            }
            catch (Exception e) {}
        }
        packetPipeline.postInitialise();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandThaumcraft());
    }

    static {
        packetPipeline = new PacketPipeline();
        log = LogManager.getLogger((String)"THAUMCRAFT");
        isHalloween = false;
        tabTC = new CreativeTabThaumcraft(CreativeTabs.getNextID(), "thaumcraft");
    }
}

