/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.config;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;

public class ConfigAspects {
    public static String[] dyes = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};

    public static void init() {
        ConfigAspects.registerItemAspects();
        ConfigAspects.registerEntityAspects();
    }

    private static void registerEntityAspects() {
        ThaumcraftApi.registerEntityTag("Zombie", new AspectList().add(Aspect.UNDEAD, 2).add(Aspect.MAN, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Giant", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Skeleton", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.MAN, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Skeleton", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 1).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT("SkeletonType", (byte)1));
        ThaumcraftApi.registerEntityTag("Creeper", new AspectList().add(Aspect.PLANT, 2).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Creeper", new AspectList().add(Aspect.PLANT, 3).add(Aspect.FIRE, 3).add(Aspect.ENERGY, 3), new ThaumcraftApi.EntityTagsNBT("powered", (byte)1));
        ThaumcraftApi.registerEntityTag("EntityHorse", new AspectList().add(Aspect.BEAST, 4).add(Aspect.EARTH, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Pig", new AspectList().add(Aspect.BEAST, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("XPOrb", new AspectList().add(Aspect.MIND, 5), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Sheep", new AspectList().add(Aspect.BEAST, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Cow", new AspectList().add(Aspect.BEAST, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MushroomCow", new AspectList().add(Aspect.BEAST, 3).add(Aspect.PLANT, 1).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("SnowMan", new AspectList().add(Aspect.COLD, 3).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Ozelot", new AspectList().add(Aspect.BEAST, 3).add(Aspect.ENTROPY, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Chicken", new AspectList().add(Aspect.BEAST, 2).add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Squid", new AspectList().add(Aspect.BEAST, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Wolf", new AspectList().add(Aspect.BEAST, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Bat", new AspectList().add(Aspect.BEAST, 1).add(Aspect.FLIGHT, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Boat", new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Spider", new AspectList().add(Aspect.BEAST, 3).add(Aspect.ENTROPY, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Slime", new AspectList().add(Aspect.SLIME, 2).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Ghast", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("PigZombie", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Enderman", new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.TRAVEL, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("CaveSpider", new AspectList().add(Aspect.BEAST, 2).add(Aspect.POISON, 2).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Silverfish", new AspectList().add(Aspect.BEAST, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Blaze", new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("LavaSlime", new AspectList().add(Aspect.SLIME, 3).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("EnderDragon", new AspectList().add(Aspect.ELDRITCH, 10).add(Aspect.AIR, 10).add(Aspect.FIRE, 10).add(Aspect.EARTH, 10).add(Aspect.WATER, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("WitherBoss", new AspectList().add(Aspect.UNDEAD, 7).add(Aspect.AIR, 7).add(Aspect.FIRE, 7).add(Aspect.EARTH, 7).add(Aspect.WATER, 7).add(Aspect.ORDER, 7).add(Aspect.ENTROPY, 7), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Witch", new AspectList().add(Aspect.MAN, 3).add(Aspect.MAGIC, 2).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Villager", new AspectList().add(Aspect.MAN, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("VillagerGolem", new AspectList().add(Aspect.METAL, 4).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartRideable", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartChest", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.VOID, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartFurnace", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartTNT", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.FIRE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartHopper", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.EXCHANGE, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("MinecartSpawner", new AspectList().add(Aspect.MECHANISM, 3).add(Aspect.AIR, 1).add(Aspect.MAGIC, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("EnderCrystal", new AspectList().add(Aspect.ELDRITCH, 3).add(Aspect.MAGIC, 3).add(Aspect.HEAL, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("ItemFrame", new AspectList().add(Aspect.SENSES, 3).add(Aspect.CLOTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Painting", new AspectList().add(Aspect.SENSES, 5).add(Aspect.CLOTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.PrimalOrb", new AspectList().add(Aspect.AIR, 5).add(Aspect.FIRE, 5).add(Aspect.EARTH, 5).add(Aspect.WATER, 5).add(Aspect.ORDER, 5).add(Aspect.ENTROPY, 5).add(Aspect.MAGIC, 5), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Firebat", new AspectList().add(Aspect.BEAST, 2).add(Aspect.FLIGHT, 1).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2).add(Aspect.GREED, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)0));
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2).add(Aspect.WEAPON, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)1));
        ThaumcraftApi.registerEntityTag("Thaumcraft.Pech", new AspectList().add(Aspect.MAN, 2).add(Aspect.MAGIC, 4).add(Aspect.EXCHANGE, 2), new ThaumcraftApi.EntityTagsNBT("PechType", (byte)2));
        ThaumcraftApi.registerEntityTag("Thaumcraft.ThaumSlime", new AspectList().add(Aspect.SLIME, 2).add(Aspect.MAGIC, 1).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.BrainyZombie", new AspectList().add(Aspect.UNDEAD, 3).add(Aspect.MAN, 1).add(Aspect.MIND, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.GiantBrainyZombie", new AspectList().add(Aspect.UNDEAD, 4).add(Aspect.MAN, 2).add(Aspect.MIND, 1).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.Taintacle", new AspectList().add(Aspect.TAINT, 3).add(Aspect.WATER, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintacleTiny", new AspectList().add(Aspect.TAINT, 1).add(Aspect.WATER, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSpider", new AspectList().add(Aspect.TAINT, 1).add(Aspect.EARTH, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSpore", new AspectList().add(Aspect.TAINT, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSwarmer", new AspectList().add(Aspect.TAINT, 2).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintSwarm", new AspectList().add(Aspect.TAINT, 3).add(Aspect.AIR, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedPig", new AspectList().add(Aspect.TAINT, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedSheep", new AspectList().add(Aspect.TAINT, 2).add(Aspect.EARTH, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedCow", new AspectList().add(Aspect.TAINT, 3).add(Aspect.EARTH, 3), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedChicken", new AspectList().add(Aspect.TAINT, 2).add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedVillager", new AspectList().add(Aspect.TAINT, 3).add(Aspect.AIR, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        ThaumcraftApi.registerEntityTag("Thaumcraft.TaintedCreeper", new AspectList().add(Aspect.TAINT, 2).add(Aspect.FIRE, 2), new ThaumcraftApi.EntityTagsNBT[0]);
        for (Aspect tag : Aspect.aspects.values()) {
            ThaumcraftApi.registerEntityTag("Thaumcraft.Wisp", new AspectList().add(tag, 2).add(Aspect.MAGIC, 1).add(Aspect.AIR, 1), new ThaumcraftApi.EntityTagsNBT("Type", tag.getTag()));
        }
        ThaumcraftApi.registerEntityTag("Thaumcraft.Golem", new AspectList().add(Aspect.AIR, 2).add(Aspect.EARTH, 2).add(Aspect.MAGIC, 2), new ThaumcraftApi.EntityTagsNBT[0]);
    }

    private static void registerItemAspects() {
        ThaumcraftApi.registerObjectTag("stone", new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag("cobblestone", new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag("logWood", new AspectList().add(Aspect.TREE, 4));
        ThaumcraftApi.registerObjectTag("plankWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("slabWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("stairWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("stickWood", new AspectList().add(Aspect.TREE, 1));
        ThaumcraftApi.registerObjectTag("treeSapling", new AspectList().add(Aspect.TREE, 1).add(Aspect.PLANT, 2));
        ThaumcraftApi.registerObjectTag("treeLeaves", new AspectList().add(Aspect.PLANT, 1));
        for (int i = 0; i < 16; ++i) {
            ThaumcraftApi.registerObjectTag(dyes[i], new AspectList().add(Aspect.SENSES, 1));
        }
        ThaumcraftApi.registerObjectTag("oreLapis", new AspectList().add(Aspect.EARTH, 1).add(Aspect.SENSES, 3));
        ThaumcraftApi.registerObjectTag("oreDiamond", new AspectList().add(Aspect.EARTH, 1).add(Aspect.GREED, 3).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag("gemDiamond", new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag("oreRedstone", new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 2).add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150439_ay), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 3).add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerObjectTag("oreEmerald", new AspectList().add(Aspect.EARTH, 1).add(Aspect.GREED, 4).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag("gemEmerald", new AspectList().add(Aspect.CRYSTAL, 4).add(Aspect.GREED, 5));
        ThaumcraftApi.registerObjectTag("oreQuartz", new AspectList().add(Aspect.EARTH, 1).add(Aspect.CRYSTAL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151128_bU), new AspectList().add(Aspect.CRYSTAL, 1).add(Aspect.ENERGY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151074_bl), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag("nuggetIron", new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag("oreIron", new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 3));
        ThaumcraftApi.registerObjectTag("dustIron", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151042_j), new AspectList().add(Aspect.METAL, 4));
        ThaumcraftApi.registerObjectTag("oreGold", new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 2).add(Aspect.GREED, 1));
        ThaumcraftApi.registerObjectTag("dustGold", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151043_k), new AspectList().add(Aspect.METAL, 3).add(Aspect.GREED, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150365_q), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENERGY, 2).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ENERGY, 2).add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag("dustRedstone", new AspectList().add(Aspect.ENERGY, 2).add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerObjectTag("dustGlowstone", new AspectList().add(Aspect.SENSES, 1).add(Aspect.LIGHT, 2));
        ThaumcraftApi.registerObjectTag("glowstone", new AspectList().add(Aspect.SENSES, 3).add(Aspect.LIGHT, 10));
        if (Config.foundCopperIngot) {
            ThaumcraftApi.registerObjectTag("nuggetCopper", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotCopper", new AspectList().add(Aspect.METAL, 3).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag("dustCopper", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag("oreCopper", new AspectList().add(Aspect.METAL, 2).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 17), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 2));
        }
        if (Config.foundTinIngot) {
            ThaumcraftApi.registerObjectTag("nuggetTin", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotTin", new AspectList().add(Aspect.METAL, 3).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag("dustTin", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag("oreTin", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.CRYSTAL, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 18), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.CRYSTAL, 2));
        }
        if (Config.foundSilverIngot) {
            ThaumcraftApi.registerObjectTag("nuggetSilver", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotSilver", new AspectList().add(Aspect.METAL, 3).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag("dustSilver", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag("oreSilver", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.GREED, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 19), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.GREED, 2));
        }
        if (Config.foundLeadIngot) {
            ThaumcraftApi.registerObjectTag("nuggetLead", new AspectList().add(Aspect.METAL, 1));
            ThaumcraftApi.registerObjectTag("ingotLead", new AspectList().add(Aspect.METAL, 3).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag("dustLead", new AspectList().add(Aspect.METAL, 2).add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag("oreLead", new AspectList().add(Aspect.METAL, 3).add(Aspect.ENTROPY, 1).add(Aspect.ORDER, 1));
            ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 20), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 5).add(Aspect.EARTH, 1).add(Aspect.ORDER, 2));
        }
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150357_h), new AspectList().add(Aspect.VOID, 16).add(Aspect.WATER, 16).add(Aspect.FIRE, 16).add(Aspect.ORDER, 16).add(Aspect.EARTH, 16).add(Aspect.AIR, 16).add(Aspect.ENTROPY, 16));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150346_d, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150346_d, 1, 2), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150458_ak, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.HARVEST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150354_m), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150349_c), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151119_aD, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150377_bs), new AspectList().add(Aspect.EARTH, 1).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150351_n), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150391_bh), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150435_aG, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 3).add(Aspect.WATER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150405_ch, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 4).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150406_ce, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 3).add(Aspect.FIRE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151118_aC, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151130_bT, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150425_aM, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TRAP, 1).add(Aspect.SOUL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150424_aL, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150385_bj), new AspectList().add(Aspect.EARTH, 2).add(Aspect.FIRE, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150359_w, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150399_cn, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150341_Y, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.PLANT, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150343_Z, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2).add(Aspect.FIRE, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150418_aU, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2).add(Aspect.BEAST, 1).add(Aspect.TRAP, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150417_aV, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150417_aV, 1, 1), new AspectList(new ItemStack(Blocks.field_150417_aV)).remove(Aspect.EARTH, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150417_aV, 1, 2), new AspectList(new ItemStack(Blocks.field_150417_aV)).remove(Aspect.EARTH, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150417_aV, 1, 3), new AspectList(new ItemStack(Blocks.field_150417_aV)).remove(Aspect.EARTH, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150322_A, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).remove(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150322_A, 1, 1), new AspectList(new ItemStack(Blocks.field_150322_A)).remove(Aspect.EARTH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150322_A, 1, 2), new AspectList(new ItemStack(Blocks.field_150322_A)).remove(Aspect.EARTH, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150329_H, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150398_cm, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150392_bi, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.WATER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150330_I, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150395_bd, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151014_N, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151081_bc, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151080_bb, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151127_ba, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151075_bm), new AspectList().add(Aspect.PLANT, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150328_O, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150327_N, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.LIFE, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150434_aF), new AspectList().add(Aspect.PLANT, 3).add(Aspect.WATER, 1).add(Aspect.ENTROPY, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150338_P), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150337_Q), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150420_aW, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150419_aX, 1, Short.MAX_VALUE), new AspectList().add(Aspect.PLANT, 2).add(Aspect.DARKNESS, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151120_aE), new AspectList().add(Aspect.PLANT, 1).add(Aspect.WATER, 1).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151015_O), new AspectList().add(Aspect.CROP, 2).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151034_e), new AspectList().add(Aspect.CROP, 2).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151172_bF), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151174_bG), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 1).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151168_bH), new AspectList().add(Aspect.CROP, 1).add(Aspect.HUNGER, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151170_bI), new AspectList().add(Aspect.CROP, 1).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150423_aK, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CROP, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150440_ba, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CROP, 2).remove(Aspect.HUNGER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151057_cb, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MIND, 2).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151138_bX, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 2).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151136_bY, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 4).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151125_bZ, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ARMOR, 6).add(Aspect.BEAST, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150480_ab, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150355_j, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150353_l, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 3).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150432_aD, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150403_cj, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 3).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151126_ay, 1, Short.MAX_VALUE), new AspectList().add(Aspect.COLD, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151106_aX, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151068_bn), new AspectList().add(Aspect.WATER, 1).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150478_aa, 1, Short.MAX_VALUE), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150321_G, 1, Short.MAX_VALUE), new AspectList().add(Aspect.TRAP, 2).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151145_ak, 1, Short.MAX_VALUE), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151007_F, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 1).add(Aspect.CLOTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151123_aH), new AspectList().add(Aspect.SLIME, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151116_aA, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CLOTH, 2).add(Aspect.BEAST, 1).add(Aspect.ARMOR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151078_bh, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MAN, 1).add(Aspect.FLESH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151008_G, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLIGHT, 2).add(Aspect.AIR, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151103_aS, 1, Short.MAX_VALUE), new AspectList().add(Aspect.DEATH, 2).add(Aspect.FLESH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151110_aK, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SLIME, 1).add(Aspect.LIFE, 1).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151070_bp, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SENSES, 2).add(Aspect.BEAST, 2).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151016_H, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.ENTROPY, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150325_L, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CLOTH, 4).add(Aspect.CRAFT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 1).add(Aspect.WATER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151101_aQ, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151076_bf, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 2).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151077_bg, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151147_al, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 3).add(Aspect.LIFE, 1).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151157_am, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 3).add(Aspect.HUNGER, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151082_bd, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FLESH, 4).add(Aspect.LIFE, 2).add(Aspect.BEAST, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151083_be, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 1).add(Aspect.FLESH, 4).add(Aspect.HUNGER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151072_bj, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151141_av, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 2).add(Aspect.CLOTH, 3).add(Aspect.TRAVEL, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151079_bi, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.MAGIC, 2).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151073_bk, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.UNDEAD, 4).add(Aspect.SOUL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151144_bL, 1, 0), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.UNDEAD, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151144_bL, 1, 1), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.UNDEAD, 4).add(Aspect.POISON, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151144_bL, 1, 2), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.FLESH, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151144_bL, 1, 3), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.MAN, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151144_bL, 1, 4), new AspectList().add(Aspect.DEATH, 4).add(Aspect.SOUL, 4).add(Aspect.ENTROPY, 2).add(Aspect.FIRE, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151086_cn), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151096_cd), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.WATER, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151093_ce), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.BEAST, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151091_cg), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.EARTH, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151092_ch), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.ELDRITCH, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151089_ci), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MAN, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151090_cj), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.CRAFT, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151087_ck), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.DARKNESS, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151088_cl), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MECHANISM, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151085_cm), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.MAGIC, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151094_cf), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.TOOL, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151084_co), new AspectList().add(Aspect.SENSES, 4).add(Aspect.AIR, 4).add(Aspect.TRAP, 4).add(Aspect.GREED, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151156_bN), new AspectList().add(Aspect.ELDRITCH, 8).add(Aspect.MAGIC, 8).add(Aspect.ORDER, 8).add(Aspect.LIGHT, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151020_U, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151023_V, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 12));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151022_W, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 11));
        ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151029_X, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 7));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151121_aF), new AspectList().add(Aspect.MIND, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151122_aG), new AspectList().add(Aspect.MIND, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150342_X), new AspectList().merge(Aspect.MIND, 13));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150380_bt), new AspectList().add(Aspect.ELDRITCH, 8).add(Aspect.BEAST, 8).add(Aspect.MAGIC, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150427_aO, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150384_bq, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150378_br, 1, Short.MAX_VALUE), new AspectList().add(Aspect.ELDRITCH, 4).add(Aspect.MECHANISM, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150474_ac, 1, Short.MAX_VALUE), new AspectList().add(Aspect.BEAST, 4).add(Aspect.TRAVEL, 4).add(Aspect.UNDEAD, 4).add(Aspect.MAGIC, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151061_bv), new AspectList().add(Aspect.SENSES, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151032_g), new AspectList().add(Aspect.WEAPON, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151069_bo), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150486_ae, 1, Short.MAX_VALUE), new AspectList().add(Aspect.VOID, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151153_ao, 1, 0), new AspectList().add(Aspect.MAGIC, 2).add(Aspect.HEAL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151153_ao, 1, 1), new AspectList().add(Aspect.MAGIC, 4).add(Aspect.HEAL, 8));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151054_z), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151009_A), new AspectList().add(Aspect.HUNGER, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151143_au), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151139_aw), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151135_aq), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151124_az), new AspectList().add(Aspect.WATER, 4).add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151033_d, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Item)Items.field_151112_aM, 1, Short.MAX_VALUE), new AspectList().add(Aspect.WATER, 1).add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151133_ar), new AspectList().add(Aspect.METAL, 8).add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151131_as), new AspectList(new ItemStack(Items.field_151133_ar)).add(Aspect.WATER, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151129_at), new AspectList(new ItemStack(Items.field_151133_ar)).add(Aspect.FIRE, 4).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(Items.field_151117_aB), new AspectList(new ItemStack(Items.field_151133_ar)).add(Aspect.HUNGER, 2).add(Aspect.HEAL, 2).add(Aspect.WATER, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151067_bt), new AspectList().add(Aspect.CRAFT, 2).add(Aspect.WATER, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150430_aB), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150448_aq, 1, Short.MAX_VALUE), new AspectList().add(Aspect.METAL, 1).add(Aspect.TRAVEL, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150319_E, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150318_D, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.ENERGY, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150408_cc, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150396_be, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.TRAVEL, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150452_aw, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150456_au, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150445_bS, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150443_bT, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1).add(Aspect.SENSES, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150442_at, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150429_aA, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150331_J, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150320_F, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 2).add(Aspect.MOTION, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150421_aI), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 2).add(Aspect.AIR, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150323_B), new AspectList().add(Aspect.SENSES, 4).add(Aspect.MECHANISM, 1).add(Aspect.AIR, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150415_aT, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MOTION, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150470_am, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150460_al, 1, Short.MAX_VALUE), new AspectList().add(Aspect.FIRE, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150381_bn), new AspectList().add(Aspect.MAGIC, 8).add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(Blocks.field_150462_ai), new AspectList().add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151113_aN), new AspectList().add(Aspect.MECHANISM, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150461_bJ), new AspectList().add(Aspect.AURA, 2).add(Aspect.MAGIC, 2).add(Aspect.EXCHANGE, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150467_bQ, 1, Short.MAX_VALUE), new AspectList().add(Aspect.CRAFT, 2).add(Aspect.TOOL, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150471_bO, 1, Short.MAX_VALUE), new AspectList().add(Aspect.MECHANISM, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151146_bM, 1, Short.MAX_VALUE), new AspectList().add(Aspect.TRAVEL, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151162_bE), new AspectList().add(Aspect.VOID, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Items.field_151150_bK), new AspectList().add(Aspect.SENSES, 2));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150477_bB, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.EXCHANGE, 2).merge(Aspect.TRAVEL, 2).merge(Aspect.VOID, 4));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150438_bZ, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150409_cd, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(Blocks.field_150367_z, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.MECHANISM, 1).merge(Aspect.EXCHANGE, 1).merge(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack((Block)Blocks.field_150479_bC, 1, Short.MAX_VALUE), new AspectList().add(Aspect.SENSES, 1).add(Aspect.MECHANISM, 1).add(Aspect.TRAP, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack((Block)Blocks.field_150453_bW, 1, Short.MAX_VALUE), new AspectList().merge(Aspect.SENSES, 2).merge(Aspect.LIGHT, 3).merge(Aspect.MECHANISM, 3));
        LinkedHashMap<List, Integer> lhm = new LinkedHashMap<List, Integer>();
        for (int var4 = 1; var4 <= Short.MAX_VALUE; ++var4) {
            List var5 = PotionHelper.func_77917_b((int)var4, (boolean)false);
            if (var5 == null || var5.isEmpty()) continue;
            lhm.put(var5, var4);
        }
        Iterator var6 = lhm.values().iterator();
        while (var6.hasNext()) {
            int var7 = (Integer)var6.next();
            ThaumcraftApi.registerObjectTag(new ItemStack((Item)Items.field_151068_bn, 1, var7), new AspectList(new ItemStack((Item)Items.field_151068_bn)));
        }
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigBlocks.blockTable), new AspectList().add(Aspect.TOOL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTable, 1, 15), new AspectList(new ItemStack(ConfigBlocks.blockTable)).add(Aspect.CRAFT, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTable, 1, 2), new AspectList(new ItemStack(ConfigBlocks.blockTable)).add(Aspect.MIND, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 16), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 6).add(Aspect.EARTH, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 31), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 4).add(Aspect.EARTH, 1).add(Aspect.GREED, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 21), new AspectList().add(Aspect.ORDER, 1).add(Aspect.METAL, 4).add(Aspect.EARTH, 1).add(Aspect.EXCHANGE, 4).add(Aspect.POISON, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 5), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNugget, 1, 6), new AspectList().add(Aspect.METAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 0), new AspectList().add(Aspect.EARTH, 1).add(Aspect.METAL, 2).add(Aspect.EXCHANGE, 2).add(Aspect.POISON, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 7), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TRAP, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 1), new AspectList().add(Aspect.EARTH, 1).add(Aspect.AIR, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 2), new AspectList().add(Aspect.EARTH, 1).add(Aspect.FIRE, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 3), new AspectList().add(Aspect.EARTH, 1).add(Aspect.WATER, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 4), new AspectList().add(Aspect.EARTH, 1).add(Aspect.EARTH, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 5), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ORDER, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomOre, 1, 6), new AspectList().add(Aspect.EARTH, 1).add(Aspect.ENTROPY, 3).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaint, 1, 0), new AspectList().add(Aspect.TREE, 1).add(Aspect.TAINT, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaint, 1, 1), new AspectList().add(Aspect.EARTH, 1).add(Aspect.TAINT, 3));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 0), new AspectList().add(Aspect.LIFE, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 1), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TAINT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 2), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TAINT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 3), new AspectList().add(Aspect.BEAST, 1).add(Aspect.PLANT, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockTaintFibres, 1, 4), new AspectList().add(Aspect.BEAST, 1).add(Aspect.PLANT, 1).add(Aspect.TAINT, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCosmeticSolid), new AspectList().add(Aspect.EARTH, 4).add(Aspect.DARKNESS, 2).add(Aspect.ELDRITCH, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLog, 1, 0), new AspectList().add(Aspect.TREE, 3).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLog, 1, 1), new AspectList().add(Aspect.TREE, 3).add(Aspect.MAGIC, 1).add(Aspect.ORDER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 0), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMagicalLeaves, 1, 1), new AspectList().add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 0), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TREE, 1).add(Aspect.MAGIC, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 1), new AspectList().add(Aspect.PLANT, 1).add(Aspect.TREE, 1).add(Aspect.MAGIC, 1).add(Aspect.PLANT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 2), new AspectList().add(Aspect.PLANT, 2).add(Aspect.EXCHANGE, 2).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 3), new AspectList().add(Aspect.PLANT, 2).add(Aspect.FIRE, 2).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCustomPlant, 1, 5), new AspectList().add(Aspect.PLANT, 2).add(Aspect.POISON, 1).add(Aspect.MAGIC, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 3), new AspectList().add(Aspect.METAL, 3).add(Aspect.POISON, 1).add(Aspect.EXCHANGE, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 5), new AspectList().add(Aspect.FLESH, 2).add(Aspect.MIND, 4).add(Aspect.UNDEAD, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 6), new AspectList().add(Aspect.TRAP, 2).add(Aspect.CRYSTAL, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 9), new AspectList().add(Aspect.MIND, 8));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 11), new AspectList().add(Aspect.TAINT, 3).add(Aspect.SLIME, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemResource, 1, 12), new AspectList().add(Aspect.TAINT, 2).add(Aspect.GREED, 1).add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetBeef, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetChicken, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetPork, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemNuggetFish, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HUNGER, 1));
        ThaumcraftApi.registerComplexObjectTag(new ItemStack(ConfigItems.itemTripleMeatTreat, 1, Short.MAX_VALUE), new AspectList().add(Aspect.HEAL, 1).remove(Aspect.HUNGER, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 0), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.AIR, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 1), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.FIRE, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 2), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.WATER, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 3), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.EARTH, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 4), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.ORDER, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemShard, 1, 5), new AspectList().add(Aspect.MAGIC, 1).add(Aspect.ENTROPY, 2).add(Aspect.CRYSTAL, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockMetalDevice), new AspectList(new ItemStack(Items.field_151066_bu, 1, Short.MAX_VALUE)).add(Aspect.CRAFT, 4).add(Aspect.MAGIC, 4));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockCandle), new AspectList().add(Aspect.LIGHT, 2).add(Aspect.FLESH, 1).add(Aspect.MAGIC, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockAiry, 1, 2), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigBlocks.blockAiry, 1, 3), new AspectList().add(Aspect.LIGHT, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemThaumonomicon, 1, Short.MAX_VALUE), new AspectList(new ItemStack(Blocks.field_150342_X)).add(Aspect.MAGIC, 2).merge(Aspect.MIND, 2));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEssence, 1, 0), new AspectList().add(Aspect.VOID, 1));
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemEssence, 1, 1), new AspectList());
        ThaumcraftApi.registerObjectTag(new ItemStack(ConfigItems.itemWispEssence, 1, 0), new AspectList().add(Aspect.AURA, 2));
    }
}

