/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.fx.FXLightningBolt;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.Utils;

public class ItemFocusShock
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.AIR, 10);
    long soundDelay = 0L;

    public ItemFocusShock() {
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:focus_shock");
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "BL" + super.getSortingHelper(itemstack);
    }

    @Override
    public int getFocusColor() {
        return 10466239;
    }

    @Override
    public AspectList getVisCost() {
        return cost;
    }

    @Override
    public boolean isVisCostPerTick() {
        return true;
    }

    public static void shootLightning(World world, EntityLivingBase entityplayer, double xx, double yy, double zz, boolean offset) {
        double px = entityplayer.field_70165_t;
        double py = entityplayer.field_70163_u;
        double pz = entityplayer.field_70161_v;
        if (entityplayer.func_145782_y() != FMLClientHandler.instance().getClient().field_71439_g.func_145782_y()) {
            py = entityplayer.field_70121_D.field_72338_b + (double)(entityplayer.field_70131_O / 2.0f) + 0.25;
        }
        px += (double)(-MathHelper.func_76134_b((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        py += (double)-0.06f;
        pz += (double)(-MathHelper.func_76126_a((float)(entityplayer.field_70177_z / 180.0f * 3.141593f)) * 0.06f);
        if (entityplayer.func_145782_y() != FMLClientHandler.instance().getClient().field_71439_g.func_145782_y()) {
            py = entityplayer.field_70121_D.field_72338_b + (double)(entityplayer.field_70131_O / 2.0f) + 0.25;
        }
        Vec3 vec3d = entityplayer.func_70676_i(1.0f);
        FXLightningBolt bolt = new FXLightningBolt(world, px += vec3d.field_72450_a * 0.3, py += vec3d.field_72448_b * 0.3, pz += vec3d.field_72449_c * 0.3, xx, yy, zz, world.field_73012_v.nextLong(), 6, 0.5f, 5);
        bolt.defaultFractal();
        bolt.setType(2);
        bolt.setWidth(0.125f);
        bolt.finalizeBolt();
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer p, MovingObjectPosition movingobjectposition) {
        p.func_71008_a(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    @Override
    public void onUsingFocusTick(ItemStack stack, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        if (!wand.consumeAllVis(stack, p, this.getVisCost(), !p.field_70170_p.field_72995_K, false)) {
            p.func_71034_by();
            return;
        }
        int potency = wand.getFocusPotency(stack);
        Entity pointedEntity = Utils.getPointedEntity(p.field_70170_p, p, 0.0, 20.0, 1.1f);
        boolean zapped = false;
        if (this.soundDelay < System.currentTimeMillis()) {
            if (!p.field_70170_p.field_72995_K) {
                p.field_70170_p.func_72908_a(p.field_70165_t, p.field_70163_u, p.field_70161_v, "thaumcraft:shock", 0.25f, 1.0f);
            }
            this.soundDelay = System.currentTimeMillis() + 100L;
            zapped = true;
        }
        if (p.field_70170_p.field_72995_K) {
            if (zapped) {
                int a;
                MovingObjectPosition mop = Utils.getTargetBlock(p.field_70170_p, (Entity)p, false);
                Vec3 v = p.func_70676_i(2.0f);
                double px = p.field_70165_t + v.field_72450_a * 10.0;
                double py = p.field_70163_u + v.field_72448_b * 10.0;
                double pz = p.field_70161_v + v.field_72449_c * 10.0;
                if (mop != null) {
                    px = mop.field_72307_f.field_72450_a;
                    py = mop.field_72307_f.field_72448_b;
                    pz = mop.field_72307_f.field_72449_c;
                    for (a = 0; a < 5; ++a) {
                        Thaumcraft.proxy.sparkle((float)px + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, (float)py + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, (float)pz + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.3f, 2.0f + p.field_70170_p.field_73012_v.nextFloat(), 2, 0.05f + p.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    }
                }
                if (pointedEntity != null) {
                    px = pointedEntity.field_70165_t;
                    py = pointedEntity.field_70121_D.field_72338_b + (double)(pointedEntity.field_70131_O / 2.0f);
                    pz = pointedEntity.field_70161_v;
                    for (a = 0; a < 5; ++a) {
                        Thaumcraft.proxy.sparkle((float)px + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, (float)py + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, (float)pz + (p.field_70170_p.field_73012_v.nextFloat() - p.field_70170_p.field_73012_v.nextFloat()) * 0.6f, 2.0f + p.field_70170_p.field_73012_v.nextFloat(), 2, 0.05f + p.field_70170_p.field_73012_v.nextFloat() * 0.05f);
                    }
                }
                ItemFocusShock.shootLightning(p.field_70170_p, (EntityLivingBase)p, px, py, pz, true);
            }
        } else if (pointedEntity != null && (!(pointedEntity instanceof EntityPlayer) || MinecraftServer.func_71276_C().func_71219_W())) {
            pointedEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)p), (float)(4 + potency));
            if (p.field_70170_p.field_73012_v.nextInt(20 - Math.min(15, potency * 4)) == 0) {
                pointedEntity.func_70077_a(null);
            }
        }
    }

    @Override
    public IWandFocus.WandFocusAnimation getAnimation() {
        return IWandFocus.WandFocusAnimation.CHARGE;
    }
}

