/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.tiles.TileResearchTable;

public class PacketAspectPlaceToServer
extends AbstractPacket {
    private int dim;
    private int playerid;
    private int x;
    private int y;
    private int z;
    Aspect aspect;
    byte q;
    byte r;

    public PacketAspectPlaceToServer() {
    }

    public PacketAspectPlaceToServer(EntityPlayer player, byte q, byte r, int x, int y, int z, Aspect aspect) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.x = x;
        this.y = y;
        this.z = z;
        this.aspect = aspect;
        this.q = q;
        this.r = r;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)(this.aspect == null ? "null" : this.aspect.getTag()));
        buffer.writeByte((int)this.q);
        buffer.writeByte((int)this.r);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.aspect = Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        this.q = buffer.readByte();
        this.r = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null || player2 != null && player2.func_145782_y() != this.playerid) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (player == null) {
            return;
        }
        TileEntity rt = world.func_147438_o(this.x, this.y, this.z);
        if (rt != null && rt instanceof TileResearchTable) {
            ((TileResearchTable)rt).placeAspect(this.q, this.r, this.aspect, (EntityPlayer)player);
        }
    }
}

