/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.research;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class PlayerKnowledge {
    public Map<String, ArrayList<String>> researchCompleted = new HashMap<String, ArrayList<String>>();
    public Map<String, AspectList> aspectsDiscovered = new HashMap<String, AspectList>();
    public Map<String, ArrayList<String>> objectsScanned = new HashMap<String, ArrayList<String>>();
    public Map<String, ArrayList<String>> entitiesScanned = new HashMap<String, ArrayList<String>>();
    public Map<String, ArrayList<String>> phenomenaScanned = new HashMap<String, ArrayList<String>>();

    public void wipePlayerKnowledge(String player) {
        this.researchCompleted.remove(player);
        this.aspectsDiscovered.remove(player);
        this.objectsScanned.remove(player);
        this.entitiesScanned.remove(player);
        this.phenomenaScanned.remove(player);
    }

    public AspectList getAspectsDiscovered(String player) {
        AspectList known = this.aspectsDiscovered.get(player);
        if (known == null || known.size() <= 6) {
            this.addDiscoveredPrimalAspects(player);
            known = this.aspectsDiscovered.get(player);
        }
        return known;
    }

    public boolean hasDiscoveredAspect(String player, Aspect aspect) {
        return this.getAspectsDiscovered((String)player).aspects.containsKey(aspect);
    }

    public boolean hasDiscoveredParentAspects(String player, Aspect aspect) {
        if (aspect == null) {
            return false;
        }
        Aspect[] components = aspect.getComponents();
        if (components == null) {
            return true;
        }
        return Arrays.asList(this.getAspectsDiscovered(player).getAspects()).containsAll(Arrays.asList(components));
    }

    public void addDiscoveredPrimalAspects(String player) {
        AspectList known = this.aspectsDiscovered.get(player);
        if (known == null) {
            known = new AspectList();
        }
        if (!known.aspects.containsKey(Aspect.AIR)) {
            known.add(Aspect.AIR, 0);
        }
        if (!known.aspects.containsKey(Aspect.FIRE)) {
            known.add(Aspect.FIRE, 0);
        }
        if (!known.aspects.containsKey(Aspect.EARTH)) {
            known.add(Aspect.EARTH, 0);
        }
        if (!known.aspects.containsKey(Aspect.WATER)) {
            known.add(Aspect.WATER, 0);
        }
        if (!known.aspects.containsKey(Aspect.ORDER)) {
            known.add(Aspect.ORDER, 0);
        }
        if (!known.aspects.containsKey(Aspect.ENTROPY)) {
            known.add(Aspect.ENTROPY, 0);
        }
        this.aspectsDiscovered.put(player, known);
    }

    public boolean addDiscoveredAspect(String player, Aspect aspect) {
        AspectList known = this.getAspectsDiscovered(player);
        if (!known.aspects.containsKey(aspect)) {
            known.add(aspect, 0);
            this.aspectsDiscovered.put(player, known);
            return true;
        }
        return false;
    }

    public short getAspectPoolFor(String username, Aspect aspect) {
        AspectList known = this.getAspectsDiscovered(username);
        if (known != null) {
            return (short)known.getAmount(aspect);
        }
        return 0;
    }

    public boolean addAspectPool(String username, Aspect aspect, short amount) {
        AspectList al = this.getAspectsDiscovered(username);
        if (al == null) {
            al = new AspectList();
        }
        if (aspect != null && amount != 0) {
            boolean ret = false;
            if (amount > 0) {
                al.add(aspect, amount);
                ret = true;
            } else if (al.getAmount(aspect) > 0) {
                al.reduce(aspect, -amount);
                ret = true;
            }
            if (ret) {
                this.aspectsDiscovered.put(username, al);
            }
            return ret;
        }
        return false;
    }

    public boolean setAspectPool(String username, Aspect aspect, short amount) {
        AspectList al = this.getAspectsDiscovered(username);
        if (al == null) {
            al = new AspectList();
        }
        if (aspect != null) {
            al.aspects.put(aspect, Integer.valueOf(amount));
            this.aspectsDiscovered.put(username, al);
            return true;
        }
        return false;
    }
}

