/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.fluid;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.GolemHelper;
import thaumcraft.common.entities.golems.Marker;

public class AILiquidGather
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int waterX;
    private int waterY;
    private int waterZ;
    private ForgeDirection markerOrientation;
    private World theWorld;

    public AILiquidGather(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.field_70170_p;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.theGolem.fluidCarried != null || this.theGolem.itemWatched == null || GolemHelper.getMissingLiquids(this.theGolem).size() == 0 || !this.theGolem.func_70661_as().func_75500_f()) {
            return false;
        }
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.theGolem.homeFacing);
        ChunkCoordinates home = this.theGolem.func_110172_bL();
        int cX = home.field_71574_a - facing.offsetX;
        int cY = home.field_71572_b - facing.offsetY;
        int cZ = home.field_71573_c - facing.offsetZ;
        int camt = 0;
        if (this.theGolem.fluidCarried != null) {
            camt = this.theGolem.fluidCarried.amount;
        }
        int max = this.theGolem.getFluidCarryLimit();
        ArrayList<FluidStack> fluids = GolemHelper.getMissingLiquids(this.theGolem);
        if (fluids == null) {
            return false;
        }
        for (FluidStack fluid : fluids) {
            ArrayList<Marker> markers = GolemHelper.getMarkedFluidHandlersAdjacentToGolem(fluid, this.theWorld, this.theGolem);
            for (Marker marker : markers) {
                FluidStack fs;
                TileEntity te = this.theWorld.func_147438_o(marker.x, marker.y, marker.z);
                if (te == null || !(te instanceof IFluidHandler) || (fs = ((IFluidHandler)te).drain(ForgeDirection.getOrientation((int)marker.side), new FluidStack(fluid.getFluid(), max - camt), true)) == null || fs.amount <= 0) continue;
                if (this.theGolem.fluidCarried != null) {
                    this.theGolem.fluidCarried.amount += fs.amount;
                } else {
                    this.theGolem.fluidCarried = fs.copy();
                }
                if (fs.amount > 200) {
                    this.theWorld.func_72956_a((Entity)this.theGolem, "game.neutral.swim", 0.2f * ((float)fs.amount / (float)max), 1.0f + (this.theWorld.field_73012_v.nextFloat() - this.theWorld.field_73012_v.nextFloat()) * 0.3f);
                }
                this.theGolem.updateCarried();
                return true;
            }
            ArrayList<ChunkCoordinates> coords = GolemHelper.getMarkedBlocksAdjacentToGolem(this.theWorld, this.theGolem, (byte)-1);
            for (ChunkCoordinates loc : coords) {
                Block bi = this.theWorld.func_147439_a(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
                if (FluidRegistry.getFluid((int)fluid.fluidID).getBlock() != bi) continue;
                if (bi instanceof BlockFluidBase && ((BlockFluidBase)bi).canDrain(this.theWorld, loc.field_71574_a, loc.field_71572_b, loc.field_71573_c)) {
                    FluidStack fs = ((BlockFluidBase)bi).drain(this.theWorld, loc.field_71574_a, loc.field_71572_b, loc.field_71573_c, true);
                    if (fs == null) continue;
                    fs.amount = 1000;
                    this.theGolem.fluidCarried = fs.copy();
                    this.theWorld.func_147468_f(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
                    this.theWorld.func_72956_a((Entity)this.theGolem, "game.neutral.swim", 0.2f, 1.0f + (this.theWorld.field_73012_v.nextFloat() - this.theWorld.field_73012_v.nextFloat()) * 0.3f);
                    this.theGolem.updateCarried();
                    return true;
                }
                if (fluid.fluidID != FluidRegistry.WATER.getID() && fluid.fluidID != FluidRegistry.LAVA.getID()) continue;
                int wmd = this.theWorld.func_72805_g(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
                if ((FluidRegistry.lookupFluidForBlock((Block)bi) != FluidRegistry.WATER || fluid.fluidID != FluidRegistry.WATER.getID()) && (FluidRegistry.lookupFluidForBlock((Block)bi) != FluidRegistry.LAVA || fluid.fluidID != FluidRegistry.LAVA.getID()) || wmd != 0) continue;
                FluidStack fs = new FluidStack(fluid.fluidID, 1000);
                this.theGolem.fluidCarried = fs.copy();
                this.theWorld.func_147468_f(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
                this.theWorld.func_72956_a((Entity)this.theGolem, "game.neutral.swim", 0.2f, 1.0f + (this.theWorld.field_73012_v.nextFloat() - this.theWorld.field_73012_v.nextFloat()) * 0.3f);
                this.theGolem.updateCarried();
                this.theGolem.itemWatched = null;
                return true;
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return false;
    }

    public void func_75249_e() {
    }
}

