/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.ai.interact;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemSeedFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.lib.CustomCropHarvesting;
import thaumcraft.common.lib.FakeThaumcraftPlayer;
import thaumcraft.common.lib.Utils;

public class AIHarvestCrops
extends EntityAIBase {
    private EntityGolemBase theGolem;
    private int xx;
    private int yy;
    private int zz;
    private float movementSpeed;
    private float distance;
    private World theWorld;
    private Block block = Blocks.field_150350_a;
    private int blockMd = 0;
    private int delay = -1;
    private int maxDelay = 1;
    private int mod = 1;
    private int count = 0;

    public AIHarvestCrops(EntityGolemBase par1EntityCreature) {
        this.theGolem = par1EntityCreature;
        this.theWorld = par1EntityCreature.field_70170_p;
        this.func_75248_a(3);
        this.distance = MathHelper.func_76123_f((float)(this.theGolem.getRange() / 4.0f));
    }

    public boolean func_75250_a() {
        if (this.delay >= 0 || this.theGolem.field_70173_aa % Config.golemDelay > 0 || !this.theGolem.func_70661_as().func_75500_f()) {
            return false;
        }
        Vec3 var1 = this.findGrownCrop();
        if (var1 == null) {
            return false;
        }
        this.xx = (int)var1.field_72450_a;
        this.yy = (int)var1.field_72448_b;
        this.zz = (int)var1.field_72449_c;
        this.block = this.theWorld.func_147439_a(this.xx, this.yy, this.zz);
        this.blockMd = this.theWorld.func_72805_g(this.xx, this.yy, this.zz);
        return true;
    }

    public boolean func_75253_b() {
        return this.theWorld.func_147439_a(this.xx, this.yy, this.zz) == this.block && this.theWorld.func_72805_g(this.xx, this.yy, this.zz) == this.blockMd && this.count-- > 0 && (this.delay > 0 || !this.theGolem.func_70661_as().func_75500_f());
    }

    public void func_75246_d() {
        double dist = this.theGolem.func_70092_e((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5);
        this.theGolem.func_70671_ap().func_75650_a((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, 30.0f, 30.0f);
        if (dist <= 4.0) {
            if (this.delay < 0) {
                this.maxDelay = this.delay = (int)Math.max(10.0f, (20.0f - (float)this.theGolem.getGolemStrength() * 2.0f) * this.block.func_149712_f(this.theWorld, this.xx, this.yy, this.zz));
                this.mod = this.delay / Math.round((float)this.delay / 6.0f);
            }
            if (this.delay > 0) {
                if (--this.delay > 0 && this.delay % this.mod == 0 && this.theGolem.func_70661_as().func_75500_f()) {
                    this.theGolem.startActionTimer();
                    this.theWorld.func_72908_a((double)((float)this.xx + 0.5f), (double)((float)this.yy + 0.5f), (double)((float)this.zz + 0.5f), this.block.field_149762_H.func_150495_a(), (this.block.field_149762_H.func_150497_c() + 0.7f) / 8.0f, this.block.field_149762_H.func_150494_d() * 0.5f);
                    Utils.destroyBlockPartially(this.theWorld, this.theGolem.func_145782_y(), this.xx, this.yy, this.zz, (int)(9.0f * (1.0f - (float)this.delay / (float)this.maxDelay)));
                }
                if (this.delay == 0) {
                    this.harvest();
                    this.checkAdjacent();
                }
            }
        }
    }

    private void checkAdjacent() {
        for (int x2 = -2; x2 <= 2; ++x2) {
            for (int z2 = -2; z2 <= 2; ++z2) {
                for (int y2 = -1; y2 <= 1; ++y2) {
                    Vec3 var1;
                    int x = this.xx + x2;
                    int y = this.yy + y2;
                    int z = this.zz + z2;
                    if ((float)Math.abs(this.theGolem.func_110172_bL().field_71574_a - x) > this.distance || (float)Math.abs(this.theGolem.func_110172_bL().field_71572_b - y) > this.distance || (float)Math.abs(this.theGolem.func_110172_bL().field_71573_c - z) > this.distance || !CustomCropHarvesting.isGrownCrop(this.theWorld, x, y, z) || (var1 = this.theWorld.func_82732_R().func_72345_a((double)x, (double)y, (double)z)) == null) continue;
                    this.xx = (int)var1.field_72450_a;
                    this.yy = (int)var1.field_72448_b;
                    this.zz = (int)var1.field_72449_c;
                    this.block = this.theWorld.func_147439_a(this.xx, this.yy, this.zz);
                    this.blockMd = this.theWorld.func_72805_g(this.xx, this.yy, this.zz);
                    this.delay = -1;
                    this.func_75249_e();
                    return;
                }
            }
        }
    }

    public void func_75251_c() {
        Utils.destroyBlockPartially(this.theWorld, this.theGolem.func_145782_y(), this.xx, this.yy, this.zz, -1);
        this.delay = -1;
    }

    public void func_75249_e() {
        this.count = 200;
        this.theGolem.func_70661_as().func_75492_a((double)this.xx + 0.5, (double)this.yy + 0.5, (double)this.zz + 0.5, (double)this.theGolem.func_70689_ay());
    }

    private Vec3 findGrownCrop() {
        Random rand = this.theGolem.func_70681_au();
        int var2 = 0;
        while ((float)var2 < this.distance * 3.0f) {
            int x = (int)((float)(this.theGolem.func_110172_bL().field_71574_a + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance);
            int z = (int)((float)(this.theGolem.func_110172_bL().field_71573_c + rand.nextInt((int)(1.0f + this.distance * 2.0f))) - this.distance);
            int y = (int)((float)this.theGolem.func_110172_bL().field_71572_b - this.distance);
            while ((float)y < (float)this.theGolem.func_110172_bL().field_71572_b + this.distance) {
                if (CustomCropHarvesting.isGrownCrop(this.theWorld, x, y, z)) {
                    return this.theWorld.func_82732_R().func_72345_a((double)x, (double)y, (double)z);
                }
                ++y;
            }
            ++var2;
        }
        return null;
    }

    void harvest() {
        this.count = 200;
        int md = this.blockMd;
        if (CustomCropHarvesting.clickableCrops.containsKey(Block.func_149682_b((Block)this.block) + "/" + md)) {
            FakeThaumcraftPlayer fp = new FakeThaumcraftPlayer(this.theWorld, new GameProfile(null, "FakeThaumcraftGolem"));
            fp.func_70107_b(this.theGolem.field_70165_t, this.theGolem.field_70163_u, this.theGolem.field_70161_v);
            this.block.func_149727_a(this.theWorld, this.xx, this.yy, this.zz, (EntityPlayer)fp, 0, 0.0f, 0.0f, 0.0f);
            fp.func_70106_y();
        } else {
            this.theWorld.func_147480_a(this.xx, this.yy, this.zz, true);
            if (this.theGolem.getUpgradeAmount(4) > 0) {
                ArrayList items = new ArrayList();
                ArrayList<Entity> drops = Utils.getEntitiesInRange(this.theWorld, this.theGolem.field_70165_t, this.theGolem.field_70163_u, this.theGolem.field_70161_v, (Entity)this.theGolem, EntityItem.class, 3.0);
                if (drops.size() > 0) {
                    for (Entity e : drops) {
                        if (!(e instanceof EntityItem)) continue;
                        boolean done = false;
                        EntityItem item = (EntityItem)e;
                        ItemStack st = item.func_92059_d();
                        if (st.func_77973_b() != null && st.func_77973_b() == Items.field_151100_aR && st.func_77960_j() == 3) {
                            int par4;
                            int var5 = BlockDirectional.func_149895_l((int)this.blockMd);
                            int par2 = this.xx + Direction.field_71583_a[var5];
                            Block var6 = this.theWorld.func_147439_a(par2, this.yy, par4 = this.zz + Direction.field_71581_b[var5]);
                            if (var6 == Blocks.field_150364_r && BlockLog.func_150165_c((int)this.theWorld.func_72805_g(par2, this.yy, par4)) == 3) {
                                --st.field_77994_a;
                                this.theWorld.func_147465_d(this.xx, this.yy, this.zz, Blocks.field_150375_by, BlockDirectional.func_149895_l((int)this.blockMd), 3);
                            }
                            done = true;
                        } else if (st.func_77973_b() != null && st.func_77973_b() == ConfigItems.itemManaBean) {
                            int var5 = BlockDirectional.func_149895_l((int)this.blockMd);
                            if (this.block.func_149707_d(this.theWorld, this.xx, this.yy, this.zz, Direction.field_71582_c[var5])) {
                                --st.field_77994_a;
                                this.theWorld.func_147465_d(this.xx, this.yy, this.zz, ConfigBlocks.blockManaPod, var5, 3);
                            }
                            done = true;
                        } else if (CustomCropHarvesting.stackedCrops.containsKey(Block.func_149682_b((Block)this.block) + "/" + md)) {
                            --st.field_77994_a;
                            this.theWorld.func_147465_d(this.xx, this.yy, this.zz, this.block, md, 3);
                            done = true;
                        } else {
                            int[] xm = new int[]{0, 0, 1, 1, -1, 0, -1, -1, 1};
                            int[] zm = new int[]{0, 1, 0, 1, 0, -1, -1, 1, -1};
                            for (int count = 0; st != null && st.field_77994_a > 0 && count < 9; ++count) {
                                if (st.func_77973_b() != null && st.func_77973_b() instanceof IPlantable && this.theWorld.func_147437_c(this.xx + xm[count], this.yy, this.zz + zm[count]) && this.block == ((IPlantable)st.func_77973_b()).getPlant((IBlockAccess)this.theWorld, this.xx + xm[count], this.yy, this.zz + zm[count]) && this.theWorld.func_147439_a(this.xx + xm[count], this.yy - 1, this.zz + zm[count]).canSustainPlant((IBlockAccess)this.theWorld, this.xx + xm[count], this.yy - 1, this.zz + zm[count], ForgeDirection.UP, (IPlantable)st.func_77973_b())) {
                                    --st.field_77994_a;
                                    this.theWorld.func_147465_d(this.xx + xm[count], this.yy, this.zz + zm[count], ((IPlantable)st.func_77973_b()).getPlant((IBlockAccess)this.theWorld, this.xx + xm[count], this.yy, this.zz + zm[count]), ((IPlantable)st.func_77973_b()).getPlantMetadata((IBlockAccess)this.theWorld, this.xx + xm[count], this.yy, this.zz + zm[count]), 3);
                                    done = true;
                                    continue;
                                }
                                if (st.func_77973_b() == null || !(st.func_77973_b() instanceof ItemSeedFood)) continue;
                                FakeThaumcraftPlayer fp = new FakeThaumcraftPlayer(this.theWorld, new GameProfile(null, "FakeThaumcraftGolem"));
                                fp.func_70107_b(this.theGolem.field_70165_t, this.theGolem.field_70163_u, this.theGolem.field_70161_v);
                                ((ItemSeedFood)st.func_77973_b()).func_77648_a(st, (EntityPlayer)fp, this.theWorld, this.xx + xm[count], this.yy - 1, this.zz + zm[count], ForgeDirection.DOWN.ordinal(), 0.0f, 0.0f, 0.0f);
                                fp.func_70106_y();
                                done = true;
                            }
                        }
                        if (st.field_77994_a <= 0) {
                            item.func_70106_y();
                        } else {
                            item.func_92058_a(st);
                        }
                        if (!done) continue;
                        break;
                    }
                }
            }
        }
        this.theGolem.startActionTimer();
    }
}

