/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.events;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import thaumcraft.api.IRunicArmor;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.baubles.ItemAmuletRunic;
import thaumcraft.common.items.baubles.ItemGirdleRunic;
import thaumcraft.common.items.baubles.ItemRingRunic;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.network.fx.PacketFXShield;
import thaumcraft.common.lib.network.playerdata.PacketRunicCharge;

public class EventHandlerRunic {
    public HashMap<Integer, Integer> runicCharge = new HashMap();
    private HashMap<Integer, Long> nextCycle = new HashMap();
    private HashMap<Integer, Integer> lastCharge = new HashMap();
    public HashMap<Integer, Integer[]> runicInfo = new HashMap();
    private HashMap<String, Long> upgradeCooldown = new HashMap();
    public boolean isDirty = true;
    private int rechargeDelay = 0;

    @SubscribeEvent
    public void livingTick(LivingEvent.LivingUpdateEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (this.isDirty || player.field_70173_aa % 40 == 0) {
                int max = 0;
                int charged = 0;
                int kinetic = 0;
                int healing = 0;
                int emergency = 0;
                this.isDirty = false;
                for (int a = 0; a < 4; ++a) {
                    if (player.field_71071_by.func_70440_f(a) == null || !(player.field_71071_by.func_70440_f(a).func_77973_b() instanceof IRunicArmor)) continue;
                    int amount = EventHandlerRunic.getFinalCharge(player.field_71071_by.func_70440_f(a));
                    max += amount;
                }
                IInventory baubles = BaublesApi.getBaubles(player);
                for (int a = 0; a < 4; ++a) {
                    if (baubles.func_70301_a(a) == null || !(baubles.func_70301_a(a).func_77973_b() instanceof IRunicArmor)) continue;
                    int amount = EventHandlerRunic.getFinalCharge(baubles.func_70301_a(a));
                    if (baubles.func_70301_a(a).func_77973_b() instanceof ItemRingRunic) {
                        switch (baubles.func_70301_a(a).func_77960_j()) {
                            case 2: {
                                ++charged;
                                break;
                            }
                            case 3: {
                                ++healing;
                            }
                        }
                    } else if (baubles.func_70301_a(a).func_77973_b() instanceof ItemAmuletRunic && baubles.func_70301_a(a).func_77960_j() == 1) {
                        ++emergency;
                    } else if (baubles.func_70301_a(a).func_77973_b() instanceof ItemGirdleRunic && baubles.func_70301_a(a).func_77960_j() == 1) {
                        ++kinetic;
                    }
                    max += amount;
                }
                if (max > 0) {
                    int charge;
                    this.runicInfo.put(player.func_145782_y(), new Integer[]{max, charged, kinetic, healing, emergency});
                    if (this.runicCharge.containsKey(player.func_145782_y()) && (charge = this.runicCharge.get(player.func_145782_y()).intValue()) > max) {
                        this.runicCharge.put(player.func_145782_y(), max);
                        Thaumcraft.packetPipeline.sendTo(new PacketRunicCharge(player, (short)max, max), (EntityPlayerMP)player);
                    }
                } else {
                    this.runicInfo.remove(player.func_145782_y());
                    this.runicCharge.put(player.func_145782_y(), 0);
                    Thaumcraft.packetPipeline.sendTo(new PacketRunicCharge(player, (short)0, 0), (EntityPlayerMP)player);
                }
            }
            if (this.rechargeDelay > 0) {
                --this.rechargeDelay;
            } else if (this.runicInfo.containsKey(player.func_145782_y())) {
                if (!this.lastCharge.containsKey(player.func_145782_y())) {
                    this.lastCharge.put(player.func_145782_y(), -1);
                }
                if (!this.runicCharge.containsKey(player.func_145782_y())) {
                    this.runicCharge.put(player.func_145782_y(), 0);
                }
                if (!this.nextCycle.containsKey(player.func_145782_y())) {
                    this.nextCycle.put(player.func_145782_y(), 0L);
                }
                long time = System.currentTimeMillis();
                int charge = this.runicCharge.get(player.func_145782_y());
                if (charge > this.runicInfo.get(player.func_145782_y())[0]) {
                    charge = this.runicInfo.get(player.func_145782_y())[0];
                } else if (charge < this.runicInfo.get(player.func_145782_y())[0] && this.nextCycle.get(player.func_145782_y()) < time && WandManager.consumeVisFromInventory(player, new AspectList().add(Aspect.AIR, 20).add(Aspect.EARTH, 20))) {
                    long interval = 2000 - this.runicInfo.get(player.func_145782_y())[1] * 500;
                    this.nextCycle.put(player.func_145782_y(), time + interval);
                    this.runicCharge.put(player.func_145782_y(), ++charge);
                }
                if (this.lastCharge.get(player.func_145782_y()) != charge) {
                    Thaumcraft.packetPipeline.sendTo(new PacketRunicCharge(player, (short)charge, this.runicInfo.get(player.func_145782_y())[0]), (EntityPlayerMP)player);
                    this.lastCharge.put(player.func_145782_y(), charge);
                }
            }
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        if (event.entity instanceof EntityPlayer) {
            long time = System.currentTimeMillis();
            EntityPlayer player = (EntityPlayer)event.entity;
            if (event.source == DamageSource.field_76369_e || event.source == DamageSource.field_82727_n || event.source == DamageSource.field_76380_i || event.source == DamageSource.field_76366_f) {
                return;
            }
            if (this.runicInfo.containsKey(player.func_145782_y()) && this.runicCharge.containsKey(player.func_145782_y()) && this.runicCharge.get(player.func_145782_y()) > 0) {
                int target = -1;
                if (event.source.func_76346_g() != null) {
                    target = event.source.func_76346_g().func_145782_y();
                }
                if (event.source == DamageSource.field_76379_h) {
                    target = -2;
                }
                if (event.source == DamageSource.field_82729_p) {
                    target = -3;
                }
                Thaumcraft.packetPipeline.sendToAllAround(new PacketFXShield(event.entity.func_145782_y(), target), new NetworkRegistry.TargetPoint(event.entity.field_70170_p.field_73011_w.field_76574_g, event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v, 64.0));
                int charge = this.runicCharge.get(player.func_145782_y());
                if ((float)charge > event.ammount) {
                    charge = (int)((float)charge - event.ammount);
                    event.ammount = 0.0f;
                } else {
                    event.ammount -= (float)charge;
                    charge = 0;
                }
                String key = player.func_145782_y() + ":" + 2;
                if (!(charge > 0 || this.runicInfo.get(player.func_145782_y())[2] <= 0 || this.upgradeCooldown.containsKey(key) && this.upgradeCooldown.get(key) >= time)) {
                    this.upgradeCooldown.put(key, time + 20000L);
                    player.field_70170_p.func_72885_a((Entity)player, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, 1.5f + (float)this.runicInfo.get(player.func_145782_y())[2].intValue() * 0.5f, false, false);
                }
                key = player.func_145782_y() + ":" + 3;
                if (!(charge > 0 || this.runicInfo.get(player.func_145782_y())[3] <= 0 || this.upgradeCooldown.containsKey(key) && this.upgradeCooldown.get(key) >= time)) {
                    this.upgradeCooldown.put(key, time + 20000L);
                    player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 240, this.runicInfo.get(player.func_145782_y())[3].intValue()));
                    player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:runicShieldEffect", 1.0f, 1.0f);
                }
                key = player.func_145782_y() + ":" + 4;
                if (!(charge > 0 || this.runicInfo.get(player.func_145782_y())[4] <= 0 || this.upgradeCooldown.containsKey(key) && this.upgradeCooldown.get(key) >= time)) {
                    this.upgradeCooldown.put(key, time + 60000L);
                    int t = 8 * this.runicInfo.get(player.func_145782_y())[4];
                    charge = Math.min(this.runicInfo.get(player.func_145782_y())[0], t);
                    this.isDirty = true;
                    player.field_70170_p.func_72956_a((Entity)player, "thaumcraft:runicShieldCharge", 1.0f, 1.0f);
                }
                if (charge <= 0) {
                    this.rechargeDelay = 20;
                }
                this.runicCharge.put(player.func_145782_y(), charge);
                Thaumcraft.packetPipeline.sendTo(new PacketRunicCharge(player, (short)charge, this.runicInfo.get(player.func_145782_y())[0]), (EntityPlayerMP)player);
            }
        }
    }

    @SubscribeEvent
    public void tooltipEvent(ItemTooltipEvent event) {
        int charge = EventHandlerRunic.getFinalCharge(event.itemStack);
        if (charge > 0) {
            event.toolTip.add(EnumChatFormatting.GOLD + StatCollector.func_74838_a((String)"item.runic.charge") + " +" + charge);
        }
    }

    public static int getFinalCharge(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IRunicArmor)) {
            return 0;
        }
        IRunicArmor armor = (IRunicArmor)stack.func_77973_b();
        int base = armor.getRunicCharge(stack);
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("RS.HARDEN")) {
            base += stack.field_77990_d.func_74771_c("RS.HARDEN");
        }
        return base;
    }
}

