/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.fx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketFXEssentiaSource
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private byte dx;
    private byte dy;
    private byte dz;
    private int color;

    public PacketFXEssentiaSource() {
    }

    public PacketFXEssentiaSource(int x, int y, int z, byte dx, byte dy, byte dz, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.color = color;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.color);
        buffer.writeByte((int)this.dx);
        buffer.writeByte((int)this.dy);
        buffer.writeByte((int)this.dz);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.color = buffer.readInt();
        this.dx = buffer.readByte();
        this.dy = buffer.readByte();
        this.dz = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        int tx = this.x - this.dx;
        int ty = this.y - this.dy;
        int tz = this.z - this.dz;
        String key = this.x + ":" + this.y + ":" + this.z + ":" + tx + ":" + ty + ":" + tz + ":" + this.color;
        if (EssentiaHandler.sourceFX.containsKey(key)) {
            EssentiaHandler.EssentiaSourceFX sf = EssentiaHandler.sourceFX.get(key);
            sf.ticks = 15;
            EssentiaHandler.sourceFX.remove(key);
            EssentiaHandler.sourceFX.put(key, sf);
        } else {
            EssentiaHandler.sourceFX.put(key, new EssentiaHandler.EssentiaSourceFX(new ChunkCoordinates(this.x, this.y, this.z), new ChunkCoordinates(tx, ty, tz), 15, this.color));
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

