/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.fx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.tiles.TileInfusionMatrix;
import thaumcraft.common.tiles.TilePedestal;

public class PacketFXInfusionSource
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private byte dx;
    private byte dy;
    private byte dz;
    private int color;

    public PacketFXInfusionSource() {
    }

    public PacketFXInfusionSource(int x, int y, int z, byte dx, byte dy, byte dz, int color) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.color = color;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.color);
        buffer.writeByte((int)this.dx);
        buffer.writeByte((int)this.dy);
        buffer.writeByte((int)this.dz);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.color = buffer.readInt();
        this.dx = buffer.readByte();
        this.dy = buffer.readByte();
        this.dz = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        int tx = this.x - this.dx;
        int ty = this.y - this.dy;
        int tz = this.z - this.dz;
        String key = tx + ":" + ty + ":" + tz + ":" + this.color;
        TileEntity tile = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (tile != null && tile instanceof TileInfusionMatrix) {
            int count = 15;
            if (player.field_70170_p.func_147438_o(tx, ty, tz) != null && player.field_70170_p.func_147438_o(tx, ty, tz) instanceof TilePedestal) {
                count = 60;
            }
            TileInfusionMatrix is = (TileInfusionMatrix)tile;
            if (is.sourceFX.containsKey(key)) {
                TileInfusionMatrix.SourceFX sf = is.sourceFX.get(key);
                sf.ticks = count;
                is.sourceFX.put(key, sf);
            } else {
                HashMap<String, TileInfusionMatrix.SourceFX> hashMap = is.sourceFX;
                TileInfusionMatrix tileInfusionMatrix = is;
                tileInfusionMatrix.getClass();
                hashMap.put(key, new TileInfusionMatrix.SourceFX(tileInfusionMatrix, new ChunkCoordinates(tx, ty, tz), count, this.color));
            }
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

