/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.fx;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import thaumcraft.client.fx.FXShieldRunes;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketFXShield
extends AbstractPacket {
    private int source;
    private int target;

    public PacketFXShield() {
    }

    public PacketFXShield(int source, int target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.source);
        buffer.writeInt(this.target);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.source = buffer.readInt();
        this.target = buffer.readInt();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayer p = (EntityPlayer)player.field_70170_p.func_73045_a(this.source);
        float pitch = 0.0f;
        float yaw = 0.0f;
        if (this.target >= 0) {
            Entity t = player.field_70170_p.func_73045_a(this.target);
            if (t != null) {
                float f1;
                double d0 = p.field_70165_t - t.field_70165_t;
                double d1 = p.field_70163_u - (t.field_70163_u + (double)t.func_70047_e());
                double d2 = p.field_70161_v - t.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                float f = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
                pitch = f1 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
                yaw = f;
            } else {
                pitch = 90.0f;
                yaw = 0.0f;
            }
            FXShieldRunes fb = new FXShieldRunes(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)p, 8, yaw, pitch);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
        } else if (this.target == -1) {
            FXShieldRunes fb = new FXShieldRunes(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)p, 8, 0.0f, 90.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
            fb = new FXShieldRunes(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)p, 8, 0.0f, 270.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
        } else if (this.target == -2) {
            FXShieldRunes fb = new FXShieldRunes(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)p, 8, 0.0f, 270.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
        } else if (this.target == -3) {
            FXShieldRunes fb = new FXShieldRunes(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, (Entity)p, 8, 0.0f, 90.0f);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fb);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

