/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.biome.BiomeGenBase;
import thaumcraft.common.lib.Utils;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketBiomeChange
extends AbstractPacket {
    private int x;
    private int z;
    private short biome;

    public PacketBiomeChange() {
    }

    public PacketBiomeChange(int x, int z, short biome) {
        this.x = x;
        this.z = z;
        this.biome = biome;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.writeShort((int)this.biome);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        this.biome = buffer.readShort();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        Utils.setBiomeAt(player.field_70170_p, this.x, this.z, BiomeGenBase.func_150568_d((int)this.biome));
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

