/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.items.wands.WandManager;
import thaumcraft.common.lib.network.AbstractPacket;

public class PacketFocusChangeToServer
extends AbstractPacket {
    private int dim;
    private int playerid;
    private String focus;

    public PacketFocusChangeToServer() {
    }

    public PacketFocusChangeToServer(EntityPlayer player, String focus) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.focus = focus;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.focus);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.focus = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null || player2 != null && player2.func_145782_y() != this.playerid) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (player != null && player instanceof EntityPlayer && ((EntityPlayer)player).func_70694_bm() != null && ((EntityPlayer)player).func_70694_bm().func_77973_b() instanceof ItemWandCasting) {
            WandManager.changeFocus(((EntityPlayer)player).func_70694_bm(), (World)world, (EntityPlayer)player, this.focus);
        }
    }
}

