/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.lib.network.playerdata.PacketAspectPool;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.tiles.TileResearchTable;

public class PacketAspectCombinationToServer
extends AbstractPacket {
    private int dim;
    private int playerid;
    private int x;
    private int y;
    private int z;
    Aspect aspect1;
    Aspect aspect2;
    boolean ab1;
    boolean ab2;
    boolean ret;

    public PacketAspectCombinationToServer() {
    }

    public PacketAspectCombinationToServer(EntityPlayer player, int x, int y, int z, Aspect aspect1, Aspect aspect2, boolean ab1, boolean ab2, boolean ret) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.x = x;
        this.y = y;
        this.z = z;
        this.aspect1 = aspect1;
        this.aspect2 = aspect2;
        this.ab1 = ab1;
        this.ab2 = ab2;
        this.ret = ret;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dim);
        buffer.writeInt(this.playerid);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.aspect1.getTag());
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.aspect2.getTag());
        buffer.writeBoolean(this.ab1);
        buffer.writeBoolean(this.ab2);
        buffer.writeBoolean(this.ret);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dim = buffer.readInt();
        this.playerid = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.aspect1 = Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        this.aspect2 = Aspect.getAspect(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        this.ab1 = buffer.readBoolean();
        this.ab2 = buffer.readBoolean();
        this.ret = buffer.readBoolean();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null || player2 != null && player2.func_145782_y() != this.playerid) {
            return;
        }
        Entity player = world.func_73045_a(this.playerid);
        if (player != null && player instanceof EntityPlayer && this.aspect1 != null && this.aspect1 != null) {
            Aspect combo = ResearchManager.getCombinationResult(this.aspect1, this.aspect2);
            if ((Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect1) > 0 || this.ab1) && (Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect2) > 0 || this.ab2)) {
                TileEntity rt = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
                if (Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect1) <= 0 && this.ab1) {
                    if (rt != null && rt instanceof TileResearchTable) {
                        ((TileResearchTable)rt).bonusAspects.remove(this.aspect1, 1);
                        player.field_70170_p.func_147471_g(this.x, this.y, this.z);
                        rt.func_70296_d();
                    }
                } else {
                    Thaumcraft.proxy.playerKnowledge.addAspectPool(((EntityPlayer)player).func_70005_c_(), this.aspect1, (short)-1);
                    Thaumcraft.packetPipeline.sendTo(new PacketAspectPool(this.aspect1.getTag(), (short)0, Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect1)), (EntityPlayerMP)player);
                }
                if (Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect2) <= 0 && this.ab2) {
                    if (rt != null && rt instanceof TileResearchTable) {
                        ((TileResearchTable)rt).bonusAspects.remove(this.aspect2, 1);
                        player.field_70170_p.func_147471_g(this.x, this.y, this.z);
                        rt.func_70296_d();
                    }
                } else {
                    Thaumcraft.proxy.playerKnowledge.addAspectPool(((EntityPlayer)player).func_70005_c_(), this.aspect2, (short)-1);
                    Thaumcraft.packetPipeline.sendTo(new PacketAspectPool(this.aspect2.getTag(), (short)0, Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(((EntityPlayer)player).func_70005_c_(), this.aspect2)), (EntityPlayerMP)player);
                }
                if (combo == null || ScanManager.checkAndSyncAspectKnowledge((EntityPlayer)player, combo, 1) > 0) {
                    // empty if block
                }
                ResearchManager.scheduleSave((EntityPlayer)player);
            }
        }
    }
}

