/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.network.AbstractPacket;
import thaumcraft.common.lib.network.playerdata.PacketAspectPool;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.research.ResearchManager;

public class PacketPlayerCompleteToServer
extends AbstractPacket {
    private String key;
    private int dim;
    private String username;
    private byte type;

    public PacketPlayerCompleteToServer() {
    }

    public PacketPlayerCompleteToServer(String key, String username, int dim, byte type) {
        this.key = key;
        this.dim = dim;
        this.username = username;
        this.type = type;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.key);
        buffer.writeInt(this.dim);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.username);
        buffer.writeByte((int)this.type);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.dim = buffer.readInt();
        this.username = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.type = buffer.readByte();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player2) {
        WorldServer world = DimensionManager.getWorld((int)this.dim);
        if (world == null || player2 != null && !player2.func_70005_c_().equals(this.username)) {
            return;
        }
        EntityPlayer player = world.func_72924_a(this.username);
        if (player != null && !ResearchManager.isResearchComplete(this.username, this.key)) {
            if (ResearchManager.doesPlayerHaveRequisites(this.username, this.key)) {
                if (this.type == 0) {
                    for (Aspect a : ResearchCategories.getResearch((String)this.key).tags.getAspects()) {
                        Thaumcraft.proxy.playerKnowledge.addAspectPool(this.username, a, (short)(-ResearchCategories.getResearch((String)this.key).tags.getAmount(a)));
                        ResearchManager.scheduleSave(player);
                        Thaumcraft.packetPipeline.sendTo(new PacketAspectPool(a.getTag(), (short)(-ResearchCategories.getResearch((String)this.key).tags.getAmount(a)), Thaumcraft.proxy.playerKnowledge.getAspectPoolFor(this.username, a)), (EntityPlayerMP)player);
                    }
                    Thaumcraft.packetPipeline.sendTo(new PacketResearchComplete(this.key), (EntityPlayerMP)player);
                    Thaumcraft.proxy.getResearchManager().completeResearch(player, this.key);
                    if (ResearchCategories.getResearch((String)this.key).siblings != null) {
                        for (String sibling : ResearchCategories.getResearch((String)this.key).siblings) {
                            if (ResearchManager.isResearchComplete(this.username, sibling) || !ResearchManager.doesPlayerHaveRequisites(this.username, sibling)) continue;
                            Thaumcraft.packetPipeline.sendTo(new PacketResearchComplete(sibling), (EntityPlayerMP)player);
                            Thaumcraft.proxy.getResearchManager().completeResearch(player, sibling);
                        }
                    }
                } else if (this.type == 1) {
                    ResearchManager.createResearchNoteForPlayer((World)world, player, this.key);
                }
                world.func_72956_a((Entity)player, "thaumcraft:learn", 0.75f, 1.0f);
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(StatCollector.func_74838_a((String)"tc.researcherror"), new Object[0]));
            }
        }
    }
}

