/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.treecapitator.ConfigTreeDefinition;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TCSettings;
import bspkrs.treecapitator.fml.ThirdPartyModConfig;
import bspkrs.util.ConfigCategory;
import bspkrs.util.Configuration;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class ModConfigRegistry {
    private static ModConfigRegistry instance;
    private Map<String, ThirdPartyModConfig> userModCfgs;
    private Map<String, ThirdPartyModConfig> imcModCfgs;
    private Map<String, ThirdPartyModConfig> defaultModCfgs;

    public static ModConfigRegistry instance() {
        if (instance == null) {
            new ModConfigRegistry();
        }
        return instance;
    }

    protected ModConfigRegistry() {
        instance = this;
        this.userModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.imcModCfgs = new HashMap<String, ThirdPartyModConfig>();
        this.initDefaultModConfigs();
    }

    public void registerUserModConfig(ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering user mod config %s", tpmc.modID());
        if (!this.userModCfgs.containsKey(tpmc.modID())) {
            this.userModCfgs.put(tpmc.modID(), tpmc);
        } else {
            TCLog.warning("User config contains multiple 3rd party mod configs for mod id \"%s\".  The first entry will be used.", tpmc.modID());
        }
    }

    public void registerIMCModConfig(ThirdPartyModConfig tpmc) {
        TCLog.debug("Registering IMC mod config %s", tpmc.modID());
        if (!this.imcModCfgs.containsKey(tpmc.modID())) {
            this.imcModCfgs.put(tpmc.modID(), tpmc);
        } else {
            TCLog.warning("Mod \"%s\" sent multiple IMC messages. The first message will be used.", tpmc.modID());
        }
    }

    protected void refreshUserTagMaps() {
        for (ThirdPartyModConfig tpmc : this.userModCfgs.values()) {
            tpmc.refreshReplacementTags();
        }
    }

    protected void refreshIMCTagMaps() {
        for (ThirdPartyModConfig tpmc : this.imcModCfgs.values()) {
            tpmc.refreshReplacementTags();
        }
    }

    protected void refreshAllTagMaps() {
        this.refreshUserTagMaps();
        this.refreshIMCTagMaps();
    }

    protected void applyPrioritizedModConfigs() {
        ArrayList<ThirdPartyModConfig> finalList = new ArrayList<ThirdPartyModConfig>();
        TCLog.info("Prioritizing User and IMC mod configs...", new Object[0]);
        for (Map.Entry<String, ThirdPartyModConfig> e : this.imcModCfgs.entrySet()) {
            if (this.userModCfgs.containsKey(e.getKey()) && this.userModCfgs.get(e.getKey()).overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("IMC mod config loaded for %s.", e.getValue().modID());
        }
        for (Map.Entry<String, ThirdPartyModConfig> e : this.userModCfgs.entrySet()) {
            if (this.imcModCfgs.containsKey(e.getKey()) && !e.getValue().overrideIMC()) continue;
            finalList.add(e.getValue());
            TCLog.debug("User mod config loaded for %s.", e.getValue().modID());
        }
        TCLog.info("Getting tag replacements from configs...", new Object[0]);
        for (ThirdPartyModConfig cfg : finalList) {
            cfg.refreshReplacementTags();
        }
        TCLog.info("Registering items and trees...", new Object[0]);
        for (ThirdPartyModConfig cfg : finalList) {
            cfg.registerTools().registerTrees();
        }
    }

    protected void initDefaultModConfigs() {
        this.defaultModCfgs = new TreeMap<String, ThirdPartyModConfig>();
        this.defaultModCfgs.put("1_vanilla_trees_and_items", new ThirdPartyModConfig());
        this.defaultModCfgs.put("AppliedEnergistics", new ThirdPartyModConfig("AppliedEnergistics", "AppliedEnergistics.cfg", "", "item:appeng.toolQuartzAxe", "<item:appeng.toolQuartzAxe>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("BiomesOPlenty", new ThirdPartyModConfig("BiomesOPlenty", "BiomesOPlenty.cfg", "block:Bamboo ID; block:Colourized Leaves ID; block:Fruit Leaf Block ID; block:Leaf Block ID 1; block:Leaf Block ID 2; block:Log Block ID 1; block:Log Block ID 2; block:Log Block ID 3; block:Log Block ID 4; block:Petal ID", "item:Muddy Axe ID; item:Amethyst Axe ID", "<item:Muddy Axe ID>; <item:Amethyst Axe ID>", "", true).setOverrideIMC(false).addConfigTreeDef("vanilla_oak", new ConfigTreeDefinition("", "<block:Leaf Block ID 1>,4; <block:Leaf Block ID 1>,7; <block:Leaf Block ID 1>,12; <block:Leaf Block ID 1>,15; <block:Fruit Leaf Block ID>; <block:Leaf Block ID 2>,0; <block:Leaf Block ID 2>,8; <block:Leaf Block ID 2>,2; <block:Leaf Block ID 2>,10; 18,2; 18,10")).addConfigTreeDef("vanilla_birch", new ConfigTreeDefinition("", "<block:Leaf Block ID 1>,0; <block:Leaf Block ID 1>,8")).addConfigTreeDef("vanilla_jungle", new ConfigTreeDefinition("", "").setMaxLeafIDDist(3)).addConfigTreeDef("acacia", new ConfigTreeDefinition("<block:Log Block ID 1>,0; <block:Log Block ID 1>,4; <block:Log Block ID 1>,8", "<block:Colourized Leaves ID>,0; <block:Colourized Leaves ID>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("cherry", new ConfigTreeDefinition("<block:Log Block ID 1>,1; <block:Log Block ID 1>,5; <block:Log Block ID 1>,9", "<block:Leaf Block ID 2>,1; <block:Leaf Block ID 2>,3; <block:Leaf Block ID 2>,9; <block:Leaf Block ID 2>,11").setRequireLeafDecayCheck(false)).addConfigTreeDef("darkwood", new ConfigTreeDefinition("<block:Log Block ID 1>,2; <block:Log Block ID 1>,6; <block:Log Block ID 1>,10", "<block:Leaf Block ID 1>,3; <block:Leaf Block ID 1>,11").setRequireLeafDecayCheck(false)).addConfigTreeDef("fir", new ConfigTreeDefinition("<block:Log Block ID 1>,3; <block:Log Block ID 1>,7; <block:Log Block ID 1>,11", "<block:Leaf Block ID 1>,5; <block:Leaf Block ID 1>,13").setRequireLeafDecayCheck(false)).addConfigTreeDef("holy", new ConfigTreeDefinition("<block:Log Block ID 2>,0; <block:Log Block ID 2>,4; <block:Log Block ID 2>,8", "<block:Leaf Block ID 1>,6; <block:Leaf Block ID 1>,14").setRequireLeafDecayCheck(false)).addConfigTreeDef("magic", new ConfigTreeDefinition("<block:Log Block ID 2>,1; <block:Log Block ID 2>,5; <block:Log Block ID 2>,9", "<block:Leaf Block ID 1>,2; <block:Leaf Block ID 1>,10").setRequireLeafDecayCheck(false)).addConfigTreeDef("mangrove", new ConfigTreeDefinition("<block:Log Block ID 2>,2; <block:Log Block ID 2>,6; <block:Log Block ID 2>,10", "<block:Colourized Leaves ID>,1; <block:Colourized Leaves ID>,9").setRequireLeafDecayCheck(false)).addConfigTreeDef("palm", new ConfigTreeDefinition("<block:Log Block ID 2>,3; <block:Log Block ID 2>,7; <block:Log Block ID 2>,11", "<block:Colourized Leaves ID>,2; <block:Colourized Leaves ID>,10").setRequireLeafDecayCheck(false)).addConfigTreeDef("redwood", new ConfigTreeDefinition("<block:Log Block ID 3>,0; <block:Log Block ID 3>,4; <block:Log Block ID 3>,8", "<block:Colourized Leaves ID>,3; <block:Colourized Leaves ID>,11").setRequireLeafDecayCheck(false)).addConfigTreeDef("willow", new ConfigTreeDefinition("<block:Log Block ID 3>,1; <block:Log Block ID 3>,5; <block:Log Block ID 3>,9", "<block:Colourized Leaves ID>,4; <block:Colourized Leaves ID>,12").setRequireLeafDecayCheck(false)).addConfigTreeDef("dead", new ConfigTreeDefinition("<block:Log Block ID 3>,2; <block:Log Block ID 3>,6; <block:Log Block ID 3>,10", "")).addConfigTreeDef("big_flower", new ConfigTreeDefinition("<block:Log Block ID 3>,3; <block:Log Block ID 3>,7; <block:Log Block ID 3>,11", "<block:Petal ID>")).addConfigTreeDef("pine", new ConfigTreeDefinition("<block:Log Block ID 4>,0; <block:Log Block ID 4>,4; <block:Log Block ID 4>,8", "<block:Colourized Leaves ID>,5; <block:Colourized Leaves ID>,13").setRequireLeafDecayCheck(false)).addConfigTreeDef("hellbark", new ConfigTreeDefinition("<block:Log Block ID 4>,1; <block:Log Block ID 4>,5; <block:Log Block ID 4>,9", "<block:Leaf Block ID 2>,4; <block:Leaf Block ID 2>,12").setRequireLeafDecayCheck(false)).addConfigTreeDef("jacaranda", new ConfigTreeDefinition("<block:Log Block ID 4>,2; <block:Log Block ID 4>,6; <block:Log Block ID 4>,10", "<block:Leaf Block ID 2>,5; <block:Leaf Block ID 2>,13").setRequireLeafDecayCheck(false)));
        this.defaultModCfgs.put("DivineRPG", new ThirdPartyModConfig("DivineRPG", "DivineRPG.cfg", "block:eucalyptus", "item:Bedrock Axe; item:Crystal Axe; item:Realmite Axe; item:azuriteaxe; item:corruptedaxe; item:denseaxe; item:divineaxe; item:donatoraxe; item:energyaxe; item:mythrilaxe; item:plasmaaxe; item:serenityaxe; item:twilightaxe", "<item:Bedrock Axe>; <item:Crystal Axe>; <item:Realmite Axe>; <item:azuriteaxe>; <item:corruptedaxe>; <item:denseaxe>; <item:divineaxe>; <item:donatoraxe>; <item:energyaxe>; <item:mythrilaxe>; <item:plasmaaxe>; <item:serenityaxe>; <item:twilightaxe>", "", true).setOverrideIMC(false).addConfigTreeDef("eucalyptus", new ConfigTreeDefinition("<block:eucalyptus>", "18")));
        this.defaultModCfgs.put("ExtrabiomesXL", new ThirdPartyModConfig("ExtrabiomesXL", "extrabiomes/extrabiomes.cfg", "block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id").setOverrideIMC(false).addConfigTreeDef("vanilla_oak", new ConfigTreeDefinition("<block:quarterlog0.id>,2; <block:quarterlog1.id>,2; <block:quarterlog2.id>,2; <block:quarterlog3.id>,2;", "<block:autumnleaves.id>")).addConfigTreeDef("vanilla_spruce", new ConfigTreeDefinition("", "<block:autumnleaves.id>")).addConfigTreeDef("redwood", new ConfigTreeDefinition("<block:quarterlog0.id>,0; <block:quarterlog1.id>,0; <block:quarterlog2.id>,0; <block:quarterlog3.id>,0", "<block:greenleaves.id>,1; <block:greenleaves.id>,9").setMaxHorLeafBreakDist(10).setRequireLeafDecayCheck(false)).addConfigTreeDef("fir", new ConfigTreeDefinition("<block:customlog.id>,0; <block:quarterlog0.id>,1; <block:quarterlog1.id>,1; <block:quarterlog2.id>,1; <block:quarterlog3.id>,1", "<block:greenleaves.id>,0; <block:greenleaves.id>,8").setMaxHorLeafBreakDist(10).setRequireLeafDecayCheck(false)).addConfigTreeDef("acacia", new ConfigTreeDefinition("<block:customlog.id>,1", "<block:greenleaves.id>,2")));
        this.defaultModCfgs.put("Forestry", new ThirdPartyModConfig("Forestry", "forestry/base.conf", "block:log1; block:log2; block:log3; block:log4; block:log5; block:log6; block:log7; block:leaves").setOverrideIMC(false).addConfigTreeDef("larch", new ConfigTreeDefinition("<block:log1>,0; <block:log1>,4; <block:log1>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("teak", new ConfigTreeDefinition("<block:log1>,1; <block:log1>,5; <block:log1>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("acacia", new ConfigTreeDefinition("<block:log1>,2; <block:log1>,6; <block:log1>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("lime", new ConfigTreeDefinition("<block:log1>,3; <block:log1>,7; <block:log1>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("chestnut", new ConfigTreeDefinition("<block:log2>,0; <block:log2>,4; <block:log2>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("wenge", new ConfigTreeDefinition("<block:log2>,1; <block:log2>,5; <block:log2>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("baobab", new ConfigTreeDefinition("<block:log2>,2; <block:log2>,6; <block:log2>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("sequoia", new ConfigTreeDefinition("<block:log2>,3; <block:log2>,7; <block:log2>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("kapok", new ConfigTreeDefinition("<block:log3>,0; <block:log3>,4; <block:log3>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("ebony", new ConfigTreeDefinition("<block:log3>,1; <block:log3>,5; <block:log3>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("mahogany", new ConfigTreeDefinition("<block:log3>,2; <block:log3>,6; <block:log3>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("balsa", new ConfigTreeDefinition("<block:log3>,3; <block:log3>,7; <block:log3>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("willow", new ConfigTreeDefinition("<block:log4>,0; <block:log4>,4; <block:log4>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("walnut", new ConfigTreeDefinition("<block:log4>,1; <block:log4>,5; <block:log4>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("boojum", new ConfigTreeDefinition("<block:log4>,2; <block:log4>,6; <block:log4>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("cherry", new ConfigTreeDefinition("<block:log4>,3; <block:log4>,7; <block:log4>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("bullpine", new ConfigTreeDefinition("<block:log6>,0; <block:log6>,4; <block:log6>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("giant_sequoia", new ConfigTreeDefinition("<block:log7>,0; <block:log7>,4; <block:log7>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("datepalm", new ConfigTreeDefinition("<block:log5>,2; block:log5>,6; block:log5>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("bluemahoe", new ConfigTreeDefinition("<block:log5>,0; <block:log5>,4; <block:log5>,8", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("white_poplar", new ConfigTreeDefinition("<block:log5>,1; <block:log5>,5; <block:log5>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("lemon", new ConfigTreeDefinition("<block:log6>,3; <block:log6>,7; <block:log6>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("plum", new ConfigTreeDefinition("<block:log6>,1; <block:log6>,5; <block:log6>,9", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("papaya", new ConfigTreeDefinition("<block:log5>,3; <block:log5>,7; <block:log5>,11", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)).addConfigTreeDef("sugar_maple", new ConfigTreeDefinition("<block:log6>,2; <block:log6>,6; <block:log6>,10", "<block:leaves>,0; <block:leaves>,8").setRequireLeafDecayCheck(false)));
        this.defaultModCfgs.put("Gems_Plus", new ThirdPartyModConfig("GP", "GP.cfg", "", "item:AgateAxe; item:AmethystAxe; item:ChrysocollaAxe; item:CitrineAxe; item:EmeraldAxe; item:GarnetAxe; item:JadeAxe; item:JasperAxe; item:MalachiteAxe; item:OnyxAxe; item:PhoenixiteAxe; item:QuartzAxe; item:RubyAxe; item:SapphireAxe; item:SpinelAxe; item:SugiliteAxe; item:TopazAxe; item:TourmalineAxe", "<item:AgateAxe>; <item:AmethystAxe>; <item:ChrysocollaAxe>; <item:CitrineAxe>; <item:EmeraldAxe>; <item:GarnetAxe>; <item:JadeAxe>; <item:JasperAxe>; <item:MalachiteAxe>; <item:OnyxAxe>; <item:PhoenixiteAxe>; <item:QuartzAxe>; <item:RubyAxe>; <item:SapphireAxe>; <item:SpinelAxe>; <item:SugiliteAxe>; <item:TopazAxe>; <item:TourmalineAxe>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("GraviSuite", new ThirdPartyModConfig("GraviSuite", "GraviSuite.cfg", "", "items:advChainsawID", "<items:advChainsawID>", "", true));
        this.defaultModCfgs.put("IC2", new ThirdPartyModConfig("IC2", "IC2.cfg", "block:blockRubWood; block:blockRubLeaves", "item:itemToolBronzeAxe; item:itemToolChainsaw", "<item:itemToolBronzeAxe>; <item:itemToolChainsaw>", "<item:itemToolChainsaw>", true).setOverrideIMC(false).addConfigTreeDef("rubber", new ConfigTreeDefinition("<block:blockRubWood>", "<block:blockRubLeaves>")));
        this.defaultModCfgs.put("Mekanism", new ThirdPartyModConfig("Mekanism", "Mekanism.cfg", "", "item:BronzeAxe; item:BronzePaxel; item:DiamondPaxel; item:GlowstoneAxe; item:GlowstonePaxel; item:GoldPaxel; item:IronPaxel; item:LazuliAxe; item:LazuliPaxel; item:ObsidianAxe; item:ObsidianPaxel; item:platinumAxe; item:platinumPaxel; item:SteelAxe; item:SteelPaxel; item:StonePaxel; item:WoodPaxel; item:OsmiumAxe; item:OsmiumPaxel", "<item:BronzeAxe>; <item:BronzePaxel>; <item:DiamondPaxel>; <item:GlowstoneAxe>; <item:GlowstonePaxel>; <item:GoldPaxel>; <item:IronPaxel>; <item:LazuliAxe>; <item:LazuliPaxel>; <item:ObsidianAxe>; <item:ObsidianPaxel>; <item:PlatinumAxe>; <item:PlatinumPaxel>; <item:SteelAxe>; <item:SteelPaxel>; <item:StonePaxel>; <item:WoodPaxel>; <item:OsmiumAxe>; <item:OsmiumPaxel>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("meteors", new ThirdPartyModConfig("meteors", "meteors.cfg", "", "item:Frezarite Axe ID; item:Meteor Axe ID", "<item:Frezarite Axe ID>; <item:Meteor Axe ID>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("MineFactoryReloaded", new ThirdPartyModConfig("MineFactoryReloaded", "powercrystals/minefactoryreloaded/common.cfg", "block:ID.RubberWood; block:ID.RubberLeaves; block:ID.RubberSapling").setOverrideIMC(false).addConfigTreeDef("rubber", new ConfigTreeDefinition("<block:ID.RubberWood>", "<block:ID.RubberLeaves>")));
        this.defaultModCfgs.put("Natura", new ThirdPartyModConfig("Natura", "Natura.txt", "block:Bloodwood Block; block:Flora Leaves; block:Redwood Block; block:Sakura Leaves; block:Wood Block; block:Rare Log; block:Rare Leaves; block:Willow Log").setOverrideIMC(false).addConfigTreeDef("bloodwood", new ConfigTreeDefinition("<block:Bloodwood Block>", "<block:Sakura Leaves>,2")).addConfigTreeDef("eucalyptus", new ConfigTreeDefinition("<block:Wood Block>,0; <block:Wood Block>,4; <block:Wood Block>,8", "<block:Flora Leaves>,1; <block:Flora Leaves>,9")).addConfigTreeDef("ghostwood", new ConfigTreeDefinition("<block:Wood Block>,2; <block:Wood Block>, 6; <block:Wood Block>, 10", "<block:Sakura Leaves>,1")).addConfigTreeDef("hopseed", new ConfigTreeDefinition("<block:Wood Block>,3; <block:Wood Block>, 7; <block:Wood Block>, 11", "<block:Flora Leaves>,2")).addConfigTreeDef("redwood", new ConfigTreeDefinition("<block:Redwood Block>", "<block:Flora Leaves>,0")).addConfigTreeDef("sakura", new ConfigTreeDefinition("<block:Wood Block>, 1; <block:Wood Block>, 5; <block:Wood Block>, 9", "<block:Sakura Leaves>,0; <block:Sakura Leaves>,8")).addConfigTreeDef("amaranth", new ConfigTreeDefinition("<block:Rare Log>,2; <block:Rare Log>,6; <block:Rare Log>,10", "<block:Rare Leaves>,2; <block:Rare Leaves>,10")).addConfigTreeDef("maple", new ConfigTreeDefinition("<block:Rare Log>,0; <block:Rare Log>,4; <block:Rare Log>,8", "<block:Rare Leaves>,0; <block:Rare Leaves>,8")).addConfigTreeDef("siverbell", new ConfigTreeDefinition("<block:Rare Log>,1; <block:Rare Log>,5; <block:Rare Log>,9", "<block:Rare Leaves>,1; <block:Rare Leaves>,9")).addConfigTreeDef("tigerwood", new ConfigTreeDefinition("<block:Rare Log>,3; <block:Rare Log>,7; <block:Rare Log>,11", "<block:Rare Leaves>,3; <block:Rare Leaves>,11")).addConfigTreeDef("willow", new ConfigTreeDefinition("<block:Willow Log>", "<block:Sakura Leaves>,3; <block:Sakura Leaves>,11; <block:Sakura Leaves>,15").setMaxHorLeafBreakDist(5)));
        this.defaultModCfgs.put("Railcraft", new ThirdPartyModConfig("Railcraft", "railcraft/railcraft.cfg", "", "item:tool.steel.axe", "<item:tool.steel.axe>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("RedPowerWorld", new ThirdPartyModConfig("RedPowerWorld", "redpower/redpower.cfg", "blocks.world:log.id; blocks.world:leaves.id", "items.world:axeRuby.id; items.world:axeGreenSapphire.id; items.world:axeSapphire.id", "<items.world:axeRuby.id>; <items.world:axeGreenSapphire.id>; <items.world:axeSapphire.id>", "", true).setOverrideIMC(false).addConfigTreeDef("rubber", new ConfigTreeDefinition("<blocks.world:log.id>", "<blocks.world:leaves.id>")));
        this.defaultModCfgs.put("Thaumcraft", new ThirdPartyModConfig("Thaumcraft", "Thaumcraft.cfg", "block:BlockMagicalLog; block:BlockMagicalLeaves", "item:Thaumaxe", "<item:Thaumaxe>", "", true).setOverrideIMC(false).addConfigTreeDef("greatwood", new ConfigTreeDefinition("<block:BlockMagicalLog>,0; <block:BlockMagicalLog>,4; <block:BlockMagicalLog>,8", "<block:BlockMagicalLeaves>,0; <block:BlockMagicalLeaves>,8")).addConfigTreeDef("silverwood", new ConfigTreeDefinition("<block:BlockMagicalLog>,1; <block:BlockMagicalLog>,5; <block:BlockMagicalLog>,9", "<block:BlockMagicalLeaves>,1; <block:BlockMagicalLeaves>,9")));
        this.defaultModCfgs.put("TConstruct", new ThirdPartyModConfig("TConstruct", "TinkersWorkshop.txt", "", "tools:Axe; tools:Lumber Axe; tools:Mattock", "<tools:Axe>; <tools:Lumber Axe>; <tools:Mattock>", "", true).setOverrideIMC(false));
        this.defaultModCfgs.put("TwilightForest", new ThirdPartyModConfig("TwilightForest", "TwilightForest.cfg", "block:Log; block:MagicLog; block:Leaves; block:MagicLeaves; block:MagicLogSpecial; block:Hedge", "item:IronwoodAxe; item:SteeleafAxe; item:MinotaurAxe", "<item:IronwoodAxe>; <item:SteeleafAxe>; <item:MinotaurAxe>", "", true).setOverrideIMC(false).addConfigTreeDef("oak", new ConfigTreeDefinition("<block:Log>,0; <block:Log>,4; <block:Log>,8; <block:Log>,12", "<block:Leaves>,0; <block:Leaves>,3; <block:Leaves>,8; <block:Leaves>,11")).addConfigTreeDef("canopy", new ConfigTreeDefinition("<block:Log>,1; <block:Log>,5; <block:Log>,9; <block:Log>,13", "<block:Leaves>, 1; <block:Leaves>,9")).addConfigTreeDef("mangrove", new ConfigTreeDefinition("<block:Log>,2; <block:Log>,6; <block:Log>,10; <block:Log>,14", "<block:Leaves>, 2; <block:Leaves>,10")).addConfigTreeDef("darkwood", new ConfigTreeDefinition("<block:Log>,3; <block:Log>,7; <block:Log>,11;  <block:Log>,15", "<block:Hedge>,1").setMaxLeafIDDist(2).setRequireLeafDecayCheck(false).setMaxHorLeafBreakDist(5)).addConfigTreeDef("time", new ConfigTreeDefinition("<block:MagicLog>,0; <block:MagicLog>,4; <block:MagicLog>,8; <block:MagicLog>,12; <block:MagicLogSpecial>,0", "<block:MagicLeaves>,0; <block:MagicLeaves>,8")).addConfigTreeDef("transformation", new ConfigTreeDefinition("<block:MagicLog>,1; <block:MagicLog>,5; <block:MagicLog>,9; <block:MagicLog>,13; <block:MagicLogSpecial>,1", "<block:MagicLeaves>,1; <block:MagicLeaves>,9")).addConfigTreeDef("miner", new ConfigTreeDefinition("<block:MagicLog>,2; <block:MagicLog>,6; <block:MagicLog>,10; <block:MagicLog>,14; <block:MagicLogSpecial>,2", "<block:MagicLeaves>,2; <block:MagicLeaves>,10").setOnlyDestroyUpwards(false)).addConfigTreeDef("sorting", new ConfigTreeDefinition("<block:MagicLog>,3; <block:MagicLog>,7; <block:MagicLog>,11; <block:MagicLog>,15; <block:MagicLogSpecial>,3", "<block:MagicLeaves>,3; <block:MagicLeaves>,11")));
    }

    public Map<String, ThirdPartyModConfig> defaultConfigs() {
        return new TreeMap<String, ThirdPartyModConfig>(this.defaultModCfgs);
    }

    public void syncConfiguration(Configuration config) {
        TCSettings.idResolverModID = config.getString("idResolverModID", "tree_and_mod_configs", TCSettings.idResolverModID, "The mod ID value for ID Resolver.");
        TCSettings.multiMineModID = config.getString("multiMineID", "tree_and_mod_configs", TCSettings.multiMineModID, "The mod ID value for Multi-Mine.");
        TCSettings.userConfigOverridesIMC = config.getBoolean("userConfigOverridesIMC", "tree_and_mod_configs", TCSettings.userConfigOverridesIMC, "This setting controls the default behavior when a mod is both configured manually (in the config file) and \nby the mod itself via IMC (inter-mod communication).");
        TCLog.configs(config, "tree_and_mod_configs");
        config.addCustomCategoryComment("tree_and_mod_configs", "This category is where all your settings live that are related to 3rd party mods. There are two methods \nto set up a 3rd party mod's trees and items: \n\n(1) Config Method: uses the mod's config file to lookup block ID and item ID values. 3rd party config \nsettings tell TreeCapitator how to find a mod's config, what config values we need (log/leaf blocks, \naxes, etc), how to use those values to define the mod's trees (if applicable), and what kind of tools the \nitems are (if applicable).\n\n(2) Integer IDs Method: alternatively you can always just use the integer block and item IDs to define what \na tree or axe is.\n\nKeep in mind that you can also include certain settings on a per-tree basis to override the global values.\n\nFormat:\n    <section_name> { (typically same as modID)\n        S:modID=<modID> (this can be found on the Mods screen in game or in mcmod.info)\n        S:configPath=<path to config file relative to .minecraft/config/> (most of the time this is the same as <modID>.cfg)\n        S:blockConfigKeys=<block config category>:<property name>; block:customLogBlockID; block:customLeafBlockID (config category is usually \"block\")\n        S:itemConfigKeys=<item config category>:<property name>; item:superAwesomeAxeShearsID (config category is usually \"item\")\n        S:axeIDList=<<item config category>:<property name>>; <item:superAwesomeAxeShearsID>\n        S:shearsIDList=<item:superAwesomeAxeShearsID>\n        B:useShiftedItemID=<(optional, defaults to true) whether or not to use the +256 shifted item ID> (true/false, almost always true)\n        B:overrideIMC=<optional, defaults to false) whether or not a mod's user config (this file) should override a mod's IMC config (IMC allows mods to send messages to each other for compatibility)\n\n        <tree_name> { (the tree name is just for organization and clarity)\n            # logConfigKeys/leafConfigKeys: list of config key tags or raw integer block ID values. \",\" separates ID and metadata, \";\" separates block entries\n            S:logConfigKeys=<<block config category>:<property name>>; <block:customLogBlockID>,0; 17,0\n            S:leafConfigKeys=<<block config category>:<property name>>; <block:customLeafBlockID>,0; 18\n            (per-tree settings)\n\n        }\n    }\n\nExamples:\n    ic2_using_config_method {\n        S:modID=IC2\n        S:configPath=IC2.cfg\n        S:blockConfigKeys=block:blockRubWood; block:blockRubLeaves\n        S:itemConfigKeys=item:itemToolBronzeAxe; item:itemToolChainsaw\n        S:axeIDList=<item:itemToolBronzeAxe>; <item:itemToolChainsaw>\n        S:shearsIDList=<item:itemToolChainsaw>\n        B:useShiftedItemID=true\n\n        rubber {\n            S:logConfigKeys=<block:blockRubWood>\n            S:leafConfigKeys=<block:blockRubLeaves>\n        }\n    }\n\n    ic2_using_integer_method {\n        S:modID=IC2\n        S:configPath=IC2.cfg\n        S:blockConfigKeys=\n        S:itemConfigKeys=\n        S:axeIDList=30199; 30233\n        S:shearsIDList=30233\n\n        rubber {\n            S:logConfigKeys=243\n            S:leafConfigKeys=242\n        }\n    }");
        if (!config.hasCategory("tree_and_mod_configs.1_vanilla_trees_and_items")) {
            Map<String, ThirdPartyModConfig> m = this.defaultConfigs();
            for (Map.Entry<String, ThirdPartyModConfig> e : m.entrySet()) {
                e.getValue().writeToConfiguration(config, "tree_and_mod_configs." + e.getKey());
            }
            TCLog.info("Looks like a fresh config; default config loaded.", new Object[0]);
        } else {
            TCLog.info("Proceeding to load tree/mod configs from file.", new Object[0]);
        }
        config.addCustomCategoryComment("tree_and_mod_configs.1_vanilla_trees_and_items", "This special category is the home of the vanilla tree block and item configurations. You can change the \nvalues in this category to suit your preferences.\n\nWARNING: This config category must not be removed! If this category is renamed or removed TreeCapitator \nwill assume your config file is new and reload the default user mod config settings!");
        for (String ctgy : config.getCategoryNames()) {
            ConfigCategory cc = config.getCategory(ctgy);
            if (ctgy.indexOf("tree_and_mod_configs.") == -1 || !cc.containsKey("modID") || !Loader.isModLoaded((String)cc.get("modID").getString())) continue;
            TCLog.debug("Loading file config for mod %s (config category %s)...", cc.get("modID").getString(), ctgy);
            this.registerUserModConfig(new ThirdPartyModConfig(config, ctgy));
        }
    }

    protected void imcSendMessageBoP() {
        if (Loader.isModLoaded((String)"TreeCapitator")) {
            by tpModCfg = new by();
            tpModCfg.a("modID", "BiomesOPlenty");
            tpModCfg.a("configPath", "BiomesOPlenty.cfg");
            tpModCfg.a("blockConfigKeys", "block:Bamboo ID; block:Colourized Leaves ID; block:Fruit Leaf Block ID; block:Leaf Block ID 1; block:Leaf Block ID 2; block:Log Block ID 1; block:Log Block ID 2; block:Log Block ID 3; block:Log Block ID 4; block:Petal ID");
            tpModCfg.a("itemConfigKeys", "item:Muddy Axe ID; item:Amethyst Axe ID");
            tpModCfg.a("axeIDList", "<item:Muddy Axe ID>; <item:Amethyst Axe ID>");
            tpModCfg.a("shearsIDList", "");
            tpModCfg.a("useShiftedItemID", true);
            cg treeList = new cg();
            by tree = new by();
            tree.a("treeName", "vanilla_oak");
            tree.a("logConfigKeys", "");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,4; <block:Leaf Block ID 1>,7; <block:Leaf Block ID 1>,12; <block:Leaf Block ID 1>,15; <block:Fruit Leaf Block ID>; <block:Leaf Block ID 2>,0; <block:Leaf Block ID 2>,8; <block:Leaf Block ID 2>,2; <block:Leaf Block ID 2>,10");
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "vanilla_birch");
            tree.a("logConfigKeys", "");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,0; <block:Leaf Block ID 1>,8");
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "acacia");
            tree.a("logConfigKeys", "<block:Log Block ID 1>,0; <block:Log Block ID 1>,4; <block:Log Block ID 1>,8");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,0; <block:Colourized Leaves ID>,8");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "cherry");
            tree.a("logConfigKeys", "<block:Log Block ID 1>,1; <block:Log Block ID 1>,5; <block:Log Block ID 1>,9");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 2>,1; <block:Leaf Block ID 2>,3; <block:Leaf Block ID 2>,9; <block:Leaf Block ID 2>,11");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "darkwood");
            tree.a("logConfigKeys", "<block:Log Block ID 1>,2; <block:Log Block ID 1>,6; <block:Log Block ID 1>,10");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,3; <block:Leaf Block ID 1>,11");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "fir");
            tree.a("logConfigKeys", "<block:Log Block ID 1>,3; <block:Log Block ID 1>,7; <block:Log Block ID 1>,11");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,5; <block:Leaf Block ID 1>,13");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "holy");
            tree.a("logConfigKeys", "<block:Log Block ID 2>,0; <block:Log Block ID 2>,4; <block:Log Block ID 2>,8");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,6; <block:Leaf Block ID 1>,14");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "magic");
            tree.a("logConfigKeys", "<block:Log Block ID 2>,1; <block:Log Block ID 2>,5; <block:Log Block ID 2>,9");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,2; <block:Leaf Block ID 1>,10");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "mangrove");
            tree.a("logConfigKeys", "<block:Log Block ID 2>,2; <block:Log Block ID 2>,6; <block:Log Block ID 2>,10");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,1; <block:Colourized Leaves ID>,9");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "palm");
            tree.a("logConfigKeys", "<block:Log Block ID 2>,3; <block:Log Block ID 2>,7; <block:Log Block ID 2>,11");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,2; <block:Colourized Leaves ID>,10");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "redwood");
            tree.a("logConfigKeys", "<block:Log Block ID 3>,0; <block:Log Block ID 3>,4; <block:Log Block ID 3>,8");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,3; <block:Colourized Leaves ID>,11");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "willow");
            tree.a("logConfigKeys", "<block:Log Block ID 3>,1; <block:Log Block ID 3>,5; <block:Log Block ID 3>,9");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,4; <block:Colourized Leaves ID>,12");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "dead");
            tree.a("logConfigKeys", "<block:Log Block ID 3>,2; <block:Log Block ID 3>,6; <block:Log Block ID 3>,10");
            tree.a("leafConfigKeys", "");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "big_flower");
            tree.a("logConfigKeys", "<block:Log Block ID 3>,3; <block:Log Block ID 3>,7; <block:Log Block ID 3>,11");
            tree.a("leafConfigKeys", "<block:Petal ID>");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "pine");
            tree.a("logConfigKeys", "<block:Log Block ID 4>,0; <block:Log Block ID 4>,4; <block:Log Block ID 4>,8");
            tree.a("leafConfigKeys", "<block:Colourized Leaves ID>,5; <block:Colourized Leaves ID>,13");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "hellbark");
            tree.a("logConfigKeys", "<block:Log Block ID 4>,1; <block:Log Block ID 4>,5; <block:Log Block ID 4>,9");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 2>,4; <block:Leaf Block ID 2>,12");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "jacaranda");
            tree.a("logConfigKeys", "<block:Log Block ID 4>,2; <block:Log Block ID 4>,6; <block:Log Block ID 4>,10");
            tree.a("leafConfigKeys", "<block:Leaf Block ID 1>,5; <block:Leaf Block ID 1>,13");
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tpModCfg.a("trees", (cl)treeList);
            FMLInterModComms.sendMessage((String)"TreeCapitator", (String)"ThirdPartyModConfig", (by)tpModCfg);
        }
    }

    protected void imcSendMessageEBXL() {
        if (Loader.isModLoaded((String)"TreeCapitator")) {
            by tpModCfg = new by();
            tpModCfg.a("modID", "ExtraBiomesXL");
            tpModCfg.a("configPath", "extrabiomes/extrabiomes.cfg");
            tpModCfg.a("blockConfigKeys", "block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id");
            tpModCfg.a("itemConfigKeys", "");
            tpModCfg.a("axeIDList", "");
            tpModCfg.a("shearsIDList", "");
            tpModCfg.a("useShiftedItemID", true);
            cg treeList = new cg();
            by tree = new by();
            tree.a("treeName", "vanilla_oak");
            tree.a("logConfigKeys", "<block:quarterlog0.id>,2; <block:quarterlog1.id>,2; <block:quarterlog2.id>,2; <block:quarterlog3.id>,2;");
            tree.a("leafConfigKeys", "<block:autumnleaves.id>");
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "vanilla_spruce");
            tree.a("logConfigKeys", "");
            tree.a("leafConfigKeys", "<block:autumnleaves.id>");
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "fir");
            tree.a("logConfigKeys", "<block:customlog.id>,0; <block:quarterlog0.id>,1; <block:quarterlog1.id>,1; <block:quarterlog2.id>,1; <block:quarterlog3.id>,1");
            tree.a("leafConfigKeys", "<block:greenleaves.id>,0; <block:greenleaves.id>,8");
            tree.a("maxHorLeafBreakDist", 10);
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "redwood");
            tree.a("logConfigKeys", "<block:quarterlog0.id>,0; <block:quarterlog1.id>,0; <block:quarterlog2.id>,0; <block:quarterlog3.id>,0");
            tree.a("leafConfigKeys", "<block:greenleaves.id>,1; <block:greenleaves.id>,9");
            tree.a("maxHorLeafBreakDist", 10);
            tree.a("requireLeafDecayCheck", false);
            treeList.a((cl)tree);
            tree = new by();
            tree.a("treeName", "acacia");
            tree.a("logConfigKeys", "<block:customlog.id>,1");
            tree.a("leafConfigKeys", "<block:greenleaves.id>,2");
            treeList.a((cl)tree);
            tpModCfg.a("trees", (cl)treeList);
            FMLInterModComms.sendMessage((String)"TreeCapitator", (String)"ThirdPartyModConfig", (by)tpModCfg);
        }
    }
}

