/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;

public abstract class AbstractConduit
implements IConduit {
    protected final Set conduitConnections = new HashSet();
    protected final Set externalConnections = new HashSet();
    public static final float STUB_WIDTH = 0.2f;
    public static final float STUB_HEIGHT = 0.2f;
    public static final float TRANSMISSION_SCALE = 0.3f;
    protected IConduitBundle bundle;
    protected boolean active;
    protected List collidables;
    protected final EnumMap conectionModes = new EnumMap(ForgeDirection.class);
    protected boolean collidablesDirty = true;
    private boolean clientStateDirty = true;
    private boolean dodgyChangeSinceLastCallFlagForBundle = true;
    private int lastNumConections = -1;

    protected AbstractConduit() {
    }

    @Override
    public ConnectionMode getConectionMode(ForgeDirection dir) {
        ConnectionMode res = (ConnectionMode)((Object)this.conectionModes.get(dir));
        if (res == null) {
            return ConnectionMode.IN_OUT;
        }
        return res;
    }

    @Override
    public boolean hasConnectionMode(ConnectionMode mode) {
        for (ConnectionMode cm : this.conectionModes.values()) {
            if (cm != mode) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean haveCollidablesChangedSinceLastCall() {
        if (this.dodgyChangeSinceLastCallFlagForBundle) {
            this.dodgyChangeSinceLastCallFlagForBundle = false;
            return true;
        }
        return false;
    }

    @Override
    public BlockCoord getLocation() {
        if (this.bundle == null) {
            return null;
        }
        aqp te = this.bundle.getEntity();
        if (te == null) {
            return null;
        }
        return new BlockCoord(te.l, te.m, te.n);
    }

    @Override
    public void setBundle(IConduitBundle tileConduitBundle) {
        this.bundle = tileConduitBundle;
    }

    @Override
    public IConduitBundle getBundle() {
        return this.bundle;
    }

    @Override
    public Set getConduitConnections() {
        return this.conduitConnections;
    }

    @Override
    public boolean containsConduitConnection(ForgeDirection dir) {
        return this.conduitConnections.contains(dir);
    }

    @Override
    public void conduitConnectionAdded(ForgeDirection fromDirection) {
        this.conduitConnections.add(fromDirection);
        this.connectionsChanged();
    }

    @Override
    public void conduitConnectionRemoved(ForgeDirection fromDirection) {
        this.conduitConnections.remove(fromDirection);
        this.connectionsChanged();
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit conduit) {
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction) {
        return false;
    }

    @Override
    public Set getExternalConnections() {
        return this.externalConnections;
    }

    @Override
    public boolean containsExternalConnection(ForgeDirection dir) {
        return this.externalConnections.contains(dir);
    }

    @Override
    public void externalConnectionAdded(ForgeDirection fromDirection) {
        this.externalConnections.add(fromDirection);
        this.connectionsChanged();
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        this.externalConnections.remove(fromDirection);
        this.connectionsChanged();
    }

    @Override
    public boolean isConnectedTo(ForgeDirection dir) {
        return this.containsConduitConnection(dir) || this.containsExternalConnection(dir);
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (active != this.active) {
            this.clientStateDirty = true;
        }
        this.active = active;
    }

    @Override
    public void writeToNBT(bs nbtRoot) {
        int i;
        int[] dirs = new int[this.conduitConnections.size()];
        Iterator cons = this.conduitConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = ((ForgeDirection)cons.next()).ordinal();
        }
        nbtRoot.a("connections", dirs);
        dirs = new int[this.externalConnections.size()];
        cons = this.externalConnections.iterator();
        for (i = 0; i < dirs.length; ++i) {
            dirs[i] = ((ForgeDirection)cons.next()).ordinal();
        }
        nbtRoot.a("externalConnections", dirs);
        nbtRoot.a("signalActive", this.active);
        if (this.conectionModes.size() > 0) {
            byte[] modes = new byte[6];
            int i2 = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                modes[i2] = (byte)this.getConectionMode(dir).ordinal();
                ++i2;
            }
            nbtRoot.a("conModes", modes);
        }
    }

    @Override
    public void readFromNBT(bs nbtRoot) {
        int i;
        int i2;
        this.conduitConnections.clear();
        int[] dirs = nbtRoot.k("connections");
        for (i2 = 0; i2 < dirs.length; ++i2) {
            this.conduitConnections.add(ForgeDirection.values()[dirs[i2]]);
        }
        this.externalConnections.clear();
        dirs = nbtRoot.k("externalConnections");
        for (i2 = 0; i2 < dirs.length; ++i2) {
            this.externalConnections.add(ForgeDirection.values()[dirs[i2]]);
        }
        this.active = nbtRoot.n("signalActive");
        this.conectionModes.clear();
        byte[] modes = nbtRoot.j("conModes");
        if (modes != null && modes.length == 6) {
            i = 0;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                this.conectionModes.put(dir, ConnectionMode.values()[modes[i]]);
                ++i;
            }
        }
        if ((dirs = nbtRoot.k("extractDirs")) != null) {
            for (i = 0; i < dirs.length; ++i) {
                this.conectionModes.put(ForgeDirection.values()[dirs[i]], ConnectionMode.INPUT);
            }
        }
    }

    @Override
    public int getLightValue() {
        return 0;
    }

    @Override
    public boolean onBlockActivated(sq player, RaytraceResult res) {
        return false;
    }

    @Override
    public float getSelfIlluminationForState(CollidableComponent component) {
        return this.isActive() ? 1.0f : 0.0f;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return 0.3f;
    }

    @Override
    public void onChunkUnload(aab worldObj) {
        AbstractConduitNetwork network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
    }

    @Override
    public void updateEntity(aab world) {
        if (world.I) {
            return;
        }
        this.updateNetwork(world);
        if (this.clientStateDirty) {
            this.getBundle().dirty();
            this.clientStateDirty = false;
        }
    }

    protected void connectionsChanged() {
        this.collidablesDirty = true;
        this.clientStateDirty = true;
        this.dodgyChangeSinceLastCallFlagForBundle = true;
    }

    protected void setClientStateDirty() {
        this.clientStateDirty = true;
    }

    protected void updateNetwork(aab world) {
        if (this.getNetwork() == null) {
            ConduitUtil.ensureValidNetwork(this);
        }
        if (this.getNetwork() != null) {
            this.getNetwork().onUpdateEntity(this);
        }
    }

    @Override
    public void onAddedToBundle() {
        aqp te = this.bundle.getEntity();
        aab world = te.k;
        this.conduitConnections.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IConduit neighbour = ConduitUtil.getConduit((aak)world, te, dir, this.getBaseConduitType());
            if (neighbour == null || !neighbour.canConnectToConduit(dir.getOpposite(), this)) continue;
            this.conduitConnections.add(dir);
            neighbour.conduitConnectionAdded(dir.getOpposite());
        }
        this.externalConnections.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.containsConduitConnection(dir) || !this.canConnectToExternal(dir)) continue;
            this.externalConnectionAdded(dir);
        }
        this.connectionsChanged();
    }

    @Override
    public void onRemovedFromBundle() {
        aqp te = this.bundle.getEntity();
        aab world = te.k;
        for (ForgeDirection dir : this.conduitConnections) {
            IConduit neighbour = ConduitUtil.getConduit((aak)world, te, dir, this.getBaseConduitType());
            if (neighbour == null) continue;
            neighbour.conduitConnectionRemoved(dir.getOpposite());
        }
        this.conduitConnections.clear();
        if (!this.externalConnections.isEmpty()) {
            world.f(te.l, te.m, te.n, EnderIO.blockConduitBundle.cz);
        }
        this.externalConnections.clear();
        AbstractConduitNetwork network = this.getNetwork();
        if (network != null) {
            network.destroyNetwork();
        }
        this.connectionsChanged();
    }

    @Override
    public boolean onNeighborBlockChange(int blockId) {
        if (blockId == EnderIO.blockConduitBundle.cz) {
            return false;
        }
        boolean externalConnectionsChanged = false;
        ArrayList copy = new ArrayList(this.externalConnections);
        for (ForgeDirection dir : copy) {
            if (this.canConnectToExternal(dir)) continue;
            this.externalConnectionRemoved(dir);
            externalConnectionsChanged = true;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (this.conduitConnections.contains(dir) || this.externalConnections.contains(dir) || !this.canConnectToExternal(dir)) continue;
            this.externalConnectionAdded(dir);
            externalConnectionsChanged = true;
        }
        if (externalConnectionsChanged) {
            this.connectionsChanged();
        }
        return externalConnectionsChanged;
    }

    @Override
    public Collection createCollidables(CollidableCache.CacheKey key) {
        return Collections.singletonList(new CollidableComponent(this.getBaseConduitType(), ConduitGeometryUtil.instance.getBoundingBox(this.getBaseConduitType(), key.dir, key.isStub, key.offset), key.dir, null));
    }

    @Override
    public List getCollidableComponents() {
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        ArrayList result = new ArrayList();
        CollidableCache cc = CollidableCache.instance;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Collection col = this.getCollidables(dir);
            if (col == null) continue;
            result.addAll(col);
        }
        this.collidables = result;
        this.collidablesDirty = false;
        return result;
    }

    private Collection getCollidables(ForgeDirection dir) {
        CollidableCache cc = CollidableCache.instance;
        Class type = this.getBaseConduitType();
        if (this.isConnectedTo(dir)) {
            return cc.getCollidables(cc.createKey(type, this.getBundle().getOffset(type, dir), dir, false), this);
        }
        return null;
    }
}

