/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractConduitNetwork {
    protected final List conduits = new ArrayList();

    protected AbstractConduitNetwork() {
    }

    public void init(IConduitBundle tile, Collection connections, aab world) {
        if (world.I) {
            throw new UnsupportedOperationException();
        }
        for (IConduit con : connections) {
            AbstractConduitNetwork network = con.getNetwork();
            if (network == null) continue;
            network.destroyNetwork();
        }
        this.setNetwork(world, tile);
        this.notifyNetworkOfUpdate();
    }

    public abstract Class getBaseConduitType();

    protected void setNetwork(aab world, IConduitBundle tile) {
        IConduit conduit = tile.getConduit(this.getBaseConduitType());
        if (conduit.setNetwork(this)) {
            this.addConduit(conduit);
            aqp te = tile.getEntity();
            Collection connections = ConduitUtil.getConnectedConduits((aak)world, te.l, te.m, te.n, this.getBaseConduitType());
            for (IConduit con : connections) {
                if (con.getNetwork() != null) continue;
                this.setNetwork(world, con.getBundle());
            }
        }
    }

    public void addConduit(IConduit con) {
        this.conduits.add(con);
    }

    public void destroyNetwork() {
        for (IConduit con : this.conduits) {
            con.setNetwork(null);
        }
        this.conduits.clear();
    }

    public List getConduits() {
        return this.conduits;
    }

    public void notifyNetworkOfUpdate() {
        for (IConduit con : this.conduits) {
            aqp te = con.getBundle().getEntity();
            te.k.j(te.l, te.m, te.n);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IConduit con : this.conduits) {
            sb.append(con.getLocation());
            sb.append(", ");
        }
        return "AbstractConduitNetwork [conduits=" + sb.toString() + "]";
    }

    public void onUpdateEntity(IConduit conduit) {
    }
}

