/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.MpsUtil;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduitNetwork;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;

public class ConduitUtil {
    public static final Random RANDOM = new Random();

    public static AbstractConduitNetwork createNetworkForType(Class type) {
        if (IRedstoneConduit.class.isAssignableFrom(type)) {
            return new RedstoneConduitNetwork();
        }
        if (IPowerConduit.class.isAssignableFrom(type)) {
            return new PowerConduitNetwork();
        }
        if (ILiquidConduit.class.isAssignableFrom(type)) {
            return new LiquidConduitNetwork();
        }
        FMLCommonHandler.instance().raiseException((Throwable)new Exception("Could not determine network type for class " + type), "ConduitUtil.createNetworkForType", false);
        return null;
    }

    public static void ensureValidNetwork(IConduit conduit) {
        aqp te = conduit.getBundle().getEntity();
        aab world = te.k;
        Collection connections = ConduitUtil.getConnectedConduits((aak)world, te.l, te.m, te.n, conduit.getBaseConduitType());
        if (ConduitUtil.reuseNetwork(conduit, connections, world)) {
            return;
        }
        AbstractConduitNetwork res = ConduitUtil.createNetworkForType(conduit.getBaseConduitType());
        res.init(conduit.getBundle(), connections, world);
    }

    private static boolean reuseNetwork(IConduit con, Collection connections, aab world) {
        AbstractConduitNetwork network = null;
        for (IConduit conduit : connections) {
            if (network == null) {
                network = conduit.getNetwork();
                continue;
            }
            if (network == conduit.getNetwork()) continue;
            return false;
        }
        if (network == null) {
            return false;
        }
        con.setNetwork(network);
        network.addConduit(con);
        network.notifyNetworkOfUpdate();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static IConduitBundle.FacadeRenderState getRequiredFacadeRenderState(IConduitBundle bundle, sq player) {
        if (!bundle.hasFacade()) {
            return IConduitBundle.FacadeRenderState.NONE;
        }
        if (ConduitUtil.isFacadeHidden(bundle, player)) {
            return IConduitBundle.FacadeRenderState.WIRE_FRAME;
        }
        return IConduitBundle.FacadeRenderState.FULL;
    }

    public static boolean isSolidFacadeRendered(IConduitBundle bundle, sq player) {
        return bundle.getFacadeId() > 0 && !ConduitUtil.isFacadeHidden(bundle, player);
    }

    public static boolean isFacadeHidden(IConduitBundle bundle, sq player) {
        return bundle.getFacadeId() > 0 && (ConduitUtil.isToolEquipped(player) || ConduitUtil.isConduitEquipped(player));
    }

    public static boolean isConduitEquipped(sq player) {
        sq sq2 = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        wm equipped = player.cd();
        if (equipped == null) {
            return false;
        }
        return equipped.b() instanceof IConduitItem;
    }

    public static boolean isToolEquipped(sq player) {
        sq sq2 = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return false;
        }
        wm equipped = player.cd();
        if (equipped == null) {
            return false;
        }
        if (MpsUtil.instance.isPowerFistEquiped(equipped)) {
            return MpsUtil.instance.isOmniToolActive(equipped);
        }
        return equipped.b() instanceof IToolWrench;
    }

    public static IConduit getConduit(aak world, int x, int y, int z, Class type) {
        if (world == null) {
            return null;
        }
        aqp te = world.r(x, y, z);
        if (te instanceof IConduitBundle) {
            IConduitBundle con = (IConduitBundle)te;
            return con.getConduit(type);
        }
        return null;
    }

    public static IConduit getConduit(aak world, aqp te, ForgeDirection dir, Class type) {
        return ConduitUtil.getConduit(world, te.l + dir.offsetX, te.m + dir.offsetY, te.n + dir.offsetZ, type);
    }

    public static Collection getConnectedConduits(aak world, int x, int y, int z, Class type) {
        aqp te = world.r(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return Collections.emptyList();
        }
        ArrayList<IConduit> result = new ArrayList<IConduit>();
        IConduitBundle root = (IConduitBundle)te;
        for (ForgeDirection dir : root.getAllConnections()) {
            IConduit con = ConduitUtil.getConduit(world, root.getEntity(), dir, type);
            if (con == null) continue;
            result.add(con);
        }
        return result;
    }

    public static void writeToNBT(IConduit conduit, bs conduitRoot) {
        if (conduit == null) {
            return;
        }
        bs conduitBody = new bs();
        conduit.writeToNBT(conduitBody);
        conduitRoot.a("conduitType", conduit.getClass().getCanonicalName());
        conduitRoot.a("conduit", conduitBody);
    }

    public static IConduit readConduitFromNBT(bs conduitRoot) {
        IConduit result;
        String typeName = conduitRoot.i("conduitType");
        bs conduitBody = conduitRoot.l("conduit");
        if (typeName == null || conduitBody == null) {
            return null;
        }
        try {
            result = (IConduit)Class.forName(typeName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create an instance of the conduit with name: " + typeName, e);
        }
        result.readFromNBT(conduitBody);
        return result;
    }
}

