/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import buildcraft.api.power.IPowerProvider;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.geom.Offsets;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.power.MutablePowerProvider;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;

public class TileConduitBundle
extends aqp
implements IConduitBundle {
    private final List conduits = new ArrayList();
    private int facadeId = -1;
    private int facadeMeta = 0;
    private boolean facadeChanged;
    private final List cachedCollidables = new ArrayList();
    private boolean conduitsDirty = true;
    private boolean collidablesDirty = true;
    private int lightOpacity = 0;
    @SideOnly(value=Side.CLIENT)
    private IConduitBundle.FacadeRenderState facadeRenderAs;

    public TileConduitBundle() {
        this.q = EnderIO.blockConduitBundle;
    }

    @Override
    public void dirty() {
        this.conduitsDirty = true;
        this.collidablesDirty = true;
    }

    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        ca conduitTags = new ca();
        for (IConduit conduit : this.conduits) {
            bs conduitRoot = new bs();
            ConduitUtil.writeToNBT(conduit, conduitRoot);
            conduitTags.a((cf)conduitRoot);
        }
        nbtRoot.a("conduits", (cf)conduitTags);
        nbtRoot.a("facadeId", this.facadeId);
        nbtRoot.a("facadeMeta", this.facadeMeta);
    }

    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.conduits.clear();
        ca conduitTags = nbtRoot.m("conduits");
        for (int i = 0; i < conduitTags.c(); ++i) {
            bs conduitTag = (bs)conduitTags.b(i);
            IConduit conduit = ConduitUtil.readConduitFromNBT(conduitTag);
            if (conduit == null) continue;
            conduit.setBundle(this);
            this.conduits.add(conduit);
        }
        this.facadeId = nbtRoot.e("facadeId");
        this.facadeMeta = nbtRoot.e("facadeMeta");
    }

    @Override
    public boolean hasFacade() {
        return this.facadeId > 0;
    }

    @Override
    public void setFacadeId(int blockID, boolean triggerUpdate) {
        this.facadeId = blockID;
        if (triggerUpdate) {
            this.facadeChanged = true;
        }
    }

    @Override
    public void setFacadeId(int blockID) {
        this.setFacadeId(blockID, true);
    }

    @Override
    public int getFacadeId() {
        return this.facadeId;
    }

    @Override
    public void setFacadeMetadata(int meta) {
        this.facadeMeta = meta;
    }

    @Override
    public int getFacadeMetadata() {
        return this.facadeMeta;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IConduitBundle.FacadeRenderState getFacadeRenderedAs() {
        if (this.facadeRenderAs == null) {
            this.facadeRenderAs = IConduitBundle.FacadeRenderState.NONE;
        }
        return this.facadeRenderAs;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setFacadeRenderAs(IConduitBundle.FacadeRenderState state) {
        this.facadeRenderAs = state;
    }

    @Override
    public int getLightOpacity() {
        return this.lightOpacity;
    }

    @Override
    public void setLightOpacity(int opacity) {
        this.lightOpacity = opacity;
    }

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    public void onChunkUnload() {
        for (IConduit conduit : this.conduits) {
            conduit.onChunkUnload(this.k);
        }
    }

    public void h() {
        for (IConduit conduit : this.conduits) {
            conduit.updateEntity(this.k);
        }
        if (this.k != null && !this.k.I && this.conduitsDirty) {
            this.k.j(this.l, this.m, this.n);
            this.conduitsDirty = false;
        }
        if (this.k != null && this.facadeChanged) {
            this.k.p(this.l, this.m, this.n);
            this.facadeChanged = false;
        }
    }

    public BlockCoord getLocation() {
        return new BlockCoord(this.l, this.m, this.n);
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        boolean needsUpdate = false;
        for (IConduit conduit : this.conduits) {
            needsUpdate |= conduit.onNeighborBlockChange(blockId);
        }
        if (needsUpdate) {
            this.dirty();
        }
    }

    @Override
    public TileConduitBundle getEntity() {
        return this;
    }

    @Override
    public boolean hasType(Class type) {
        return this.getConduit(type) != null;
    }

    @Override
    public IConduit getConduit(Class type) {
        if (type == null) {
            return null;
        }
        for (IConduit conduit : this.conduits) {
            if (!type.isInstance(conduit)) continue;
            return conduit;
        }
        return null;
    }

    @Override
    public void addConduit(IConduit conduit) {
        if (this.k.I) {
            return;
        }
        this.conduits.add(conduit);
        conduit.setBundle(this);
        conduit.onAddedToBundle();
        this.dirty();
    }

    @Override
    public void removeConduit(IConduit conduit) {
        if (conduit != null) {
            this.removeConduit(conduit, true);
        }
    }

    public void removeConduit(IConduit conduit, boolean notify) {
        if (this.k.I) {
            return;
        }
        conduit.onRemovedFromBundle();
        this.conduits.remove(conduit);
        conduit.setBundle(null);
        if (notify) {
            this.dirty();
        }
    }

    @Override
    public void onBlockRemoved() {
        if (this.k.I) {
            return;
        }
        ArrayList copy = new ArrayList(this.conduits);
        for (IConduit con : copy) {
            this.removeConduit(con, false);
        }
        this.dirty();
    }

    @Override
    public Collection getConduits() {
        return this.conduits;
    }

    @Override
    public Set getConnections(Class type) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.getConduitConnections();
        }
        return null;
    }

    @Override
    public boolean containsConnection(Class type, ForgeDirection dir) {
        IConduit con = this.getConduit(type);
        if (con != null) {
            return con.containsConduitConnection(dir);
        }
        return false;
    }

    @Override
    public boolean containsConnection(ForgeDirection dir) {
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set getAllConnections() {
        HashSet result = new HashSet();
        for (IConduit con : this.conduits) {
            result.addAll(con.getConduitConnections());
        }
        return result;
    }

    @Override
    public Offset getOffset(Class type, ForgeDirection dir) {
        boolean isVertical;
        if (this.getConnectionCount(dir) < 2) {
            return Offset.NONE;
        }
        if (dir == ForgeDirection.UNKNOWN) {
            if (this.containsOnlySingleVerticalConnections()) {
                return Offsets.get(type, true, false);
            }
            if (this.containsOnlySingleHorizontalConnections()) {
                return Offsets.get(type, false, true);
            }
            return Offsets.get(type, true, true);
        }
        boolean bl = isVertical = dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
        if (isVertical) {
            return Offsets.get(type, false, true);
        }
        return Offsets.get(type, true, false);
    }

    @Override
    public List getCollidableComponents() {
        for (IConduit con : this.conduits) {
            this.collidablesDirty = this.collidablesDirty || con.haveCollidablesChangedSinceLastCall();
        }
        if (!this.collidablesDirty && !this.cachedCollidables.isEmpty()) {
            return this.cachedCollidables;
        }
        this.cachedCollidables.clear();
        for (IConduit conduit : this.conduits) {
            this.cachedCollidables.addAll(conduit.getCollidableComponents());
        }
        this.addConnectors(this.cachedCollidables);
        this.collidablesDirty = false;
        return this.cachedCollidables;
    }

    @Override
    public List getConnectors() {
        ArrayList result = new ArrayList();
        this.addConnectors(result);
        return result;
    }

    private void addConnectors(List result) {
        if (this.conduits.isEmpty()) {
            return;
        }
        CollidableCache cc = CollidableCache.instance;
        if (this.conduits.size() == 1) {
            IConduit con = (IConduit)this.conduits.get(0);
            result.addAll(cc.getCollidables(cc.createKey(con.getBaseConduitType(), Offset.NONE, ForgeDirection.UNKNOWN, false), con));
        } else if (this.containsOnlySingleVerticalConnections()) {
            if (this.allDirectionsHaveSameConnectionCount()) {
                for (IConduit con : this.conduits) {
                    Class type = con.getBaseConduitType();
                    result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(type, ForgeDirection.UNKNOWN), ForgeDirection.UNKNOWN, false), con));
                }
            } else {
                result.add(new CollidableComponent(null, ConduitGeometryUtil.instance.getBoundingBox(ConduitConnectorType.VERTICAL), ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.VERTICAL));
            }
        } else if (this.containsOnlySingleHorizontalConnections()) {
            if (this.allDirectionsHaveSameConnectionCount()) {
                for (IConduit con : this.conduits) {
                    Class type = con.getBaseConduitType();
                    result.addAll(cc.getCollidables(cc.createKey(type, this.getOffset(type, ForgeDirection.UNKNOWN), ForgeDirection.UNKNOWN, false), con));
                }
            } else {
                result.add(new CollidableComponent(null, ConduitGeometryUtil.instance.getBoundingBox(ConduitConnectorType.HORIZONTAL), ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.HORIZONTAL));
            }
        } else {
            result.add(new CollidableComponent(null, ConduitGeometryUtil.instance.getBoundingBox(ConduitConnectorType.BOTH), ForgeDirection.UNKNOWN, (Object)ConduitConnectorType.BOTH));
        }
    }

    private boolean containsOnlySingleVerticalConnections() {
        return this.getConnectionCount(ForgeDirection.UP) < 2 && this.getConnectionCount(ForgeDirection.DOWN) < 2;
    }

    private boolean containsOnlySingleHorizontalConnections() {
        return this.getConnectionCount(ForgeDirection.WEST) < 2 && this.getConnectionCount(ForgeDirection.EAST) < 2 && this.getConnectionCount(ForgeDirection.NORTH) < 2 && this.getConnectionCount(ForgeDirection.SOUTH) < 2;
    }

    private boolean allDirectionsHaveSameConnectionCount() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            boolean hasCon = ((IConduit)this.conduits.get(0)).isConnectedTo(dir);
            for (int i = 1; i < this.conduits.size(); ++i) {
                if (hasCon == ((IConduit)this.conduits.get(i)).isConnectedTo(dir)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean containsOnlyHorizontalConnections() {
        for (IConduit con : this.conduits) {
            for (ForgeDirection dir : con.getConduitConnections()) {
                if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) continue;
                return false;
            }
            for (ForgeDirection dir : con.getExternalConnections()) {
                if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) continue;
                return false;
            }
        }
        return true;
    }

    private int getConnectionCount(ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return this.conduits.size();
        }
        int result = 0;
        for (IConduit con : this.conduits) {
            if (!con.containsConduitConnection(dir) && !con.containsExternalConnection(dir)) continue;
            ++result;
        }
        return result;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        IPowerConduit pc = (IPowerConduit)this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getPowerHandler();
        }
        return null;
    }

    @Override
    public void doWork() {
        IPowerConduit pc = (IPowerConduit)this.getConduit(IPowerConduit.class);
        if (pc != null) {
            pc.doWork();
        }
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        IPowerConduit pc = (IPowerConduit)this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.powerRequest(from);
        }
        return 0;
    }

    @Override
    public void applyPerdition() {
        IPowerConduit pc = (IPowerConduit)this.getConduit(IPowerConduit.class);
        if (pc != null) {
            pc.applyPerdition();
        }
    }

    @Override
    public MutablePowerProvider getPowerHandler() {
        IPowerConduit pc = (IPowerConduit)this.getConduit(IPowerConduit.class);
        if (pc != null) {
            return pc.getPowerHandler();
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.fill(from, resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.fill(tankIndex, resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.getTanks(direction);
        }
        return null;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        ILiquidConduit lc = (ILiquidConduit)this.getConduit(ILiquidConduit.class);
        if (lc != null) {
            return lc.getTank(direction, type);
        }
        return null;
    }
}

