/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.Offset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;

public class CollidableCache {
    public static final CollidableCache instance = new CollidableCache();
    private final Map cache = new HashMap();

    public CacheKey createKey(Class baseType, Offset offset, ForgeDirection dir, boolean isStub) {
        return new CacheKey(baseType, offset, dir, isStub);
    }

    public Collection getCollidables(CacheKey key, IConduit conduit) {
        Collection result = (Collection)this.cache.get(key);
        if (result == null) {
            result = conduit.createCollidables(key);
            this.cache.put(key, result);
        }
        return result;
    }

    public static class CacheKey {
        public final Class baseType;
        public final String className;
        public final Offset offset;
        public final ForgeDirection dir;
        public final boolean isStub;

        public CacheKey(Class baseType, Offset offset, ForgeDirection dir, boolean isStub) {
            this.baseType = baseType;
            this.className = baseType.getCanonicalName();
            this.offset = offset;
            this.dir = dir;
            this.isStub = isStub;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
            result = 31 * result + (this.isStub ? 1231 : 1237);
            result = 31 * result + (this.offset == null ? 0 : this.offset.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.dir != other.dir) {
                return false;
            }
            if (this.isStub != other.isStub) {
                return false;
            }
            return this.offset == other.offset;
        }
    }
}

