/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.GeometryKey;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.render.BoundingBox;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector3d;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;

public class ConduitGeometryUtil {
    public static final ConduitGeometryUtil instance = new ConduitGeometryUtil();
    public static float STUB_WIDTH = 0.2f;
    public static float STUB_HEIGHT = 0.2f;
    public static float WIDTH;
    public static float HEIGHT;
    public static float HWIDTH;
    public static float HHEIGHT;
    public static Vector3d CORE_MIN;
    public static Vector3d CORE_MAX;
    public static BoundingBox CORE_BOUNDS;
    private Map boundsCache = new HashMap();
    private EnumMap connectorBounds = new EnumMap(ConduitConnectorType.class);

    public static void setupBounds(float scale) {
        float size;
        WIDTH = size = 0.075f + 0.175f * scale;
        HEIGHT = size;
        HWIDTH = WIDTH / 2.0f;
        HHEIGHT = HEIGHT / 2.0f;
        CORE_MIN = new Vector3d(0.5f - HWIDTH, 0.5 - (double)HHEIGHT, 0.5 - (double)HWIDTH);
        CORE_MAX = new Vector3d(ConduitGeometryUtil.CORE_MIN.x + (double)WIDTH, ConduitGeometryUtil.CORE_MIN.y + (double)HEIGHT, ConduitGeometryUtil.CORE_MIN.z + (double)WIDTH);
        CORE_BOUNDS = new BoundingBox(CORE_MIN, CORE_MAX);
    }

    private ConduitGeometryUtil() {
    }

    public BoundingBox getBoundingBox(ConduitConnectorType type) {
        BoundingBox result = (BoundingBox)this.connectorBounds.get((Object)type);
        if (result == null) {
            result = this.createConnector(type);
            result = result.scale(1.2f, 1.2f, 1.2f);
            this.connectorBounds.put(type, result);
        }
        return result;
    }

    private BoundingBox createConnector(ConduitConnectorType type) {
        float distance = WIDTH + HWIDTH;
        switch (type) {
            case VERTICAL: {
                return new BoundingBox(0.5 - (double)HWIDTH, 0.5 - (double)distance, 0.5 - (double)HWIDTH, 0.5 + (double)HWIDTH, 0.5 + (double)distance, 0.5 + (double)HWIDTH);
            }
            case HORIZONTAL: {
                return new BoundingBox(0.5 - (double)distance, 0.5 - (double)HWIDTH, 0.5 - (double)HWIDTH, 0.5 + (double)distance, 0.5 + (double)HWIDTH, 0.5 + (double)HWIDTH);
            }
            case BOTH: {
                return this.createConnector(ConduitConnectorType.VERTICAL).expandBy(this.createConnector(ConduitConnectorType.HORIZONTAL));
            }
        }
        return CORE_BOUNDS;
    }

    public BoundingBox getBoundingBox(Class type, ForgeDirection dir, boolean isStub, Offset offset) {
        GeometryKey key = new GeometryKey(dir, isStub, offset, type);
        BoundingBox result = (BoundingBox)this.boundsCache.get(key);
        if (result == null) {
            result = this.createConduitBounds(type, key);
            this.boundsCache.put(key, result);
        }
        return result;
    }

    public Vector3d getTranslation(ForgeDirection dir, Offset offset) {
        Vector3d result = new Vector3d(offset.xOffset, offset.yOffset, 0.0);
        result.scale(WIDTH);
        return result;
    }

    private BoundingBox createConduitBounds(Class type, GeometryKey key) {
        return this.createConduitBounds(type, key.dir, key.isStub, key.offset);
    }

    private BoundingBox createConduitBounds(Class type, ForgeDirection dir, boolean isStub, Offset offset) {
        BoundingBox bb = CORE_BOUNDS;
        Vector3d min = bb.getMin();
        Vector3d max = bb.getMax();
        switch (dir) {
            case WEST: {
                min.x = isStub ? (double)Math.max(0.0f, bb.minX - STUB_WIDTH) : 0.0;
                max.x = bb.minX;
                break;
            }
            case EAST: {
                min.x = bb.maxX;
                max.x = isStub ? (double)Math.min(1.0f, bb.maxX + STUB_WIDTH) : 1.0;
                break;
            }
            case DOWN: {
                min.y = isStub ? (double)Math.max(0.0f, bb.minY - STUB_HEIGHT) : 0.0;
                max.y = bb.minY;
                break;
            }
            case UP: {
                max.y = isStub ? (double)Math.min(1.0f, bb.maxY + STUB_HEIGHT) : 1.0;
                min.y = bb.maxY;
                break;
            }
            case NORTH: {
                min.z = isStub ? (double)Math.max(0.0f, bb.minZ - STUB_WIDTH) : 0.0;
                max.z = bb.minZ;
                break;
            }
            case SOUTH: {
                max.z = isStub ? (double)Math.min(1.0f, bb.maxZ + STUB_WIDTH) : 1.0;
                min.z = bb.maxZ;
                break;
            }
        }
        Vector3d trans = this.getTranslation(dir, offset);
        min.add(trans);
        max.add(trans);
        bb = new BoundingBox(VecmathUtil.clamp(min, 0.0, 1.0), VecmathUtil.clamp(max, 0.0, 1.0));
        return bb;
    }

    static {
        ConduitGeometryUtil.setupBounds(0.5f);
    }
}

