/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class ConduitTank
implements ILiquidTank {
    private LiquidStack fluid;
    private int capacity;
    private int tankPressure = 0;

    ConduitTank(int capacity) {
        this.capacity = capacity;
    }

    public int getFluidAmount() {
        return this.fluid == null ? 0 : this.fluid.amount;
    }

    public float getFilledRatio() {
        if (this.getFluidAmount() <= 0) {
            return 0.0f;
        }
        if (this.getCapacity() <= 0) {
            return -1.0f;
        }
        float res = (float)this.getFluidAmount() / (float)this.getCapacity();
        return res;
    }

    public boolean isFull() {
        return this.getFluidAmount() >= this.getCapacity();
    }

    public void setAmount(int amount) {
        if (this.fluid != null) {
            this.fluid.amount = amount;
        }
    }

    public int getAvailableSpace() {
        return this.getCapacity() - this.getFluidAmount();
    }

    public void addAmount(int amount) {
        this.setAmount(this.getFluidAmount() + amount);
    }

    public LiquidStack getLiquid() {
        return this.fluid;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setLiquid(LiquidStack liquid) {
        this.fluid = liquid;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
        if (this.getFluidAmount() > capacity) {
            this.setAmount(capacity);
        }
    }

    public int fill(LiquidStack resource, boolean doFill) {
        if (resource == null || resource.itemID <= 0) {
            return 0;
        }
        if (this.fluid == null || this.fluid.itemID <= 0) {
            if (resource.amount <= this.capacity) {
                if (doFill) {
                    this.setLiquid(resource.copy());
                }
                return resource.amount;
            }
            if (doFill) {
                this.fluid = resource.copy();
                this.fluid.amount = this.capacity;
            }
            return this.capacity;
        }
        if (!this.fluid.isLiquidEqual(resource)) {
            return 0;
        }
        int space = this.capacity - this.fluid.amount;
        if (resource.amount <= space) {
            if (doFill) {
                this.addAmount(resource.amount);
            }
            return resource.amount;
        }
        if (doFill) {
            this.fluid.amount = this.capacity;
        }
        return space;
    }

    public LiquidStack drain(int maxDrain, boolean doDrain) {
        if (this.fluid == null || this.fluid.itemID <= 0) {
            return null;
        }
        if (this.fluid.amount <= 0) {
            return null;
        }
        int used = maxDrain;
        if (this.fluid.amount < used) {
            used = this.fluid.amount;
        }
        if (doDrain) {
            this.addAmount(-used);
        }
        LiquidStack drained = new LiquidStack(this.fluid.itemID, used);
        if (this.fluid.amount < 0) {
            this.fluid.amount = 0;
        }
        return drained;
    }

    public void setTankPressure(int pressure) {
        this.tankPressure = pressure;
    }

    public String getLiquidName() {
        return this.fluid != null ? LiquidDictionary.findLiquidName((LiquidStack)this.fluid) : null;
    }

    public boolean containsValidLiquid() {
        return LiquidDictionary.findLiquidName((LiquidStack)this.fluid) != null;
    }

    public bs writeToNBT(bs nbt) {
        if (this.containsValidLiquid()) {
            this.fluid.writeToNBT(nbt);
        } else {
            nbt.a("emptyTank", "");
        }
        return nbt;
    }

    public ILiquidTank readFromNBT(bs nbt) {
        LiquidStack liquid;
        if (!nbt.b("emptyTank") && (liquid = LiquidStack.loadLiquidStackFromNBT((bs)nbt)) != null) {
            this.setLiquid(liquid);
        }
        return this;
    }

    public int getTankPressure() {
        return 0;
    }
}

