/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.LiquidConduitNetwork;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneSwitch;
import crazypants.enderio.machine.reservoir.TileReservoir;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidConduit
extends AbstractConduit
implements ILiquidConduit {
    static final Map ICONS = new HashMap();
    private LiquidConduitNetwork network;
    private ConduitTank tank = new ConduitTank(0);
    private float lastSyncRatio = -99.0f;
    private int currentPushToken;
    private long lastEmptyTick = 0L;
    private int numEmptyEvents = 0;
    private boolean stateDirty = false;
    private int maxDrainPerTick = 50;
    private ForgeDirection startPushDir = ForgeDirection.DOWN;
    private final Set filledFromThisTick = new HashSet();

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(ly register) {
                ICONS.put("enderio:liquidConduit", register.a("enderio:liquidConduit"));
                ICONS.put("enderio:liquidConduitCore", register.a("enderio:liquidConduitCore"));
                ICONS.put("enderio:liquidConduitExtract", register.a("enderio:liquidConduitExtract"));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public boolean onBlockActivated(sq player, RaytraceResult res) {
        if (player.cd() == null) {
            return false;
        }
        if (ConduitUtil.isToolEquipped(player)) {
            if (!this.getBundle().getEntity().k.I) {
                ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.e);
                if (res.component != null) {
                    ForgeDirection connDir = res.component.dir;
                    if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                        ILiquidConduit neighbour = this.getFluidConduit(faceHit);
                        if (neighbour != null && LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), neighbour.getFluidType())) {
                            if (neighbour.getNetwork() != null) {
                                neighbour.getNetwork().destroyNetwork();
                            }
                            if (this.getNetwork() != null) {
                                this.getNetwork().destroyNetwork();
                            }
                            neighbour.conduitConnectionAdded(faceHit.getOpposite());
                            this.conduitConnectionAdded(faceHit);
                        }
                    } else if (this.containsExternalConnection(connDir)) {
                        this.setExtractingFromDir(connDir, !this.isExtractingFromDir(connDir));
                    }
                }
            } else {
                String str = player.q.I ? "[Client]" : "[Server]";
                System.out.println(str + " LiquidConduit.onBlockActivated: Tank volume is: " + this.tank.getCapacity() + " tank contains: " + this.tank.getFluidAmount() + " filled ratio is: " + this.tank.getFilledRatio());
            }
            return true;
        }
        if (player.cd().c == wk.ax.cp) {
            if (!this.getBundle().getEntity().k.I) {
                long curTick = this.getBundle().getEntity().k.I();
                this.numEmptyEvents = curTick - this.lastEmptyTick < 20L ? ++this.numEmptyEvents : 1;
                this.lastEmptyTick = curTick;
                if (this.numEmptyEvents < 2) {
                    this.tank.setAmount(0);
                } else if (this.network != null) {
                    this.network.setFluidType(null);
                    this.numEmptyEvents = 0;
                }
            }
            return true;
        }
        LiquidStack fluid = LiquidContainerRegistry.getLiquidForFilledItem((wm)player.cd());
        if (fluid != null) {
            if (!(this.getBundle().getEntity().k.I || this.network == null || this.network.getFluidType() != null && this.network.getTotalVolume() >= 500)) {
                this.network.setFluidType(fluid);
                player.a("Fluid type set to " + LiquidDictionary.findLiquidName((LiquidStack)fluid));
            }
            return true;
        }
        return false;
    }

    @Override
    public void updateEntity(aab world) {
        super.updateEntity(world);
        if (world.I) {
            return;
        }
        this.filledFromThisTick.clear();
        this.updateStartPushDir();
        this.doExtract();
        if (this.stateDirty || this.lastSyncRatio != this.tank.getFilledRatio() && world.H() % 2L == 0L) {
            this.lastSyncRatio = this.tank.getFilledRatio();
            this.setActive(this.lastSyncRatio > 0.0f);
            this.getBundle().dirty();
            this.stateDirty = false;
        }
    }

    private void doExtract() {
        BlockCoord loc = this.getLocation();
        if (!this.isPowered() || !this.hasConnectionMode(ConnectionMode.INPUT)) {
            return;
        }
        int token = this.network == null ? -1 : this.network.getNextPushToken();
        for (ForgeDirection dir : this.externalConnections) {
            LiquidStack drained;
            LiquidStack couldDrain;
            ITankContainer extTank;
            if (!this.isExtractingFromDir(dir) || (extTank = this.getTankContainer(this.getLocation().getLocation(dir))) == null || (couldDrain = extTank.drain(dir.getOpposite(), this.maxDrainPerTick, false)) == null || couldDrain.amount <= 0) continue;
            int requiredPush = this.tank.getFluidAmount() + couldDrain.amount - this.tank.getCapacity();
            if (requiredPush <= 0) {
                LiquidStack drained2 = extTank.drain(dir.getOpposite(), this.maxDrainPerTick, true);
                if (drained2 == null) continue;
                this.tank.fill(drained2, true);
                continue;
            }
            int pushed = this.pushLiquid(dir, requiredPush, true, token);
            this.tank.addAmount(-pushed);
            if (this.tank.getAvailableSpace() <= 0 || (drained = extTank.drain(dir.getOpposite(), Math.min(this.tank.getAvailableSpace(), this.maxDrainPerTick), true)) == null) continue;
            this.tank.addAmount(drained.amount);
        }
    }

    private boolean isPowered() {
        BlockCoord loc = this.getLocation();
        IRedstoneConduit rsCon = (IRedstoneConduit)this.getBundle().getConduit(IRedstoneConduit.class);
        if (rsCon instanceof RedstoneSwitch && ((RedstoneSwitch)rsCon).isActive()) {
            return true;
        }
        return this.getBundle().getEntity().k.C(loc.x, loc.y, loc.z);
    }

    @Override
    public boolean canOutputToDir(ForgeDirection dir) {
        if (this.conduitConnections.contains(dir)) {
            return true;
        }
        if (!this.externalConnections.contains(dir)) {
            return false;
        }
        if (this.isExtractingFromDir(dir)) {
            return false;
        }
        ITankContainer ext = this.getExternalHandler(dir);
        if (ext instanceof TileReservoir) {
            TileReservoir tr = (TileReservoir)ext;
            return !tr.isMultiblock() || !tr.isAutoEject();
        }
        return true;
    }

    @Override
    public boolean isExtractingFromDir(ForgeDirection dir) {
        return this.getConectionMode(dir) == ConnectionMode.INPUT;
    }

    @Override
    public void setExtractingFromDir(ForgeDirection dir, boolean extracting) {
        if (this.isExtractingFromDir(dir) == extracting) {
            return;
        }
        if (!extracting) {
            this.conectionModes.remove(dir);
        } else {
            this.conectionModes.put(dir, ConnectionMode.INPUT);
        }
        this.stateDirty = true;
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection fromDirection) {
        super.externalConnectionRemoved(fromDirection);
        this.setExtractingFromDir(fromDirection, false);
    }

    @Override
    public void setFluidType(LiquidStack liquidType) {
        if (this.tank.getLiquid() != null && this.tank.getLiquid().isLiquidEqual(liquidType)) {
            return;
        }
        if (liquidType != null) {
            liquidType = liquidType.copy();
        }
        this.tank.setLiquid(liquidType);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.filledFromThisTick.contains(this.getLocation().getLocation(from))) {
            return 0;
        }
        this.filledFromThisTick.add(this.getLocation().getLocation(from));
        int res = this.fill(from, resource, doFill, true, this.network == null ? -1 : this.network.getNextPushToken());
        if (doFill && this.externalConnections.contains(from) && this.network != null) {
            this.network.addedFromExternal(res);
        }
        return res;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill, boolean doPush, int pushToken) {
        int recieveAmount;
        if (this.network == null) {
            return 0;
        }
        if (!this.network.canAcceptLiquid(resource)) {
            return 0;
        }
        this.network.setFluidType(resource);
        int n = recieveAmount = resource == null ? 0 : resource.amount;
        if (recieveAmount <= 0) {
            return 0;
        }
        int pushedVolume = 0;
        if (doPush) {
            int maxPush = Math.max(0, recieveAmount + this.tank.getFluidAmount() - this.tank.getCapacity());
            pushedVolume = this.pushLiquid(from, maxPush, doFill, pushToken);
        }
        if (doFill) {
            this.tank.drain(pushedVolume, doFill);
            return this.tank.fill(resource, doFill);
        }
        int amount = this.tank.getFluidAmount();
        this.tank.drain(pushedVolume, true);
        int res = this.tank.fill(resource, false);
        this.tank.setAmount(amount);
        return res;
    }

    private void updateStartPushDir() {
        ForgeDirection newVal = this.getNextDir(this.startPushDir);
        boolean foundNewStart = false;
        while (newVal != this.startPushDir && !foundNewStart) {
            foundNewStart = this.getConduitConnections().contains(newVal) || this.getExternalConnections().contains(newVal);
            newVal = this.getNextDir(newVal);
        }
        this.startPushDir = newVal;
    }

    private ForgeDirection getNextDir(ForgeDirection dir) {
        if (dir.ordinal() >= ForgeDirection.UNKNOWN.ordinal() - 1) {
            return ForgeDirection.VALID_DIRECTIONS[0];
        }
        return ForgeDirection.VALID_DIRECTIONS[dir.ordinal() + 1];
    }

    private int pushLiquid(ForgeDirection from, int amount, boolean doPush, int token) {
        if (token == this.currentPushToken || amount <= 0 || this.tank.getLiquid() == null) {
            return 0;
        }
        this.currentPushToken = token;
        int pushed = 0;
        ForgeDirection dir = this.startPushDir;
        LiquidStack toPush = this.tank.getLiquid().copy();
        toPush.amount = amount;
        do {
            ITankContainer con;
            if (dir == from || !this.canOutputToDir(dir)) continue;
            if (this.getConduitConnections().contains(dir)) {
                ILiquidConduit conduitCon = this.getFluidConduit(dir);
                if (conduitCon == null || !(conduitCon.getTank().getFilledRatio() <= this.tank.getFilledRatio())) continue;
                int toCon = conduitCon.fill(dir.getOpposite(), toPush, doPush, true, token);
                toPush.amount -= toCon;
                pushed += toCon;
                continue;
            }
            if (!this.getExternalConnections().contains(dir) || (con = this.getTankContainer(this.getLocation().getLocation(dir))) == null) continue;
            int toExt = con.fill(dir.getOpposite(), toPush, doPush);
            toPush.amount -= toExt;
            pushed += toExt;
            if (!doPush) continue;
            this.network.outputedToExternal(toExt);
        } while ((dir = this.getNextDir(dir)) != this.startPushDir && pushed < amount);
        return pushed;
    }

    private ILiquidConduit getFluidConduit(ForgeDirection dir) {
        aqp ent = this.getBundle().getEntity();
        return (ILiquidConduit)ConduitUtil.getConduit((aak)ent.k, ent, dir, ILiquidConduit.class);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.fill(ForgeDirection.UNKNOWN, resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.drain(ForgeDirection.UNKNOWN, maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (this.network != null && this.network.canAcceptLiquid(type)) {
            return this.tank;
        }
        return null;
    }

    @Override
    public void writeToNBT(bs nbtRoot) {
        super.writeToNBT(nbtRoot);
        if (this.tank.containsValidLiquid()) {
            nbtRoot.a("tank", (cf)this.tank.getLiquid().writeToNBT(new bs()));
        }
    }

    @Override
    public void readFromNBT(bs nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.updateTanksCapacity();
        LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((bs)nbtRoot.l("tank"));
        this.tank.setLiquid(liquid);
    }

    @Override
    protected void connectionsChanged() {
        super.connectionsChanged();
        this.updateTanksCapacity();
    }

    @Override
    public ConduitTank getTank() {
        return this.tank;
    }

    @Override
    public Class getBaseConduitType() {
        return ILiquidConduit.class;
    }

    @Override
    public wm createItem() {
        return new wm(ModObject.itemLiquidConduit.actualId, 1, 0);
    }

    @Override
    public AbstractConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork network) {
        if (network == null) {
            this.network = null;
            return true;
        }
        LiquidConduitNetwork n = (LiquidConduitNetwork)network;
        if (this.tank.getLiquid() == null) {
            this.tank.setLiquid(n.getFluidType() == null ? null : n.getFluidType().copy());
        } else if (n.getFluidType() == null) {
            n.setFluidType(this.tank.getLiquid());
        } else if (!this.tank.getLiquid().isLiquidEqual(n.getFluidType())) {
            return false;
        }
        this.network = (LiquidConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction) {
        return this.getExternalHandler(direction) != null;
    }

    @Override
    public ITankContainer getExternalHandler(ForgeDirection direction) {
        ITankContainer con = this.getTankContainer(this.getLocation().getLocation(direction));
        return con != null && !(con instanceof IConduitBundle) ? con : null;
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit con) {
        if (!(con instanceof ILiquidConduit)) {
            return false;
        }
        if (this.getFluidType() != null && ((ILiquidConduit)con).getFluidType() == null) {
            return false;
        }
        return LiquidConduitNetwork.areFluidsCompatable(this.getFluidType(), ((ILiquidConduit)con).getFluidType());
    }

    @Override
    public LiquidStack getFluidType() {
        LiquidStack result = null;
        if (this.network != null) {
            result = this.network.getFluidType();
        }
        if (result == null) {
            result = this.tank.getLiquid();
        }
        return result;
    }

    @Override
    public lx getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return (lx)ICONS.get("enderio:liquidConduitCore");
        }
        if (this.isExtractingFromDir(component.dir)) {
            return (lx)ICONS.get("enderio:liquidConduitExtract");
        }
        return (lx)ICONS.get("enderio:liquidConduit");
    }

    @Override
    public lx getTransmitionTextureForState(CollidableComponent component) {
        if (this.active && this.tank.getLiquid() != null) {
            return this.tank.getLiquid().canonical().getRenderingIcon();
        }
        return null;
    }

    @Override
    public String getTextureSheetForLiquid() {
        if (this.tank.getLiquid() != null && this.tank.getLiquid().canonical() != null) {
            return this.tank.getLiquid().canonical().getTextureSheet();
        }
        return null;
    }

    @Override
    public float getTransmitionGeometryScale() {
        return this.tank.getFilledRatio();
    }

    private ITankContainer getTankContainer(BlockCoord bc) {
        return this.getTankContainer(bc.x, bc.y, bc.z);
    }

    private ITankContainer getTankContainer(int x, int y, int z) {
        aqp te = this.getBundle().getEntity().k.r(x, y, z);
        if (te instanceof ITankContainer) {
            return (ITankContainer)te;
        }
        return null;
    }

    private void updateTanksCapacity() {
        int totalConnections = this.getConduitConnections().size() + this.getExternalConnections().size();
        this.tank.setCapacity(totalConnections * 250);
    }
}

