/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidConduitNetwork
extends AbstractConduitNetwork {
    private LiquidStack liquidType;
    private long timeAtLastApply;
    private int maxFlowsPerTick = 10;
    private int lastFlowIndex = 0;
    private boolean printFlowTiming = false;
    private int pushToken = 0;
    private int inputVolume;
    private int outputVolume;

    @Override
    public Class getBaseConduitType() {
        return ILiquidConduit.class;
    }

    public LiquidStack getFluidType() {
        return this.liquidType;
    }

    public void addConduit(ILiquidConduit con) {
        super.addConduit(con);
        con.setFluidType(this.liquidType);
    }

    public void setFluidType(LiquidStack newType) {
        if (this.liquidType != null && this.liquidType.isLiquidEqual(newType)) {
            return;
        }
        if (newType != null) {
            this.liquidType = newType.copy();
            this.liquidType.amount = 0;
        } else {
            this.liquidType = null;
        }
        for (ILiquidConduit conduit : this.conduits) {
            conduit.setFluidType(this.liquidType);
        }
    }

    public boolean canAcceptLiquid(LiquidStack acceptable) {
        return LiquidConduitNetwork.areFluidsCompatable(this.liquidType, acceptable);
    }

    public static boolean areFluidsCompatable(LiquidStack a, LiquidStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.isLiquidEqual(b);
    }

    public int getTotalVolume() {
        int totalVolume = 0;
        for (ILiquidConduit con : this.conduits) {
            totalVolume += con.getTank().getFluidAmount();
        }
        return totalVolume;
    }

    @Override
    public void onUpdateEntity(IConduit conduit) {
        aab world = conduit.getBundle().getEntity().k;
        if (world == null) {
            return;
        }
        if (world.I || this.liquidType == null) {
            return;
        }
        long curTime = world.H();
        if (curTime != this.timeAtLastApply) {
            int visc;
            this.timeAtLastApply = curTime;
            if (this.liquidType != null && curTime % (long)((visc = 1000) / 500) == 0L) {
                long start = System.nanoTime();
                if (this.doFlow() && this.printFlowTiming) {
                    long took = System.nanoTime() - start;
                    double secs = (double)took / 1.0E9;
                    System.out.println("LiquidConduitNetwork.onUpdateEntity: took " + secs + " secs, " + secs * 1000.0 + " millis");
                }
            }
        }
    }

    void addedFromExternal(int res) {
        this.inputVolume += res;
    }

    void outputedToExternal(int filled) {
        this.outputVolume += filled;
    }

    int getNextPushToken() {
        return ++this.pushToken;
    }

    private boolean doFlow() {
        int pushToken = this.getNextPushToken();
        ArrayList actions = new ArrayList();
        for (int i = 0; i < Math.min(this.maxFlowsPerTick, this.conduits.size()); ++i) {
            if (this.lastFlowIndex >= this.conduits.size()) {
                this.lastFlowIndex = 0;
            }
            this.flowFrom((ILiquidConduit)this.conduits.get(this.lastFlowIndex), actions, pushToken);
            ++this.lastFlowIndex;
        }
        for (FlowAction action : actions) {
            action.apply();
        }
        boolean result = !actions.isEmpty();
        ArrayList<ILiquidConduit> toEmpty = new ArrayList<ILiquidConduit>();
        for (ILiquidConduit con : this.conduits) {
            if (con.getTank().getFluidAmount() < 10) {
                toEmpty.add(con);
                continue;
            }
            return result;
        }
        if (toEmpty.isEmpty()) {
            return result;
        }
        ArrayList<LocatedFluidHandler> externals = new ArrayList<LocatedFluidHandler>();
        for (ILiquidConduit con : this.conduits) {
            Set extCons = con.getExternalConnections();
            for (ForgeDirection dir : extCons) {
                ITankContainer externalTank;
                if (!con.canOutputToDir(dir) || (externalTank = con.getExternalHandler(dir)) == null) continue;
                externals.add(new LocatedFluidHandler(externalTank, con.getLocation().getLocation(dir), dir.getOpposite()));
            }
        }
        if (externals.isEmpty()) {
            return result;
        }
        for (ILiquidConduit con : toEmpty) {
            this.drainConduitToNearestExternal(con, externals);
        }
        return result;
    }

    private void drainConduitToNearestExternal(ILiquidConduit con, List externals) {
        BlockCoord conLoc = con.getLocation();
        LiquidStack toDrain = con.getTank().getLiquid();
        if (toDrain == null) {
            return;
        }
        int closestDistance = Integer.MAX_VALUE;
        LocatedFluidHandler closestTank = null;
        for (LocatedFluidHandler lh : externals) {
            int couldFill;
            int distance = lh.bc.distanceSquared(conLoc);
            if (distance >= closestDistance || (couldFill = lh.tank.fill(lh.dir, toDrain.copy(), false)) <= 0) continue;
            closestTank = lh;
            closestDistance = distance;
        }
        if (closestTank != null) {
            int filled = closestTank.tank.fill(closestTank.dir, toDrain.copy(), true);
            con.getTank().addAmount(-filled);
        }
    }

    private void flowFrom(ILiquidConduit con, List actions, int pushPoken) {
        ConduitTank tank = con.getTank();
        int totalAmount = tank.getFluidAmount();
        if (totalAmount <= 0) {
            return;
        }
        int maxFlowVolume = 20;
        if (con.getConduitConnections().contains(ForgeDirection.DOWN)) {
            int filled;
            BlockCoord loc = con.getLocation().getLocation(ForgeDirection.DOWN);
            ILiquidConduit downCon = (ILiquidConduit)ConduitUtil.getConduit((aak)con.getBundle().getEntity().k, loc.x, loc.y, loc.z, ILiquidConduit.class);
            int actual = filled = downCon.fill(ForgeDirection.UP, tank.getLiquid().copy(), false, false, pushPoken);
            actual = Math.min(actual, tank.getFluidAmount());
            actual = Math.min(actual, downCon.getTank().getAvailableSpace());
            tank.addAmount(-actual);
            downCon.getTank().addAmount(actual);
        }
        if ((totalAmount = tank.getFluidAmount()) <= 0) {
            return;
        }
        LiquidStack available = tank.getLiquid();
        int totalRequested = 0;
        int numRequests = 0;
        for (ForgeDirection dir : con.getExternalConnections()) {
            int amount;
            ITankContainer extCon;
            if (!con.canOutputToDir(dir) || (extCon = con.getExternalHandler(dir)) == null || (amount = extCon.fill(dir.getOpposite(), available.copy(), false)) <= 0) continue;
            totalRequested += amount;
            ++numRequests;
        }
        if (numRequests > 0) {
            int amountPerRequest = Math.min(totalAmount, totalRequested) / numRequests;
            amountPerRequest = Math.min(maxFlowVolume, amountPerRequest);
            LiquidStack requestSource = available.copy();
            requestSource.amount = amountPerRequest;
            for (ForgeDirection dir : con.getExternalConnections()) {
                int amount;
                ITankContainer extCon;
                if (!con.canOutputToDir(dir) || (extCon = con.getExternalHandler(dir)) == null || (amount = extCon.fill(dir.getOpposite(), requestSource.copy(), true)) <= 0) continue;
                this.outputedToExternal(amount);
                tank.addAmount(-amount);
            }
        }
        if ((totalAmount = tank.getFluidAmount()) <= 0) {
            return;
        }
        int totalCapacity = tank.getCapacity();
        BlockCoord loc = con.getLocation();
        Collection connections = ConduitUtil.getConnectedConduits((aak)con.getBundle().getEntity().k, loc.x, loc.y, loc.z, ILiquidConduit.class);
        int numTargets = 0;
        for (ILiquidConduit neighbour : connections) {
            if (!this.canFlowTo(con, neighbour)) continue;
            totalAmount += neighbour.getTank().getFluidAmount();
            totalCapacity += neighbour.getTank().getCapacity();
            ++numTargets;
        }
        float targetRatio = (float)totalAmount / (float)totalCapacity;
        int flowVolume = (int)Math.floor((targetRatio - tank.getFilledRatio()) * (float)tank.getCapacity());
        if (Math.abs(flowVolume = Math.min(maxFlowVolume, flowVolume)) < 2) {
            return;
        }
        for (ILiquidConduit neigbour : connections) {
            if (!this.canFlowTo(con, neigbour) || (flowVolume = (int)Math.floor((targetRatio - neigbour.getTank().getFilledRatio()) * (float)neigbour.getTank().getCapacity())) == 0) continue;
            actions.add(new FlowAction(con, neigbour, flowVolume));
        }
    }

    private boolean canFlowTo(ILiquidConduit con, ILiquidConduit neighbour) {
        if (neighbour.getNetwork() != this) {
            return false;
        }
        if (neighbour.getLocation().y > con.getLocation().y) {
            return false;
        }
        float nr = neighbour.getTank().getFilledRatio();
        return !(nr >= con.getTank().getFilledRatio());
    }

    static class LocatedFluidHandler {
        final ITankContainer tank;
        final BlockCoord bc;
        final ForgeDirection dir;

        LocatedFluidHandler(ITankContainer tank, BlockCoord bc, ForgeDirection dir) {
            this.tank = tank;
            this.bc = bc;
            this.dir = dir;
        }
    }

    static class FlowAction {
        final ILiquidConduit from;
        final ILiquidConduit to;
        final int amount;

        FlowAction(ILiquidConduit fromIn, ILiquidConduit toIn, int amountIn) {
            if (amountIn < 0) {
                this.to = fromIn;
                this.from = toIn;
                this.amount = -amountIn;
            } else {
                this.to = toIn;
                this.from = fromIn;
                this.amount = amountIn;
            }
        }

        void apply() {
            if (this.amount != 0) {
                int actual = Math.min(this.amount, this.from.getTank().getFluidAmount());
                actual = Math.min(actual, this.to.getTank().getAvailableSpace());
                this.from.getTank().addAmount(-actual);
                this.to.getTank().addAmount(actual);
            }
        }
    }
}

