/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.vecmath.Vector3d;
import net.minecraftforge.common.ForgeDirection;

public class LiquidConduitRenderer
extends DefaultConduitRenderer {
    private float downRatio;
    private float flatRatio;
    private float upRatio;

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof ILiquidConduit;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        this.calculateRatios((ILiquidConduit)conduit);
        super.renderEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight);
    }

    @Override
    protected void renderConduit(lx tex, CollidableComponent component) {
        if (this.isNSEWUP(component.dir)) {
            BoundingBox[] cubes;
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawSection(cube, tex.e(), tex.f(), tex.g(), tex.h(), component.dir, false);
            }
        } else {
            this.drawSection(component.bound, tex.e(), tex.f(), tex.g(), tex.h(), component.dir, true);
        }
    }

    @Override
    protected void renderTransmission(lx tex, CollidableComponent component, IConduit conduit, float selfIllum) {
        BoundingBox[] cubes;
        String textureSheet = ((ILiquidConduit)conduit).getTextureSheetForLiquid();
        boolean changedTexture = false;
        if (!"/terrain.png".equals(textureSheet)) {
            bgd tes = bgd.a;
            tes.a();
            RenderUtil.bindTexture(textureSheet);
            tes.b();
            tes.a(selfIllum, selfIllum, selfIllum, 0.75f);
            changedTexture = true;
        }
        for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
            this.drawSection(cube, tex.e(), tex.f(), tex.g(), tex.h(), component.dir, true);
        }
        if (changedTexture) {
            bgd tes = bgd.a;
            tes.a();
            RenderUtil.bindBlockTexture();
            tes.b();
        }
    }

    @Override
    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection id) {
        float yScale = this.getRatioForConnection(id);
        float xs = id.offsetX == 0 ? 0.9f : 1.0f;
        float ys = id.offsetY == 0 ? Math.min(yScale, 0.9f) : yScale;
        float zs = id.offsetZ == 0 ? 0.9f : 1.0f;
        float sizeY = bound.sizeY();
        bound = bound.scale(xs, ys, zs);
        float transY = (bound.sizeY() - sizeY) / 2.0f;
        Vector3d translation = new Vector3d(0.0, transY, 0.0);
        CubeRenderer.setupVertices(bound.translate(translation));
    }

    private void calculateRatios(ILiquidConduit conduit) {
        ConduitTank tank = conduit.getTank();
        int totalAmount = tank.getFluidAmount();
        int upCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.UP) || conduit.containsExternalConnection(ForgeDirection.UP)) {
            upCapacity = 250;
        }
        int downCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.DOWN) || conduit.containsExternalConnection(ForgeDirection.DOWN)) {
            downCapacity = 250;
        }
        int flatCapacity = tank.getCapacity() - upCapacity - downCapacity;
        int usedCapacity = 0;
        if (downCapacity > 0) {
            int inDown = Math.min(totalAmount, downCapacity);
            usedCapacity += inDown;
            this.downRatio = (float)inDown / (float)downCapacity;
        }
        if (flatCapacity > 0 && usedCapacity < totalAmount) {
            int inFlat = Math.min(flatCapacity, totalAmount - usedCapacity);
            usedCapacity += inFlat;
            this.flatRatio = (float)inFlat / (float)flatCapacity;
        } else {
            this.flatRatio = 0.0f;
        }
        if (upCapacity > 0 && usedCapacity < totalAmount) {
            int inUp = Math.min(upCapacity, totalAmount - usedCapacity);
            this.upRatio = (float)inUp / (float)upCapacity;
        } else {
            this.upRatio = 0.0f;
        }
    }

    private float getRatioForConnection(ForgeDirection id) {
        if (id == ForgeDirection.UP) {
            return this.upRatio;
        }
        if (id == ForgeDirection.DOWN) {
            return this.downRatio;
        }
        return this.flatRatio;
    }
}

