/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import buildcraft.api.power.PowerProvider;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.power.PowerConduit;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.MutablePowerProvider;
import net.minecraftforge.common.ForgeDirection;

public class ConduitPowerProvider
extends PowerProvider
implements MutablePowerProvider {
    PowerConduit conduit;

    public static ConduitPowerProvider createHandler(ICapacitor capacitor, PowerConduit conduit) {
        ConduitPowerProvider ph = new ConduitPowerProvider(conduit);
        ph.configure(0, capacitor.getMinEnergyReceived(), capacitor.getMaxEnergyReceived(), capacitor.getMinActivationEnergy(), capacitor.getMaxEnergyStored());
        ph.configurePowerPerdition(0, 0);
        return ph;
    }

    private ConduitPowerProvider(PowerConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        if (from != null) {
            this.powerSources[from.ordinal()] = 2;
        }
        if (this.conduit.getConectionMode(from) == ConnectionMode.OUTPUT) {
            return;
        }
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void setEnergy(float energyStored) {
        this.energyStored = energyStored;
    }
}

