/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.machine.power.TileCapacitorBank;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.MutablePowerProvider;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class NetworkPowerManager {
    private PowerConduitNetwork network;
    int maxEnergyStored;
    float energyStored;
    private float reserved;
    private int updateRenderTicks = 10;
    private int inactiveTicks = 100;
    private final List receptors = new ArrayList();
    private ListIterator receptorIterator = this.receptors.listIterator();
    private final List storageReceptors = new ArrayList();
    private boolean lastActiveValue = false;
    private int ticksWithNoPower = 0;
    private final Map starveBuffers = new HashMap();

    public NetworkPowerManager(PowerConduitNetwork netowrk, aab world) {
        this.network = netowrk;
        this.maxEnergyStored = 64;
    }

    public void applyRecievedPower() {
        float available;
        this.updateNetorkStorage();
        this.checkReserves();
        this.updateActiveState();
        CapBankSupply capSupply = new CapBankSupply();
        int numReceptors = this.receptors.size();
        float wasAvailable = available = this.energyStored + capSupply.canExtract;
        if (available <= 0.0f || this.receptors.isEmpty() && this.storageReceptors.isEmpty()) {
            return;
        }
        for (int appliedCount = 0; available > 0.0f && appliedCount < numReceptors; ++appliedCount) {
            if (!this.receptors.isEmpty() && !this.receptorIterator.hasNext()) {
                this.receptorIterator = this.receptors.listIterator();
            }
            PowerConduitNetwork.ReceptorEntry r = (PowerConduitNetwork.ReceptorEntry)this.receptorIterator.next();
            if (r.emmiter.getPowerHandler().isPowerSource(r.direction)) {
                float es = r.emmiter.getPowerHandler().getEnergyStored();
                MutablePowerProvider pr = r.emmiter.getPowerHandler();
                pr.receiveEnergy(0.0f, null);
                pr.setEnergy(this.energyStored);
                continue;
            }
            IPowerReceptor pp = r.powerReceptor;
            if (pp == null || pp.getPowerProvider() == null) continue;
            float used = 0.0f;
            float reservedForEntry = this.removeReservedEnergy(r);
            float canOffer = Math.min(r.emmiter.getMaxEnergyExtracted(r.direction), available += reservedForEntry);
            float requested = pp.powerRequest(r.direction);
            requested = Math.min(requested, (float)pp.getPowerProvider().getMaxEnergyStored() - pp.getPowerProvider().getEnergyStored());
            requested = Math.min(requested, (float)pp.getPowerProvider().getMaxEnergyReceived());
            if ((float)pp.getPowerProvider().getMinEnergyReceived() <= r.emmiter.getMaxEnergyExtracted(r.direction)) {
                if ((float)pp.getPowerProvider().getMinEnergyReceived() > canOffer && requested > 0.0f) {
                    if ((float)pp.getPowerProvider().getMinEnergyReceived() < r.emmiter.getMaxEnergyExtracted(r.direction)) {
                        this.reserveEnergy(r, canOffer);
                        used += canOffer;
                    }
                } else if (r.powerReceptor instanceof IInternalPowerReceptor) {
                    used = PowerHandlerUtil.transmitInternal((IInternalPowerReceptor)r.powerReceptor, canOffer, r.direction.getOpposite());
                } else {
                    used = Math.min(requested, canOffer);
                    pp.getPowerProvider().receiveEnergy(used, r.direction.getOpposite());
                }
            }
            if ((available -= used) <= 0.0f) break;
        }
        float used = wasAvailable - available;
        this.energyStored -= used;
        float capBankChange = 0.0f;
        if (this.energyStored < 0.0f) {
            capBankChange = this.energyStored;
            this.energyStored = 0.0f;
        } else if (this.energyStored > 0.0f) {
            capBankChange = Math.min(this.energyStored, capSupply.canFill);
            this.energyStored -= capBankChange;
        }
        if (capBankChange < 0.0f) {
            capSupply.remove(Math.abs(capBankChange));
        } else if (capBankChange > 0.0f) {
            capSupply.add(capBankChange);
        }
        capSupply.balance();
        this.distributeStorageToConduits();
    }

    private void updateActiveState() {
        boolean doRender;
        boolean active;
        if (this.energyStored > 0.0f) {
            this.ticksWithNoPower = 0;
            active = true;
        } else {
            ++this.ticksWithNoPower;
            active = false;
        }
        boolean bl = doRender = active != this.lastActiveValue && (active || !active && this.ticksWithNoPower > this.updateRenderTicks);
        if (doRender) {
            this.lastActiveValue = active;
            for (IPowerConduit con : this.network.getConduits()) {
                con.setActive(active);
            }
        }
    }

    private float removeReservedEnergy(PowerConduitNetwork.ReceptorEntry r) {
        StarveBuffer starveBuf = (StarveBuffer)this.starveBuffers.remove(r.coord);
        if (starveBuf == null) {
            return 0.0f;
        }
        float result = starveBuf.stored;
        this.reserved -= result;
        return result;
    }

    private void reserveEnergy(PowerConduitNetwork.ReceptorEntry r, float amount) {
        this.starveBuffers.put(r.coord, new StarveBuffer(amount));
        this.reserved += amount;
    }

    private void checkReserves() {
        if ((double)this.reserved > (double)this.maxEnergyStored * 0.9) {
            this.starveBuffers.clear();
            this.reserved = 0.0f;
        }
    }

    private void distributeStorageToConduits() {
        if (this.maxEnergyStored <= 0 || this.energyStored <= 0.0f) {
            for (IPowerConduit con : this.network.getConduits()) {
                con.getPowerHandler().setEnergy(0.0f);
            }
            return;
        }
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
        float filledRatio = this.energyStored / (float)this.maxEnergyStored;
        float energyLeft = this.energyStored;
        float given = 0.0f;
        for (IPowerConduit con : this.network.getConduits()) {
            float give = (float)Math.ceil((float)con.getCapacitor().getMaxEnergyStored() * filledRatio);
            give = Math.min(give, (float)con.getCapacitor().getMaxEnergyStored());
            give = Math.min(give, energyLeft);
            con.getPowerHandler().setEnergy(give);
            given += give;
            if (!((energyLeft -= give) <= 0.0f)) continue;
            return;
        }
    }

    boolean isActive() {
        return this.energyStored > 0.0f;
    }

    private void updateNetorkStorage() {
        this.maxEnergyStored = 0;
        this.energyStored = 0.0f;
        for (IPowerConduit con : this.network.getConduits()) {
            this.maxEnergyStored += con.getCapacitor().getMaxEnergyStored();
            this.energyStored += con.getPowerHandler().getEnergyStored();
        }
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    public void receptorsChanged() {
        this.receptors.clear();
        this.storageReceptors.clear();
        for (PowerConduitNetwork.ReceptorEntry rec : this.network.getPowerReceptors()) {
            if (rec.powerReceptor instanceof TileCapacitorBank) {
                this.storageReceptors.add(rec);
                continue;
            }
            this.receptors.add(rec);
        }
        this.receptorIterator = this.receptors.listIterator();
    }

    void onNetworkDestroyed() {
    }

    private float minAbs(float amount, float limit) {
        if (amount < 0.0f) {
            return Math.max(amount, -limit);
        }
        return Math.min(amount, limit);
    }

    private static class CapBankSupplyEntry {
        final TileCapacitorBank capBank;
        final float canExtract;
        final float canFill;
        float toBalance;

        private CapBankSupplyEntry(TileCapacitorBank capBank, float available, float canFill) {
            this.capBank = capBank;
            this.canExtract = available;
            this.canFill = canFill;
        }

        void calcToBalance(float targetRatio) {
            float targetAmount = (float)this.capBank.getMaxEnergyStored() * targetRatio;
            this.toBalance = targetAmount - this.capBank.getEnergyStored();
            this.toBalance = this.toBalance < 0.0f ? Math.max(this.toBalance, -this.canExtract) : Math.min(this.toBalance, this.canFill);
        }
    }

    private class CapBankSupply {
        float canExtract;
        float canFill;
        float filledRatio;
        float stored = 0.0f;
        float maxCap = 0.0f;
        List enteries;

        CapBankSupply() {
            this.init();
        }

        void init() {
            this.canExtract = 0.0f;
            this.canFill = 0.0f;
            this.stored = 0.0f;
            this.maxCap = 0.0f;
            this.enteries = new ArrayList();
            for (PowerConduitNetwork.ReceptorEntry rec : NetworkPowerManager.this.storageReceptors) {
                TileCapacitorBank cb = (TileCapacitorBank)rec.powerReceptor;
                this.stored += cb.getEnergyStored();
                this.maxCap += (float)cb.getMaxEnergyStored();
                float canGet = 0.0f;
                if (cb.isOutputEnabled()) {
                    canGet = Math.min(cb.getEnergyStored(), (float)cb.getMaxIO());
                    canGet = Math.min(canGet, rec.emmiter.getMaxEnergyRecieved(rec.direction));
                    this.canExtract += canGet;
                }
                float canFill = 0.0f;
                if (cb.isInputEnabled()) {
                    canFill = Math.min((float)cb.getMaxEnergyStored() - cb.getEnergyStored(), (float)cb.getMaxIO());
                    canFill = Math.min(canFill, rec.emmiter.getMaxEnergyExtracted(rec.direction));
                    this.canFill += canFill;
                }
                this.enteries.add(new CapBankSupplyEntry(cb, canGet, canFill));
            }
            this.filledRatio = 0.0f;
            if (this.maxCap > 0.0f) {
                this.filledRatio = this.stored / this.maxCap;
            }
        }

        void balance() {
            if (this.enteries.size() < 2) {
                return;
            }
            this.init();
            int canRemove = 0;
            int canAdd = 0;
            for (CapBankSupplyEntry entry : this.enteries) {
                entry.calcToBalance(this.filledRatio);
                if (entry.toBalance < 0.0f) {
                    canRemove = (int)((float)canRemove + -entry.toBalance);
                    continue;
                }
                canAdd = (int)((float)canAdd + entry.toBalance);
            }
            float toalTransferAmount = Math.min(canAdd, canRemove);
            for (int i = 0; i < this.enteries.size() && toalTransferAmount > 0.0f; ++i) {
                CapBankSupplyEntry from = (CapBankSupplyEntry)this.enteries.get(i);
                float amount = from.toBalance;
                amount = NetworkPowerManager.this.minAbs(amount, toalTransferAmount);
                from.capBank.addEnergy(amount);
                toalTransferAmount -= Math.abs(amount);
                float toTranfser = Math.abs(amount);
                for (int j = i + 1; j < this.enteries.size() && toTranfser > 0.0f; ++j) {
                    CapBankSupplyEntry to = (CapBankSupplyEntry)this.enteries.get(j);
                    if (Math.signum(amount) == Math.signum(to.toBalance)) continue;
                    float toAmount = Math.min(toTranfser, Math.abs(to.toBalance));
                    to.capBank.addEnergy(toAmount * Math.signum(to.toBalance));
                    toTranfser -= toAmount;
                }
            }
        }

        void remove(float amount) {
            if (this.canExtract <= 0.0f || amount <= 0.0f) {
                return;
            }
            float ratio = amount / this.canExtract;
            for (CapBankSupplyEntry entry : this.enteries) {
                double use = Math.ceil(ratio * entry.canExtract);
                use = Math.min(use, (double)amount);
                use = Math.min(use, (double)entry.canExtract);
                entry.capBank.addEnergy(-((float)use));
                if ((amount = (float)((double)amount - use)) != 0.0f) continue;
                return;
            }
        }

        void add(float amount) {
            if (this.canFill <= 0.0f || amount <= 0.0f) {
                return;
            }
            float ratio = amount / this.canFill;
            for (CapBankSupplyEntry entry : this.enteries) {
                double add = (int)Math.ceil(ratio * entry.canFill);
                add = Math.min(add, (double)entry.canFill);
                add = Math.min(add, (double)amount);
                entry.capBank.addEnergy((float)add);
                if ((amount = (float)((double)amount - add)) != 0.0f) continue;
                return;
            }
        }
    }

    private static class StarveBuffer {
        float stored;

        public StarveBuffer(float stored) {
            this.stored = stored;
        }

        void addToStore(float val) {
            this.stored += val;
        }
    }
}

