/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.power.ConduitPowerProvider;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.MutablePowerProvider;
import crazypants.render.BoundingBox;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector3d;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;

public class PowerConduit
extends AbstractConduit
implements IPowerConduit {
    static final Map ICONS = new HashMap();
    static final ICapacitor[] CAPACITORS = new BasicCapacitor[]{new BasicCapacitor(250, 1500, 128), new BasicCapacitor(350, 3000, 512), new BasicCapacitor(500, 5000, 2048)};
    static final String[] POSTFIX = new String[]{"", "Enhanced", "Ender"};
    public static final float WIDTH = 0.075f;
    public static final float HEIGHT = 0.075f;
    public static final Vector3d MIN = new Vector3d(0.425f, 0.42499999701976776, 0.42499999701976776);
    public static final Vector3d MAX = new Vector3d(PowerConduit.MIN.x + (double)0.075f, PowerConduit.MIN.y + (double)0.075f, PowerConduit.MIN.z + (double)0.075f);
    public static final BoundingBox BOUNDS = new BoundingBox(MIN, MAX);
    protected PowerConduitNetwork network;
    private ConduitPowerProvider powerHandler;
    private int subtype;

    static wm createItemStackForSubtype(int subtype) {
        wm result = new wm(ModObject.itemPowerConduit.actualId, 1, subtype);
        return result;
    }

    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(ly register) {
                for (String pf : POSTFIX) {
                    ICONS.put("enderio:powerConduit" + pf, register.a("enderio:powerConduit" + pf));
                    ICONS.put("enderio:powerConduitInput" + pf, register.a("enderio:powerConduitInput" + pf));
                    ICONS.put("enderio:powerConduitOutput" + pf, register.a("enderio:powerConduitOutput" + pf));
                    ICONS.put("enderio:powerConduitCore" + pf, register.a("enderio:powerConduitCore" + pf));
                }
                ICONS.put("enderio:powerConduitTransmission", register.a("enderio:powerConduitTransmission"));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    public PowerConduit() {
    }

    public PowerConduit(int meta) {
        this.subtype = meta;
        this.powerHandler = this.createPowerHandlerForType();
    }

    @Override
    public boolean onBlockActivated(sq player, RaytraceResult res) {
        if (ConduitUtil.isToolEquipped(player)) {
            ForgeDirection connDir;
            if (!this.getBundle().getEntity().k.I && res.component != null && this.externalConnections.contains(connDir = res.component.dir)) {
                ConnectionMode curMode = this.getConectionMode(connDir);
                ConnectionMode newMode = ConnectionMode.getNext(curMode);
                this.conectionModes.put(connDir, newMode);
                BlockCoord bc = this.getLocation();
                this.setClientStateDirty();
            }
            if (this.network != null) {
                System.out.println("PowerConduit.onBlockActivated: Network contains " + this.network.getPowerManager().energyStored + " of max energy " + this.network.getPowerManager().maxEnergyStored);
                System.out.println("Conduit contains: " + this.powerHandler.getEnergyStored() + " of max " + this.powerHandler.getMaxEnergyStored());
            }
            return true;
        }
        return false;
    }

    @Override
    public ICapacitor getCapacitor() {
        return CAPACITORS[this.subtype];
    }

    private ConduitPowerProvider createPowerHandlerForType() {
        return ConduitPowerProvider.createHandler(CAPACITORS[this.subtype], this);
    }

    @Override
    public void writeToNBT(bs nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.a("subtype", (short)this.subtype);
        nbtRoot.a("energyStored", this.powerHandler.getEnergyStored());
    }

    @Override
    public void readFromNBT(bs nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.subtype = nbtRoot.d("subtype");
        if (this.powerHandler == null) {
            this.powerHandler = this.createPowerHandlerForType();
        }
        this.powerHandler.setEnergy(Math.min((float)this.powerHandler.getMaxEnergyStored(), nbtRoot.g("energyStored")));
    }

    @Override
    public void applyPerdition() {
    }

    @Override
    public MutablePowerProvider getPowerHandler() {
        return this.powerHandler;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerHandler;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.getConectionMode(from) == ConnectionMode.OUTPUT) {
            return 0;
        }
        return this.powerHandler.getMaxEnergyStored() - this.powerHandler.getMinEnergyReceived();
    }

    @Override
    public float getMaxEnergyExtracted(ForgeDirection dir) {
        ConnectionMode mode = this.getConectionMode(dir);
        if (mode == ConnectionMode.INPUT) {
            return 0.0f;
        }
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    @Override
    public float getMaxEnergyRecieved(ForgeDirection dir) {
        ConnectionMode mode = this.getConectionMode(dir);
        if (mode == ConnectionMode.OUTPUT) {
            return 0.0f;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public AbstractConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork network) {
        this.network = (PowerConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction) {
        IPowerReceptor rec = this.getExternalPowerReceptor(direction);
        return rec != null && rec.getPowerProvider() != null;
    }

    @Override
    public void externalConnectionAdded(ForgeDirection direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            aqp te = this.bundle.getEntity();
            this.network.powerReceptorAdded(this, direction, te.l + direction.offsetX, te.m + direction.offsetY, te.n + direction.offsetZ, this.getExternalPowerReceptor(direction));
        }
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection direction) {
        super.externalConnectionRemoved(direction);
        if (this.network != null) {
            aqp te = this.bundle.getEntity();
            this.network.powerReceptorRemoved(te.l + direction.offsetX, te.m + direction.offsetY, te.n + direction.offsetZ);
        }
    }

    @Override
    public IPowerReceptor getExternalPowerReceptor(ForgeDirection direction) {
        aqp te = this.bundle.getEntity();
        aab world = te.k;
        if (world == null) {
            return null;
        }
        aqp test = world.r(te.l + direction.offsetX, te.m + direction.offsetY, te.n + direction.offsetZ);
        if (test instanceof IConduitBundle) {
            return null;
        }
        if (test instanceof IPowerReceptor) {
            return (IPowerReceptor)test;
        }
        return null;
    }

    @Override
    public wm createItem() {
        return PowerConduit.createItemStackForSubtype(this.subtype);
    }

    @Override
    public Class getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public lx getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return (lx)ICONS.get("enderio:powerConduitCore" + POSTFIX[this.subtype]);
        }
        return (lx)ICONS.get("enderio:powerConduit" + POSTFIX[this.subtype]);
    }

    @Override
    public lx getTextureForInputMode() {
        return (lx)ICONS.get("enderio:powerConduitInput" + POSTFIX[this.subtype]);
    }

    @Override
    public lx getTextureForOutputMode() {
        return (lx)ICONS.get("enderio:powerConduitOutput" + POSTFIX[this.subtype]);
    }

    @Override
    public lx getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }
}

