/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import buildcraft.api.power.IPowerReceptor;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.NetworkPowerManager;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;

public class PowerConduitNetwork
extends AbstractConduitNetwork {
    NetworkPowerManager powerManager;
    private Map powerReceptors = new HashMap();
    private long timeAtLastApply = -1L;

    @Override
    public void init(IConduitBundle tile, Collection connections, aab world) {
        super.init(tile, connections, world);
        this.powerManager = new NetworkPowerManager(this, world);
        this.powerManager.receptorsChanged();
    }

    @Override
    public void destroyNetwork() {
        for (IPowerConduit con : this.conduits) {
            con.setActive(false);
        }
        this.powerManager.onNetworkDestroyed();
        super.destroyNetwork();
    }

    public NetworkPowerManager getPowerManager() {
        return this.powerManager;
    }

    public void addConduit(IPowerConduit con) {
        super.addConduit(con);
        Set externalDirs = con.getExternalConnections();
        for (ForgeDirection dir : externalDirs) {
            IPowerReceptor pr = con.getExternalPowerReceptor(dir);
            if (pr == null) continue;
            aqp te = con.getBundle().getEntity();
            this.powerReceptorAdded(con, dir, te.l + dir.offsetX, te.m + dir.offsetY, te.n + dir.offsetZ, pr);
        }
        if (this.powerManager != null) {
            con.setActive(this.powerManager.isActive());
        }
    }

    @Override
    public Class getBaseConduitType() {
        return IPowerConduit.class;
    }

    public void powerReceptorAdded(IPowerConduit powerConduit, ForgeDirection direction, int x, int y, int z, IPowerReceptor powerReceptor) {
        if (powerReceptor == null) {
            return;
        }
        BlockCoord location = new BlockCoord(x, y, z);
        ReceptorKey key = new ReceptorKey(location, direction);
        ReceptorEntry re = (ReceptorEntry)this.powerReceptors.get(key);
        if (re == null) {
            re = new ReceptorEntry(powerReceptor, location, powerConduit, direction);
            this.powerReceptors.put(key, re);
        }
        if (this.powerManager != null) {
            this.powerManager.receptorsChanged();
        }
    }

    public void powerReceptorRemoved(int x, int y, int z) {
        BlockCoord bc = new BlockCoord(x, y, z);
        ArrayList<ReceptorKey> remove = new ArrayList<ReceptorKey>();
        for (ReceptorKey key : this.powerReceptors.keySet()) {
            if (key == null || !key.coord.equals(bc)) continue;
            remove.add(key);
        }
        for (ReceptorKey key : remove) {
            this.powerReceptors.remove(key);
        }
        this.powerManager.receptorsChanged();
    }

    public Collection getPowerReceptors() {
        return this.powerReceptors.values();
    }

    @Override
    public void onUpdateEntity(IConduit conduit) {
        aab world = conduit.getBundle().getEntity().k;
        if (world == null) {
            return;
        }
        if (world.I) {
            return;
        }
        long curTime = world.H();
        if (curTime != this.timeAtLastApply) {
            this.timeAtLastApply = curTime;
            this.powerManager.applyRecievedPower();
        }
    }

    private static class ReceptorKey {
        BlockCoord coord;
        ForgeDirection direction;

        ReceptorKey(BlockCoord coord, ForgeDirection direction) {
            this.coord = coord;
            this.direction = direction;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.coord == null ? 0 : this.coord.hashCode());
            result = 31 * result + (this.direction == null ? 0 : this.direction.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReceptorKey other = (ReceptorKey)obj;
            if (this.coord == null ? other.coord != null : !this.coord.equals(other.coord)) {
                return false;
            }
            return this.direction == other.direction;
        }
    }

    public static class ReceptorEntry {
        IPowerConduit emmiter;
        IPowerReceptor powerReceptor;
        BlockCoord coord;
        ForgeDirection direction;

        public ReceptorEntry(IPowerReceptor powerReceptor, BlockCoord coord, IPowerConduit emmiter, ForgeDirection direction) {
            this.powerReceptor = powerReceptor;
            this.coord = coord;
            this.emmiter = emmiter;
            this.direction = direction;
        }
    }
}

