/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.VertexRotation;
import crazypants.render.VertexTransform;
import crazypants.render.VertexTransformComposite;
import crazypants.render.VertexTranslation;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vertex;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class PowerConduitRenderer
extends DefaultConduitRenderer {
    private static final EnumMap VERTS = new EnumMap(ForgeDirection.class);

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof IPowerConduit;
    }

    private static List createVerticesForDir(BoundingBox refBB, VertexTransform xform) {
        ArrayList result = new ArrayList(24);
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            result.addAll(refBB.getCornersWithUvForFace(face));
        }
        for (Vertex v : result) {
            xform.apply(v.xyz);
            xform.applyToNormal(v.normal);
        }
        return result;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        super.renderEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight);
        if (!conduit.hasConnectionMode(ConnectionMode.INPUT) && !conduit.hasConnectionMode(ConnectionMode.OUTPUT)) {
            return;
        }
        IPowerConduit pc = (IPowerConduit)conduit;
        for (ForgeDirection dir : conduit.getExternalConnections()) {
            lx tex = null;
            if (conduit.getConectionMode(dir) == ConnectionMode.INPUT) {
                tex = pc.getTextureForInputMode();
            } else if (conduit.getConectionMode(dir) == ConnectionMode.OUTPUT) {
                tex = pc.getTextureForOutputMode();
            }
            if (tex == null) continue;
            this.renderModeConnector(pc, dir, tex);
        }
    }

    private void renderModeConnector(IPowerConduit pc, ForgeDirection dir, lx tex) {
        List verts = (List)VERTS.get(dir);
        if (verts == null) {
            return;
        }
        float uWidth = tex.f() - tex.e();
        float uScale = uWidth * 0.64f;
        float minU = tex.e() + (uWidth - uScale);
        float vScale = tex.h() - tex.g();
        bgd tes = bgd.a;
        for (Vertex v : verts) {
            tes.b(v.nx(), v.ny(), v.nz());
            tes.a(v.x(), v.y(), v.z(), (double)(minU + v.u() * uScale), (double)(tex.g() + v.v() * vScale));
        }
    }

    static {
        float scale = 0.8f;
        BoundingBox refBB = ConduitGeometryUtil.CORE_BOUNDS;
        refBB = refBB.scale(scale, scale, scale);
        refBB = refBB.scale(scale, 1.0f, 1.0f);
        double offset = ConduitGeometryUtil.HWIDTH * scale * scale + 0.05f;
        VertexRotation vrot = new VertexRotation(1.5707963267948966, new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.5, 0.5));
        VertexTranslation vtrans = new VertexTranslation(0.0f, 0.0f, 0.0f);
        VertexTransformComposite xform = new VertexTransformComposite(vrot, vtrans);
        ForgeDirection dir = ForgeDirection.SOUTH;
        Vector3d trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.NORTH;
        vrot.setAngle(4.71238898038469);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.EAST;
        vrot.setAngle(Math.PI);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.WEST;
        vrot.setAngle(0.0);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
        vrot.setAxis(new Vector3d(0.0, 0.0, 1.0));
        dir = ForgeDirection.UP;
        vrot.setAngle(-1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
        dir = ForgeDirection.DOWN;
        vrot.setAngle(1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled(dir, 0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled(dir, offset));
        vtrans.set(trans);
        VERTS.put(dir, PowerConduitRenderer.createVerticesForDir(refBB, xform));
    }
}

