/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;

public class RedstoneConduit
extends AbstractConduit
implements IRedstoneConduit {
    static final Map ICONS = new HashMap();
    protected RedstoneConduitNetwork network;
    protected final Set externalSignals = new HashSet();

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(ly register) {
                ICONS.put("enderio:redstoneConduitCoreOff", register.a("enderio:redstoneConduitCoreOff"));
                ICONS.put("enderio:redstoneConduitCoreOn", register.a("enderio:redstoneConduitCoreOn"));
                ICONS.put("enderio:redstoneConduit", register.a("enderio:redstoneConduit"));
                ICONS.put("enderio:redstoneConduitTransmission", register.a("enderio:redstoneConduitTransmission"));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public boolean isReplaceableByControl(Class replacenebtType) {
        return true;
    }

    @Override
    public wm createItem() {
        return new wm(ModObject.itemRedstoneConduit.actualId, 1, 0);
    }

    @Override
    public Class getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public AbstractConduitNetwork getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction) {
        aqp te = this.bundle.getEntity();
        aab world = te.k;
        if (world == null) {
            return false;
        }
        int id = world.a(te.l + direction.offsetX, te.m + direction.offsetY, te.n + direction.offsetZ);
        if (id > 0 && id != EnderIO.blockConduitBundle.cz) {
            boolean gettingStrongPower;
            boolean toggleNetwork;
            BlockCoord loc = this.getLocation().getLocation(direction);
            boolean bl = toggleNetwork = this.network != null && this.network.isNetworkEnabled();
            if (toggleNetwork) {
                this.network.setNetworkEnabled(false);
            }
            boolean bl2 = gettingStrongPower = world.B(loc.x, loc.y, loc.z) == 15;
            if (toggleNetwork) {
                this.network.setNetworkEnabled(true);
            }
            return apa.r[id].f() || gettingStrongPower;
        }
        return false;
    }

    @Override
    public Set getNetworkInputs() {
        HashSet<Signal> res = new HashSet<Signal>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            int input;
            if (!this.canConnectToExternal(dir) || (input = this.getExternalPowerLevel(dir)) <= 1) continue;
            BlockCoord loc = this.getLocation().getLocation(dir);
            Signal signal = new Signal(loc.x, loc.y, loc.z, input - 1, IRedstoneConduit.SignalColor.RED);
            res.add(signal);
        }
        return res;
    }

    @Override
    public Set getNetworkOutputs(ForgeDirection side) {
        if (this.network == null) {
            return Collections.emptySet();
        }
        return this.network.getSignals();
    }

    @Override
    public boolean onNeighborBlockChange(int blockId) {
        aab world = this.getBundle().getEntity().k;
        if (world.I) {
            return false;
        }
        if (blockId == EnderIO.blockConduitBundle.cz) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        if (blockId > 0 && apa.r[blockId].f() && this.network != null) {
            this.network.destroyNetwork();
            return false;
        }
        return res;
    }

    private int getExternalPowerLevel(ForgeDirection dir) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        aab world = this.getBundle().getEntity().k;
        BlockCoord loc = this.getLocation();
        int result = world.D(loc.x, loc.y, loc.z);
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return result;
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection toDirection) {
        return 0;
    }

    @Override
    public int isProvidingWeakPower(ForgeDirection toDirection) {
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        for (Signal signal : this.network.getSignals()) {
            result = Math.max(result, signal.strength);
        }
        return result;
    }

    @Override
    public lx getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return this.isActive() ? (lx)ICONS.get("enderio:redstoneConduitCoreOn") : (lx)ICONS.get("enderio:redstoneConduitCoreOff");
        }
        return this.isActive() ? (lx)ICONS.get("enderio:redstoneConduitTransmission") : (lx)ICONS.get("enderio:redstoneConduit");
    }

    @Override
    public lx getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }
}

