/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class RedstoneConduitNetwork
extends AbstractConduitNetwork {
    private final Set signals = new HashSet();
    boolean updatingNetwork = false;
    private boolean networkEnabled = true;

    @Override
    public Class getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    @Override
    public void init(IConduitBundle tile, Collection connections, aab world) {
        super.init(tile, connections, world);
        this.updatingNetwork = true;
        this.notifyNeigborsOfSignals();
        this.updatingNetwork = false;
    }

    @Override
    public void destroyNetwork() {
        this.updatingNetwork = true;
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(false);
        }
        ArrayList copy = new ArrayList(this.signals);
        this.signals.clear();
        for (Signal s : copy) {
            this.notifyNeigborsOfSignalUpdate(s);
        }
        this.updatingNetwork = false;
        super.destroyNetwork();
    }

    public void addConduit(IRedstoneConduit con) {
        this.updatingNetwork = true;
        super.addConduit(con);
        Set newInputs = con.getNetworkInputs();
        this.signals.addAll(newInputs);
        for (Signal signal : newInputs) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
        for (Signal signal : this.signals) {
            this.notifyConduitNeighbours(con, signal);
        }
        this.updatingNetwork = false;
    }

    public Set getSignals() {
        if (this.networkEnabled) {
            return this.signals;
        }
        return Collections.emptySet();
    }

    void setNetworkEnabled(boolean enabled) {
        this.networkEnabled = enabled;
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    public void addSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.add(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void removeSignal(Signal signal) {
        this.updatingNetwork = true;
        this.signals.remove(signal);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(signal);
        this.updatingNetwork = false;
    }

    public void replaceSignal(Signal oldSig, Signal newSig) {
        this.updatingNetwork = true;
        this.signals.remove(oldSig);
        this.signals.add(newSig);
        this.notifyNetworkOfUpdate();
        this.notifyNeigborsOfSignalUpdate(newSig);
        this.updatingNetwork = false;
    }

    @Override
    public void notifyNetworkOfUpdate() {
        for (IRedstoneConduit con : this.conduits) {
            con.setActive(!this.getSignals().isEmpty());
        }
        super.notifyNetworkOfUpdate();
    }

    @Override
    public String toString() {
        return "RedstoneConduitNetwork [signals=" + this.signalsString() + ", conduits=" + this.conduitsString() + "]";
    }

    private String conduitsString() {
        StringBuilder sb = new StringBuilder();
        for (IRedstoneConduit con : this.conduits) {
            aqp te = con.getBundle().getEntity();
            sb.append("<");
            sb.append(te.l + "," + te.m + "," + te.n);
            sb.append(">");
        }
        return sb.toString();
    }

    String signalsString() {
        StringBuilder sb = new StringBuilder();
        for (Signal s : this.signals) {
            sb.append("<");
            sb.append(s);
            sb.append(">");
        }
        return sb.toString();
    }

    private void notifyNeigborsOfSignals() {
        for (Signal signal : this.signals) {
            this.notifyNeigborsOfSignalUpdate(signal);
        }
    }

    private void notifyNeigborsOfSignalUpdate(Signal signal) {
        for (IRedstoneConduit con : this.conduits) {
            this.notifyConduitNeighbours(con, signal);
        }
    }

    private void notifyConduitNeighbours(IRedstoneConduit con, Signal signal) {
        if (con.getBundle() == null) {
            System.out.println("RedstoneConduitNetwork.notifyNeigborsOfSignalUpdate: NULL BUNDLE!!!!");
            return;
        }
        aqp te = con.getBundle().getEntity();
        te.k.f(te.l, te.m, te.n, te.k.a(te.l, te.m, te.n));
        if (signal != null && signal.strength >= 15 && signal.x == te.l && signal.y == te.m && signal.z == te.n) {
            te.k.f(te.l + 1, te.m, te.n, te.k.a(te.l + 1, te.m, te.n));
            te.k.f(te.l - 1, te.m, te.n, te.k.a(te.l - 1, te.m, te.n));
            te.k.f(te.l, te.m + 1, te.n, te.k.a(te.l, te.m + 1, te.n));
            te.k.f(te.l, te.m - 1, te.n, te.k.a(te.l, te.m - 1, te.n));
            te.k.f(te.l, te.m, te.n + 1, te.k.a(te.l, te.m, te.n + 1));
            te.k.f(te.l, te.m, te.n - 1, te.k.a(te.l, te.m, te.n - 1));
        }
    }
}

