/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.geom.Offset;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneSwitchBounds;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.render.BoundingBox;
import crazypants.render.IconUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Vector3d;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;

public class RedstoneSwitch
extends RedstoneConduit {
    static final String SWITCH_TAG = "switch";
    public static final String SWITHC_ICON_OFF_KEY = "enderio:redstoneConduitSwitchOff";
    public static final String SWITCH_ICON_ON_KEY = "enderio:redstoneConduitSwitchOn";
    private boolean isOn;

    public static void initIcons() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(ly register) {
                RedstoneConduit.ICONS.put(RedstoneSwitch.SWITHC_ICON_OFF_KEY, register.a(RedstoneSwitch.SWITHC_ICON_OFF_KEY));
                RedstoneConduit.ICONS.put(RedstoneSwitch.SWITCH_ICON_ON_KEY, register.a(RedstoneSwitch.SWITCH_ICON_ON_KEY));
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    @Override
    public boolean isReplaceableByControl(Class replacenebtType) {
        return false;
    }

    @Override
    public wm createItem() {
        return new wm(ModObject.itemRedstoneConduit.actualId, 1, 1);
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection toDirection) {
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        return this.isOn ? 15 : 0;
    }

    @Override
    public void writeToNBT(bs nbtRoot) {
        super.writeToNBT(nbtRoot);
        nbtRoot.a("switchOn", this.isOn);
    }

    @Override
    public void readFromNBT(bs nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.isOn = nbtRoot.n("switchOn");
    }

    lx getSwitchIcon() {
        return this.isOn ? (lx)ICONS.get(SWITCH_ICON_ON_KEY) : (lx)ICONS.get(SWITHC_ICON_OFF_KEY);
    }

    @Override
    public lx getTextureForState(CollidableComponent component) {
        if (SWITCH_TAG.equals(component.data)) {
            return this.isOn ? (lx)ICONS.get(SWITCH_ICON_ON_KEY) : (lx)ICONS.get(SWITHC_ICON_OFF_KEY);
        }
        return super.getTextureForState(component);
    }

    @Override
    public List getCollidableComponents() {
        BoundingBox[] aabb;
        if (this.collidables != null && !this.collidablesDirty) {
            return this.collidables;
        }
        Offset o = this.getBundle().getOffset(this.getBaseConduitType(), ForgeDirection.UNKNOWN);
        Vector3d trans = ConduitGeometryUtil.instance.getTranslation(ForgeDirection.UNKNOWN, o);
        List result = super.getCollidableComponents();
        for (BoundingBox bb : aabb = RedstoneSwitchBounds.getInstance().getAABB()) {
            result.add(new CollidableComponent(IRedstoneConduit.class, bb.translate(trans), ForgeDirection.UNKNOWN, SWITCH_TAG));
        }
        return result;
    }

    @Override
    public boolean onBlockActivated(sq player, RaytraceResult res) {
        if (res.component.data != null && res.component.data.equals(SWITCH_TAG)) {
            this.toggleSwitch();
            return true;
        }
        return false;
    }

    private void toggleSwitch() {
        boolean bl = this.isOn = !this.isOn;
        if (this.network == null) {
            return;
        }
        aqp te = this.bundle.getEntity();
        Signal signal = new Signal(te.l, te.m, te.n, 15, IRedstoneConduit.SignalColor.RED);
        if (this.isOn) {
            this.network.addSignal(signal);
        } else {
            this.network.removeSignal(signal);
        }
    }

    @Override
    public Set getNetworkInputs() {
        Set res = super.getNetworkInputs();
        if (this.isOn) {
            BlockCoord loc = this.getLocation();
            Signal signal = new Signal(loc.x, loc.y, loc.z, 15, IRedstoneConduit.SignalColor.RED);
            res.add(signal);
        }
        return res;
    }
}

