/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneSwitch;
import crazypants.enderio.conduit.redstone.RedstoneSwitchBounds;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import net.minecraftforge.common.ForgeDirection;

public class RedstoneSwitchRenderer
extends DefaultConduitRenderer {
    private static final RedstoneSwitchRenderer instance = new RedstoneSwitchRenderer();
    private final VertexTransform[] xForms;
    private final BoundingBox switchBounds;
    private final BoundingBox connectorBounds;

    public static RedstoneSwitchRenderer getInstance() {
        return instance;
    }

    private RedstoneSwitchRenderer() {
        this.xForms = RedstoneSwitchBounds.getInstance().xForms;
        this.switchBounds = RedstoneSwitchBounds.getInstance().switchBounds;
        this.connectorBounds = RedstoneSwitchBounds.getInstance().connectorBounds;
    }

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit.getClass() == RedstoneSwitch.class;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle bundle, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        super.renderEntity(conduitBundleRenderer, bundle, conduit, x, y, z, partialTick, worldLight);
        RedstoneSwitch sw = (RedstoneSwitch)conduit;
        bgd tessellator = bgd.a;
        float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(null));
        tessellator.a(selfIllum, selfIllum, selfIllum);
        lx[] icons = new lx[6];
        for (int i = 0; i < icons.length; ++i) {
            icons[i] = EnderIO.blockConduitBundle.getConnectorIcon();
        }
        icons[1] = sw.getSwitchIcon();
        Vector3d trans = ConduitGeometryUtil.instance.getTranslation(ForgeDirection.UNKNOWN, bundle.getOffset(IRedstoneConduit.class, ForgeDirection.UNKNOWN));
        BoundingBox bb = this.switchBounds.translate(trans);
        for (VertexTransform tf : this.xForms) {
            CubeRenderer.render(bb, icons, tf);
        }
        bb = this.connectorBounds.translate(trans);
        for (VertexTransform tf : this.xForms) {
            CubeRenderer.render(bb, icons[0], tf);
        }
    }

    @Override
    protected boolean renderComponent(CollidableComponent component) {
        return !"switch".equals(component.data);
    }
}

