/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.BlockConduitBundle;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.facade.BlockConduitFacade;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ConduitBundleRenderer
extends bje
implements ISimpleBlockRenderingHandler {
    private Map connectorBounds = new HashMap();
    public static final float CONNECTOR_DEPTH = 0.05f;

    public ConduitBundleRenderer(float conduitScale) {
        float connectorWidth = 0.25f + conduitScale * 0.5f;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.connectorBounds.put(dir, this.createConnector(dir, 0.05f, connectorWidth));
        }
    }

    public void a(aqp te, double x, double y, double z, float partialTick) {
        int shouldBeLO;
        IConduitBundle bundle = (IConduitBundle)te;
        bdv player = Minecraft.x().g;
        IConduitBundle.FacadeRenderState curRS = bundle.getFacadeRenderedAs();
        IConduitBundle.FacadeRenderState rs = ConduitUtil.getRequiredFacadeRenderState(bundle, (sq)player);
        int curLO = bundle.getLightOpacity();
        int n = shouldBeLO = rs == IConduitBundle.FacadeRenderState.FULL ? 255 : 0;
        if (curLO != shouldBeLO) {
            bundle.setLightOpacity(shouldBeLO);
            te.k.A(te.l, te.m, te.n);
        }
        if (curRS != rs) {
            te.k.p(te.l, te.m, te.n);
        }
        if (curRS == IConduitBundle.FacadeRenderState.FULL) {
            return;
        }
        float val = RenderUtil.claculateTotalBrightnessForLocation(te.k, te.l, te.m, te.n);
        this.renderTileEntityAt(bundle, x, y, z, partialTick, val);
    }

    public void renderTileEntityAt(IConduitBundle bundle, double x, double y, double z, float partialTick, float brightness) {
        RenderUtil.bindBlockTexture();
        Minecraft.x().u.a(0.0);
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        GL11.glEnable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        bgd tessellator = bgd.a;
        tessellator.b();
        HashSet externals = new HashSet();
        for (IConduit con : bundle.getConduits()) {
            ConduitRenderer renderer = EnderIO.proxy.getRendererForConduit(con);
            renderer.renderEntity(this, bundle, con, x, y, z, partialTick, brightness);
            externals.addAll(con.getExternalConnections());
        }
        List connectors = bundle.getConnectors();
        for (CollidableComponent component : connectors) {
            if (component.conduitType != null) {
                IConduit con = bundle.getConduit(component.conduitType);
                float selfIllum = Math.max(brightness, con.getSelfIlluminationForState(component));
                tessellator.a(selfIllum, selfIllum, selfIllum, 1.0f);
                CubeRenderer.render(component.bound, con.getTextureForState(component));
                continue;
            }
            lx tex = EnderIO.blockConduitBundle.getConnectorIcon();
            CubeRenderer.render(component.bound, tex);
        }
        for (ForgeDirection dir : externals) {
            this.renderExternalConnection(dir);
        }
        tessellator.a();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        GL11.glPopAttrib();
        Minecraft.x().u.b(0.0);
    }

    private void renderExternalConnection(ForgeDirection dir) {
        BoundingBox[] bbs;
        lx tex = EnderIO.blockConduitBundle.getConnectorIcon();
        for (BoundingBox bb : bbs = (BoundingBox[])this.connectorBounds.get(dir)) {
            CubeRenderer.render(bb, tex);
        }
    }

    private BoundingBox[] createConnector(ForgeDirection dir, float connectorDepth, float connectorWidth) {
        BoundingBox[] res = new BoundingBox[2];
        float cMin = 0.5f - connectorWidth / 2.0f;
        float cMax = 0.5f + connectorWidth / 2.0f;
        float dMin = 1.0f - connectorDepth / 2.0f;
        float dMax = 1.0f;
        res[0] = ConduitBundleRenderer.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        cMin = 0.5f - connectorWidth / 3.0f;
        cMax = 0.5f + connectorWidth / 3.0f;
        dMin = 1.0f - connectorDepth;
        dMax = 1.0f - connectorDepth / 2.0f;
        res[1] = ConduitBundleRenderer.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        return res;
    }

    private static BoundingBox createConnectorComponent(ForgeDirection dir, float cornerMin, float cornerMax, float depthMin, float depthMax) {
        float minX = (float)(1 - Math.abs(dir.offsetX)) * cornerMin + (float)dir.offsetX * depthMin;
        float minY = (float)(1 - Math.abs(dir.offsetY)) * cornerMin + (float)dir.offsetY * depthMin;
        float minZ = (float)(1 - Math.abs(dir.offsetZ)) * cornerMin + (float)dir.offsetZ * depthMin;
        float maxX = (float)(1 - Math.abs(dir.offsetX)) * cornerMax + (float)dir.offsetX * depthMax;
        float maxY = (float)(1 - Math.abs(dir.offsetY)) * cornerMax + (float)dir.offsetY * depthMax;
        float maxZ = (float)(1 - Math.abs(dir.offsetZ)) * cornerMax + (float)dir.offsetZ * depthMax;
        minX = ConduitBundleRenderer.fix(minX);
        minY = ConduitBundleRenderer.fix(minY);
        minZ = ConduitBundleRenderer.fix(minZ);
        maxX = ConduitBundleRenderer.fix(maxX);
        maxY = ConduitBundleRenderer.fix(maxY);
        maxZ = ConduitBundleRenderer.fix(maxZ);
        BoundingBox bb = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        bb = bb.fixMinMax();
        return bb;
    }

    private static float fix(float val) {
        return val < 0.0f ? 1.0f + val : val;
    }

    public boolean renderWorldBlock(aak world, int x, int y, int z, apa block, int modelId, bgf rb) {
        IConduitBundle bundle = (IConduitBundle)world.r(x, y, z);
        bdv player = Minecraft.x().g;
        if (bundle.hasFacade()) {
            int facadeId = bundle.getFacadeId();
            if (ConduitUtil.isFacadeHidden(bundle, (sq)player)) {
                bundle.setFacadeId(0, false);
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.WIRE_FRAME);
            } else {
                bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.FULL);
            }
            BlockConduitFacade facb = (BlockConduitFacade)apa.r[ModObject.blockConduitFacade.actualId];
            facb.setBlockOverride(bundle);
            facb.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            rb.a((apa)facb);
            rb.p((apa)facb, x, y, z);
            facb.setBlockOverride(null);
            bundle.setFacadeId(facadeId, false);
        } else {
            bundle.setFacadeRenderAs(IConduitBundle.FacadeRenderState.NONE);
        }
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return false;
    }

    public void renderInventoryBlock(apa block, int metadata, int modelID, bgf renderer) {
    }

    public int getRenderId() {
        return BlockConduitBundle.rendererId;
    }
}

