/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.conduit.render.RoundedSegmentRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import java.util.Collection;
import net.minecraftforge.common.ForgeDirection;

public class DefaultConduitRenderer
implements ConduitRenderer {
    protected float transmissionScaleFactor;

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return true;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        Collection components = conduit.getCollidableComponents();
        bgd tessellator = bgd.a;
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        boolean active = conduit.isActive();
        for (CollidableComponent component : components) {
            lx tex;
            if (!this.renderComponent(component)) continue;
            float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
            if (active && this.isNSEWUP(component.dir) && conduit.getTransmitionTextureForState(component) != null) {
                tessellator.a(selfIllum + 0.1f, selfIllum + 0.1f, selfIllum + 0.1f, 0.75f);
                tex = conduit.getTransmitionTextureForState(component);
                this.renderTransmission(tex, component, conduit, selfIllum);
            }
            if ((tex = conduit.getTextureForState(component)) == null) continue;
            tessellator.a(selfIllum, selfIllum, selfIllum);
            this.renderConduit(tex, component);
        }
    }

    protected void renderConduit(lx tex, CollidableComponent component) {
        if (this.isNSEWUP(component.dir)) {
            RoundedSegmentRenderer.renderSegment(component.dir, component.bound, tex.e(), tex.f(), tex.g(), tex.h());
        } else {
            this.drawSection(component.bound, tex.e(), tex.f(), tex.g(), tex.h(), component.dir, true);
        }
    }

    protected void renderTransmission(lx tex, CollidableComponent component, IConduit conduit, float selfIllum) {
        RoundedSegmentRenderer.renderSegment(component.dir, component.bound, tex.e(), tex.f(), tex.g(), tex.h());
    }

    protected boolean renderComponent(CollidableComponent component) {
        return true;
    }

    protected boolean isNSEWUP(ForgeDirection dir) {
        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH || dir == ForgeDirection.EAST || dir == ForgeDirection.WEST || dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    protected void drawSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, ForgeDirection dir, boolean isTransmission) {
        boolean rotateTopBottom;
        CubeRenderer.setupVertices(bound);
        bgd tessellator = bgd.a;
        if (isTransmission) {
            this.setVerticesForTransmission(bound, dir);
        }
        if (dir == ForgeDirection.NORTH || dir == ForgeDirection.UP || dir == ForgeDirection.EAST) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        boolean rotateSides = dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
        boolean bl = rotateTopBottom = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH;
        if (dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH) {
            float tmp;
            tessellator.b(0.0f, 0.0f, -1.0f);
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
            tessellator.b(0.0f, 0.0f, 1.0f);
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
        }
        if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
            tessellator.b(0.0f, 1.0f, 0.0f);
            if (rotateTopBottom) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, minV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, minV);
            }
            tessellator.b(0.0f, -1.0f, 0.0f);
            if (rotateTopBottom) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
            }
        }
        if (dir != ForgeDirection.EAST && dir != ForgeDirection.WEST) {
            tessellator.b(1.0f, 0.0f, 0.0f);
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], maxU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, minV);
            }
            tessellator.b(-1.0f, 0.0f, 0.0f);
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, maxV);
            }
        }
    }

    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection dir) {
        float xs = dir.offsetX == 0 ? this.transmissionScaleFactor : 1.0f;
        float ys = dir.offsetY == 0 ? this.transmissionScaleFactor : 1.0f;
        float zs = dir.offsetZ == 0 ? this.transmissionScaleFactor : 1.0f;
        CubeRenderer.setupVertices(bound.scale(xs, ys, zs));
    }

    public BoundingBox[] toCubes(BoundingBox bb) {
        float width = bb.maxX - bb.minX;
        float height = bb.maxY - bb.minY;
        float depth = bb.maxZ - bb.minZ;
        if (width > 0.0f && height > 0.0f && depth > 0.0f) {
            if (width / depth > 1.5f || depth / width > 1.5f) {
                if (width > depth) {
                    int numSplits = Math.round(width / depth);
                    float newWidth = width / (float)numSplits;
                    BoundingBox[] result = new BoundingBox[numSplits];
                    float lastMax = bb.minX;
                    for (int i = 0; i < numSplits; ++i) {
                        float max = lastMax + newWidth;
                        result[i] = new BoundingBox(lastMax, bb.minY, bb.minZ, max, bb.maxY, bb.maxZ);
                        lastMax = max;
                    }
                    return result;
                }
                int numSplits = Math.round(depth / width);
                float newWidth = depth / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minZ;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, bb.minY, lastMax, bb.maxX, bb.maxY, max);
                    lastMax = max;
                }
                return result;
            }
            if ((double)(height / width) > 1.5) {
                int numSplits = Math.round(height / width);
                float newWidth = height / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minY;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, lastMax, bb.minZ, bb.maxX, max, bb.maxZ);
                    lastMax = max;
                }
                return result;
            }
        }
        return new BoundingBox[]{bb};
    }
}

