/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class ItemConduitRenderer
implements IItemRenderer {
    private final BoundingBox bb;

    public ItemConduitRenderer() {
        float scale = 0.8f;
        this.bb = BoundingBox.UNIT_CUBE.scale(scale, scale, scale);
    }

    public boolean handleRenderType(wm item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, wm item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, wm item, Object ... data) {
        bgf renderBlocks = (bgf)data[0];
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            this.renderToInventory(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.renderEquipped(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderEntity(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderEntity(item, renderBlocks);
        } else {
            System.out.println("FacadeRenderer.renderItem: Unsupported render type");
        }
    }

    private void renderEntity(wm item, bgf renderBlocks) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    private void renderEquipped(wm item, bgf renderBlocks) {
        this.renderToInventory(item, renderBlocks);
    }

    private void renderToInventory(wm item, bgf renderBlocks) {
        bgd.a.b();
        CubeRenderer.render(this.bb, item.b().a_(item.k()));
        bgd.a.a();
    }
}

