/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.render.BoundingBox;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vertex;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;

public class RoundedSegmentRenderer {
    private static Vertex[][] DIR_COORDS;
    private static final Vector3d REF_TRANS;

    private static Vertex[] xformCoords(Vertex[] refCoords, Matrix4d rotMat, Vector3d trans) {
        Vertex[] res = new Vertex[refCoords.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Vertex(refCoords[i]);
            res[i].transform(rotMat);
            res[i].translate(trans);
        }
        return res;
    }

    private static Vertex[] xformCoords(List refCoords, Matrix4d rotMat, Vector3d trans) {
        Vertex[] res = new Vertex[refCoords.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Vertex((Vertex)refCoords.get(i));
            res[i].transform(rotMat);
            res[i].translate(trans);
        }
        return res;
    }

    public static Vertex[] createUnitCrossSection(double xOffset, double yOffset, double zOffset, int numCoords, int u) {
        Vertex[] crossSection = new Vertex[numCoords];
        double angle = 0.0;
        double inc = Math.PI * 2 / (double)(crossSection.length - 1);
        for (int i = 0; i < crossSection.length; ++i) {
            double x = Math.cos(angle) * 0.5;
            double y = Math.sin(angle) * 0.5;
            angle += inc;
            crossSection[i] = new Vertex();
            crossSection[i].setXYZ(xOffset + x, yOffset + y, zOffset);
            crossSection[i].setNormal(x, y, 0.0);
            crossSection[i].setUV(u, y + 0.5);
        }
        return crossSection;
    }

    public static void renderSegment(ForgeDirection dir, BoundingBox bounds, float minU, float maxU, float minV, float maxV) {
        Vertex[] coords;
        float uScale = maxU - minU;
        float vScale = maxV - minV;
        Vector3d offset = RoundedSegmentRenderer.calcOffset(dir, bounds);
        bgd tes = bgd.a;
        for (Vertex coord : coords = DIR_COORDS[dir.ordinal()]) {
            double u = minU + coord.uv.x * uScale;
            double v = minV + coord.uv.y * vScale;
            tes.b(coord.normal.x, coord.normal.y, coord.normal.z);
            tes.a(offset.x + coord.xyz.x, offset.y + coord.xyz.y, offset.z + coord.xyz.z, u, v);
        }
    }

    private static Vector3d calcOffset(ForgeDirection dir, BoundingBox bounds) {
        Vector3d res = new Vector3d();
        Vector3d center = bounds.getCenter();
        if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
            res.set(0.0, center.y - RoundedSegmentRenderer.REF_TRANS.y, 0.0);
        } else {
            res.set(center.x - RoundedSegmentRenderer.REF_TRANS.x, 0.0, 0.0);
        }
        return res;
    }

    public static Vertex[] createUnitSectionQuads(int numCoords, double minZ, double maxZ) {
        Vertex[] z0 = RoundedSegmentRenderer.createUnitCrossSection(0.0, 0.0, minZ, numCoords + 1, 0);
        Vertex[] z1 = RoundedSegmentRenderer.createUnitCrossSection(0.0, 0.0, maxZ, numCoords + 1, 1);
        Vertex[] result = new Vertex[numCoords * 4];
        for (int i = 0; i < numCoords; ++i) {
            int index = i * 4;
            result[index] = new Vertex(z0[i]);
            result[index + 1] = new Vertex(z0[i + 1]);
            result[index + 2] = new Vertex(z1[i + 1]);
            result[index + 3] = new Vertex(z1[i]);
        }
        return result;
    }

    static {
        Vertex[] refCoords;
        DIR_COORDS = new Vertex[ForgeDirection.VALID_DIRECTIONS.length][];
        REF_TRANS = new Vector3d(0.5, 0.5, 0.5);
        double circ = (double)ConduitGeometryUtil.WIDTH * 0.7;
        for (Vertex coord : refCoords = RoundedSegmentRenderer.createUnitSectionQuads(16, -0.25, 0.25)) {
            coord.xyz.x *= circ;
            coord.xyz.y *= circ;
        }
        Matrix4d rotMat = new Matrix4d();
        rotMat.setIdentity();
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.SOUTH.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.SOUTH, 0.25));
        rotMat.makeRotationY(Math.PI);
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.NORTH.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.NORTH, 0.25));
        rotMat.makeRotationY(1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.EAST.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.EAST, 0.25));
        rotMat.makeRotationY(-1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.WEST.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.WEST, 0.25));
        rotMat.makeRotationX(-1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.UP.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.UP, 0.25));
        rotMat.makeRotationX(1.5707963267948966);
        rotMat.setTranslation(REF_TRANS);
        RoundedSegmentRenderer.DIR_COORDS[ForgeDirection.DOWN.ordinal()] = RoundedSegmentRenderer.xformCoords(refCoords, rotMat, ForgeDirectionOffsets.offsetScaled(ForgeDirection.DOWN, 0.25));
    }
}

