/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.enderface;

import cpw.mods.fml.common.network.PacketDispatcher;
import crazypants.enderio.ModObject;
import crazypants.enderio.PacketHandler;
import crazypants.render.RenderUtil;
import crazypants.util.BlockCoord;
import crazypants.vecmath.Camera;
import crazypants.vecmath.Matrix4d;
import crazypants.vecmath.VecmathUtil;
import crazypants.vecmath.Vector3d;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiEnderface
extends axr {
    protected static final bgf RB = new bgf();
    private float pitch = -45.0f;
    private float yaw = 45.0f;
    private final sq player;
    private final aab world;
    private final int ioX;
    private final int ioY;
    private final int ioZ;
    private boolean chunkLoaded;
    private List blocks = new ArrayList();
    private int gw;
    private int gh;
    private int guiLeft;
    private int guiTop;
    private int finalGw;
    private int finalGh;
    private boolean animateInX = false;
    private boolean animateInY = false;
    float animationDuration = 180.0f;
    private final Vector3d origin = new Vector3d();
    private final Vector3d eye = new Vector3d();
    private final Camera camera = new Camera();
    private final Matrix4d pitchRot = new Matrix4d();
    private final Matrix4d yawRot = new Matrix4d();
    private float scaleAnimX;
    private int range;
    boolean dragging = false;
    private double distance;
    private long initTime;
    private float portalFade = 1.0f;

    public GuiEnderface(sq player, aab world, int ioX, int ioY, int ioZ) {
        this.player = player;
        this.world = world;
        this.ioX = ioX;
        this.ioY = ioY;
        this.ioZ = ioZ;
        this.distance = 10 + this.range * 2;
        this.origin.set((double)ioX + 0.5, (double)ioY + 0.5, (double)ioZ + 0.5);
        this.pitchRot.setIdentity();
        this.yawRot.setIdentity();
        abw c = world.d(ioX, ioZ);
        this.chunkLoaded = c != null && c.d;
        GuiEnderface.RB.a = world;
        this.blocks.add(new ViewableBlocks(ioX, ioY, ioZ, ModObject.blockEnderIo.id));
        this.range = 3;
        for (int x = ioX - this.range; x <= ioX + this.range; ++x) {
            for (int y = ioY - this.range; y <= ioY + this.range; ++y) {
                for (int z = ioZ - this.range; z <= ioZ + this.range; ++z) {
                    int blockId = world.a(x, y, z);
                    if (blockId <= 0 || blockId >= apa.r.length) continue;
                    this.blocks.add(new ViewableBlocks(x, y, z, blockId));
                }
            }
        }
    }

    public void A_() {
        this.finalGw = this.h * 1;
        this.finalGh = this.i * 1;
        this.gw = this.finalGw;
        this.gh = this.finalGh;
        this.guiLeft = (this.h - this.gw) / 2;
        this.guiTop = (this.i - this.gh) / 2;
        this.initTime = this.world.H();
    }

    public boolean f() {
        return false;
    }

    public void d() {
        Vector3d end;
        Vector3d start;
        int y;
        int x;
        super.d();
        if (Mouse.getEventButton() == 0) {
            this.dragging = Mouse.getEventButtonState();
        }
        if (this.dragging) {
            this.yaw = (float)((double)this.yaw - (double)Mouse.getEventDX() / (double)this.g.c * 180.0);
            this.pitch = (float)((double)this.pitch + (double)Mouse.getEventDY() / (double)this.g.d * 180.0);
            this.pitch = (float)VecmathUtil.clamp(this.pitch, -80.0, 80.0);
        }
        this.distance -= (double)Mouse.getDWheel() * 0.01;
        this.distance = VecmathUtil.clamp(this.distance, 0.1, 20.0);
        long elapsed = this.world.H() - this.initTime;
        if (Mouse.getEventButton() == 1 && !Mouse.getEventButtonState() && this.camera.isValid() && elapsed > 10L && this.camera.getRayForPixel(x = Mouse.getEventX(), y = Mouse.getEventY(), start = new Vector3d(), end = new Vector3d())) {
            end.scale(this.distance * 2.0);
            end.add(start);
            this.doSelection(start, end);
        }
    }

    private void doSelection(Vector3d start, Vector3d end) {
        start.add(this.origin);
        end.add(this.origin);
        ArrayList<ara> hits = new ArrayList<ara>();
        for (ViewableBlocks ug2 : this.blocks) {
            ara res;
            if (ug2.bc.equals(new BlockCoord(this.ioX, this.ioY, this.ioZ)) || (res = apa.r[ug2.blockId].a(this.world, ug2.bc.x, ug2.bc.y, ug2.bc.z, arc.a((double)start.x, (double)start.y, (double)start.z), arc.a((double)end.x, (double)end.y, (double)end.z))) == null) continue;
            hits.add(res);
        }
        ara hit = GuiEnderface.getClosestHit(arc.a((double)start.x, (double)start.y, (double)start.z), hits);
        if (hit != null) {
            int id = this.world.a(hit.b, hit.c, hit.d);
            if (id == ModObject.blockHyperCube.actualId || id == ModObject.blockCapacitorBank.actualId) {
                apa.r[id].a(this.world, hit.b, hit.c, hit.d, this.player, 0, 0.0f, 0.0f, 0.0f);
            } else {
                this.openInterface(hit.b, hit.c, hit.d);
            }
        }
    }

    public static ara getClosestHit(arc origin, Collection candidates) {
        double minLengthSquared = Double.POSITIVE_INFINITY;
        ara closest = null;
        for (ara hit : candidates) {
            double lengthSquared;
            if (hit == null || !((lengthSquared = hit.f.e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            closest = hit;
        }
        return closest;
    }

    public void a(int par1, int par2, float partialTick) {
        this.animateBackground(partialTick);
        this.e();
        avb.a();
        avb.c();
        this.drawEnderfaceBackground();
        if (!this.updateCamera(partialTick)) {
            return;
        }
        this.applyCamera(partialTick);
        if (!this.animateInX && !this.animateInY) {
            if (this.chunkLoaded) {
                GL11.glEnable((int)2884);
                GL11.glEnable((int)32826);
                avb.a();
                this.g.u.b(0.0);
                RenderUtil.bindBlockTexture();
                Vector3d trans = new Vector3d(-this.origin.x + this.eye.x, -this.origin.y + this.eye.y, -this.origin.z + this.eye.z);
                bgd.a.b();
                bgd.a.b(trans.x, trans.y, trans.z);
                for (ViewableBlocks ug2 : this.blocks) {
                    RB.a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                    RB.b(apa.r[ug2.blockId], ug2.bc.x, ug2.bc.y, ug2.bc.z);
                }
                bgd.a.a();
                bgd.a.b(0.0, 0.0, 0.0);
                avb.b();
                bjd.a.j = this.origin.x - this.eye.x;
                bjd.a.k = this.origin.y - this.eye.y;
                bjd.a.l = this.origin.z - this.eye.z;
                bjd.b = this.origin.x - this.eye.x;
                bjd.c = this.origin.y - this.eye.y;
                bjd.d = this.origin.z - this.eye.z;
                for (ViewableBlocks ug2 : this.blocks) {
                    aqp tile = this.world.r(ug2.bc.x, ug2.bc.y, ug2.bc.z);
                    if (tile == null) continue;
                    bjd.a.a(tile, partialTick);
                }
            } else {
                this.a(this.m, "EnderIO chunk not loaded.", this.h / 2, this.i / 2 - 32, -1);
            }
        }
        this.drawEffectOverlay(partialTick);
    }

    private boolean updateCamera(float partialTick) {
        axs scaledresolution = new axs(this.g.z, this.g.c, this.g.d);
        int vpx = this.guiLeft * scaledresolution.e();
        int vpy = this.guiTop * scaledresolution.e();
        int vpw = (int)((float)this.gw / (float)this.h * (float)this.g.c);
        int vph = (int)((float)this.gh / (float)this.i * (float)this.g.d);
        if (vpw <= 0 || vph <= 0) {
            return false;
        }
        this.camera.setViewport(vpx, vpy, vpw, vph);
        this.camera.setProjectionMatrixAsPerspective(30.0, 0.05, 50.0, vpw, vph);
        this.eye.set(0.0, 0.0, this.distance);
        this.pitchRot.makeRotationX(Math.toRadians(this.pitch));
        this.yawRot.makeRotationY(Math.toRadians(this.yaw));
        this.pitchRot.transform(this.eye);
        this.yawRot.transform(this.eye);
        this.camera.setViewMatrixAsLookAt(this.eye, RenderUtil.ZERO_V, RenderUtil.UP_V);
        return this.camera.isValid();
    }

    private void applyCamera(float partialTick) {
        Rectangle vp = this.camera.getViewport();
        GL11.glViewport((int)vp.x, (int)vp.y, (int)vp.width, (int)vp.height);
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        RenderUtil.loadMatrix(this.camera.getTransposeProjectionMatrix());
        GL11.glMatrixMode((int)5888);
        RenderUtil.loadMatrix(this.camera.getTransposeViewMatrix());
        this.scaleAnimX = (float)((double)this.scaleAnimX + (double)partialTick * 0.25);
        float v = 0.4f;
        float sf = 1.0f * (1.0f + v / 32.0f);
        GL11.glRotatef((float)((this.scaleAnimX + partialTick) * 7.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)sf, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)(-(this.scaleAnimX + partialTick) * 7.0f), (float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)(-((float)this.eye.x)), (float)(-((float)this.eye.y)), (float)(-((float)this.eye.z)));
    }

    private void drawEffectOverlay(float partialTick) {
        axs scaledresolution = new axs(this.g.z, this.g.c, this.g.d);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)scaledresolution.c(), (double)scaledresolution.d(), (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3008);
        GL11.glDepthMask((boolean)false);
        avb.a();
        avb.c();
        GL11.glDisable((int)2896);
        this.g.u.a(0.0);
        this.portalFade -= partialTick * (1.0f / this.animationDuration);
        this.portalFade = Math.max(0.0f, this.portalFade);
        if (this.portalFade >= 0.0f) {
            this.drawRect(scaledresolution.a(), scaledresolution.b(), 0.0f, 0.3f, 0.16f, Math.max(0.3f, this.portalFade));
        }
        GL11.glEnable((int)2896);
        this.g.u.b(0.0);
        this.renderPortalOverlay(0.9f - 0.1f * (1.0f - this.portalFade), scaledresolution.a(), scaledresolution.b());
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void renderPortalOverlay(float par1, int par2, int par3) {
        if (par1 < 1.0f) {
            par1 *= par1;
            par1 *= par1;
            par1 = par1 * 0.8f + 0.2f;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)par1);
        RenderUtil.bindBlockTexture();
        lx icon = apa.bi.m(1);
        float f1 = icon.e();
        float f2 = icon.g();
        float f3 = icon.f();
        float f4 = icon.h();
        bgd tessellator = bgd.a;
        tessellator.b();
        tessellator.a(0.0, (double)par3, -90.0, (double)f1, (double)f4);
        tessellator.a((double)par2, (double)par3, -90.0, (double)f3, (double)f4);
        tessellator.a((double)par2, 0.0, -90.0, (double)f3, (double)f2);
        tessellator.a(0.0, 0.0, -90.0, (double)f1, (double)f2);
        tessellator.a();
    }

    private boolean animating() {
        return this.gw < this.finalGw || this.gh < this.finalGh;
    }

    private void drawRect(int width, int height, float r, float g, float b, float a) {
        bgd tessellator = bgd.a;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.b();
        tessellator.a(0.0, (double)height, 0.0);
        tessellator.a((double)width, (double)height, 0.0);
        tessellator.a((double)width, 0.0, 0.0);
        tessellator.a(0.0, 0.0, 0.0);
        tessellator.a();
        GL11.glEnable((int)3553);
    }

    private void animateBackground(float partialTick) {
        if (!this.animating()) {
            return;
        }
        int mag = (int)((float)this.h / (this.animationDuration * 0.5f) * partialTick);
        int mag2 = mag * 2;
        int ymag = (int)((float)this.i / (this.animationDuration * 0.5f) * partialTick);
        int ymag2 = ymag * 2;
        if (this.animateInX) {
            this.gw -= mag2;
            this.guiLeft += mag;
            if (this.gw <= 0) {
                this.animateInX = false;
            }
        } else {
            this.gw += mag2;
            this.guiLeft -= mag;
        }
        if (this.animateInY) {
            this.gh -= ymag2;
            this.guiTop += ymag;
            if (this.gh <= 0) {
                this.animateInY = false;
            }
        } else {
            this.gh += ymag2;
            this.guiTop -= ymag;
        }
        this.gw = Math.min(this.gw, this.finalGw);
        this.gh = Math.min(this.gh, this.finalGh);
        this.guiLeft = Math.max((this.h - this.finalGw) / 2, this.guiLeft);
        this.guiTop = Math.max((this.i - this.finalGh) / 2, this.guiTop);
    }

    private void drawEnderfaceBackground() {
        int w = this.gw;
        int h = this.gh;
        int left = this.guiLeft;
        int top = this.guiTop;
        int cx = left + w / 2;
        int cy = top + h / 2;
        GuiEnderface.a((int)left, (int)top, (int)(left + w), (int)(top + h), (int)-16777216);
        ++left;
        ++top;
        w -= 2;
        h -= 2;
        int topH = -1;
        int botH = -11184811;
        int rightH = -11184811;
        int leftH = -1;
        if (this.animateInX) {
            leftH = -11184811;
            rightH = -1;
        }
        if (this.animateInY) {
            topH = -11184811;
            botH = -1;
        }
        GuiEnderface.a((int)(++left), (int)(++top), (int)(left + (w -= 2)), (int)(top + (h -= 2)), (int)-16764132);
    }

    void openInterface(int targetX, int targetY, int targetZ) {
        dk pkt = PacketHandler.getPacketEnderface(targetX, targetY, targetZ);
        PacketDispatcher.sendPacketToServer((ei)pkt);
    }

    static class ViewableBlocks {
        BlockCoord bc;
        int blockId;

        private ViewableBlocks(int x, int y, int z, int blockId) {
            this.bc = new BlockCoord(x, y, z);
            this.blockId = blockId;
        }
    }
}

