/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ClientProxy;
import crazypants.enderio.EnderIO;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.render.IconUtil;
import crazypants.util.Util;
import java.util.Random;

public abstract class AbstractMachineBlock
extends akz
implements IGuiHandler {
    public static final lx[] REDSTONE_CONTROL_ICONS = new lx[RedstoneControlMode.values().length];
    @SideOnly(value=Side.CLIENT)
    protected lx[][] iconBuffer;
    protected final Random random;
    protected final ModObject modObject;
    protected final Class teClass;

    @SideOnly(value=Side.CLIENT)
    public static void initIcon() {
        IconUtil.addIconProvider(new IconUtil.IIconProvider(){

            @Override
            public void registerIcons(ly iconRegister) {
                AbstractMachineBlock.REDSTONE_CONTROL_ICONS[RedstoneControlMode.IGNORE.ordinal()] = iconRegister.a("enderio:iconRedstoneIgnore");
                AbstractMachineBlock.REDSTONE_CONTROL_ICONS[RedstoneControlMode.ON.ordinal()] = iconRegister.a("enderio:iconRedstoneOn");
                AbstractMachineBlock.REDSTONE_CONTROL_ICONS[RedstoneControlMode.OFF.ordinal()] = iconRegister.a("enderio:iconRedstoneOff");
                AbstractMachineBlock.REDSTONE_CONTROL_ICONS[RedstoneControlMode.NEVER.ordinal()] = iconRegister.a("enderio:iconRedstoneNever");
            }

            @Override
            public int getTextureType() {
                return 0;
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public static lx getRedstoneControlIcon(RedstoneControlMode mode) {
        return REDSTONE_CONTROL_ICONS[mode.ordinal()];
    }

    protected AbstractMachineBlock(ModObject mo, Class teClass) {
        super(mo.id, new aif(aih.h));
        this.modObject = mo;
        this.teClass = teClass;
        this.c(2.0f);
        this.a(k);
        this.c(mo.unlocalisedName);
        this.a(EnderIOTab.tabEnderIO);
        this.random = new Random();
    }

    protected void init() {
        LanguageRegistry.addName((Object)((Object)this), (String)this.modObject.name);
        GameRegistry.registerBlock((apa)this, (String)this.modObject.unlocalisedName);
        GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.modObject.unlocalisedName + "TileEntity"));
        EnderIO.guiHandler.registerGuiHandler(this.getGuiId(), this);
    }

    public aqp b(aab world) {
        return null;
    }

    public aqp createTileEntity(aab world, int metadata) {
        try {
            return (aqp)this.teClass.newInstance();
        }
        catch (Exception e) {
            FMLCommonHandler.instance().raiseException((Throwable)e, "Could not create tile entity from class " + this.teClass, true);
            return null;
        }
    }

    public boolean a(aab world, int x, int y, int z, sq entityPlayer, int par6, float par7, float par8, float par9) {
        IToolWrench wrench;
        if (ConduitUtil.isToolEquipped(entityPlayer) && entityPlayer.ag() && entityPlayer.cd().b() instanceof IToolWrench && (wrench = (IToolWrench)entityPlayer.cd().b()).canWrench(entityPlayer, x, y, z)) {
            this.removeBlockByPlayer(world, entityPlayer, x, y, z);
            if (entityPlayer.cd().b() instanceof IToolWrench) {
                ((IToolWrench)entityPlayer.cd().b()).wrenchUsed(entityPlayer, x, y, z);
            }
            return true;
        }
        if (entityPlayer.ag()) {
            return false;
        }
        entityPlayer.openGui((Object)EnderIO.instance, this.getGuiId(), world, x, y, z);
        return true;
    }

    public void a(ly iconRegister) {
        this.iconBuffer = new lx[1][12];
        String side = this.getSideIconKey();
        this.iconBuffer[0][0] = iconRegister.a(side);
        this.iconBuffer[0][1] = iconRegister.a(side);
        this.iconBuffer[0][2] = iconRegister.a(side);
        this.iconBuffer[0][3] = iconRegister.a(this.getMachineFrontIconKey(false));
        this.iconBuffer[0][4] = iconRegister.a(side);
        this.iconBuffer[0][5] = iconRegister.a(side);
        this.iconBuffer[0][6] = iconRegister.a(side);
        this.iconBuffer[0][7] = iconRegister.a(side);
        this.iconBuffer[0][8] = iconRegister.a(side);
        this.iconBuffer[0][9] = iconRegister.a(this.getMachineFrontIconKey(true));
        this.iconBuffer[0][10] = iconRegister.a(side);
        this.iconBuffer[0][11] = iconRegister.a(side);
    }

    public lx b_(aak world, int x, int y, int z, int blockSide) {
        aqp te = world.r(x, y, z);
        short facing = 0;
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            facing = me.facing;
        }
        if (this.isActive(world, x, y, z)) {
            return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing] + 6];
        }
        return this.iconBuffer[0][ClientProxy.sideAndFacingToSpriteOffset[blockSide][facing]];
    }

    public lx a(int blockSide, int blockMeta) {
        return this.iconBuffer[0][blockSide];
    }

    public void a(aab world, int x, int y, int z, int par5, int par6) {
        aqp ent;
        if (!world.I && world.N().b("doTileDrops") && (ent = world.r(x, y, z)) != null && this.teClass.isAssignableFrom(ent.getClass())) {
            AbstractMachineEntity te = (AbstractMachineEntity)world.r(x, y, z);
            Util.dropItems(world, te, x, y, z, true);
        }
        world.s(x, y, z);
    }

    public boolean removeBlockByPlayer(aab world, sq player, int x, int y, int z) {
        if (!world.I && !player.ce.d) {
            wm st = new wm((apa)this);
            Util.dropItems(world, st, x, y, z, false);
        }
        return super.removeBlockByPlayer(world, player, x, y, z);
    }

    public int a(int par1, Random par2Random, int par3) {
        return 0;
    }

    public int a(Random r) {
        return 0;
    }

    public void a(aab world, int x, int y, int z, ng player, wm stack) {
        super.a(world, x, y, z, player, stack);
        int heading = kx.c((double)((double)(player.A * 4.0f / 360.0f) + 0.5)) & 3;
        AbstractMachineEntity te = (AbstractMachineEntity)world.r(x, y, z);
        switch (heading) {
            case 0: {
                te.setFacing((short)2);
                break;
            }
            case 1: {
                te.setFacing((short)5);
                break;
            }
            case 2: {
                te.setFacing((short)3);
                break;
            }
            case 3: {
                te.setFacing((short)4);
                break;
            }
        }
        world.j(x, y, z);
    }

    public void a(aab world, int x, int y, int z) {
        super.a(world, x, y, z);
        world.j(x, y, z);
    }

    public void a(aab world, int x, int y, int z, int blockId) {
        aqp ent = world.r(x, y, z);
        if (ent instanceof AbstractMachineEntity) {
            AbstractMachineEntity te = (AbstractMachineEntity)ent;
            te.onNeighborBlockChange(blockId);
        }
    }

    public void b(aab world, int x, int y, int z, Random rand) {
        if (this.isActive((aak)world, x, y, z)) {
            float startX = (float)x + 1.0f;
            float startY = (float)y + 1.0f;
            float startZ = (float)z + 1.0f;
            for (int i = 0; i < 4; ++i) {
                float xOffset = -0.2f - rand.nextFloat() * 0.6f;
                float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                float zOffset = -0.2f - rand.nextFloat() * 0.6f;
                world.a("smoke", (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0);
            }
        }
    }

    protected String getSideIconKey() {
        return "enderio:machineSide";
    }

    protected abstract int getGuiId();

    protected abstract String getMachineFrontIconKey(boolean var1);

    private boolean isActive(aak blockAccess, int x, int y, int z) {
        return ((AbstractMachineEntity)blockAccess.r(x, y, z)).isActive();
    }
}

