/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import buildcraft.api.power.IPowerProvider;
import crazypants.enderio.ModObject;
import crazypants.enderio.PacketHandler;
import crazypants.enderio.machine.IMachine;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.EnderPowerProvider;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IInternalPowerReceptor;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.vecmath.VecmathUtil;
import net.minecraftforge.common.ForgeDirection;

public abstract class AbstractMachineEntity
extends aqp
implements lt,
IInternalPowerReceptor,
IMachine {
    public short facing;
    protected int ticksSinceSync = -1;
    protected boolean forceClientUpdate = true;
    protected boolean lastActive;
    protected float lastSyncPowerStored = -1.0f;
    protected Capacitors capacitorType;
    private float storedEnergy;
    protected wm[] inventory;
    protected final SlotDefinition slotDefinition;
    protected EnderPowerProvider powerHandler;
    protected RedstoneControlMode redstoneControlMode;
    protected boolean redstoneCheckPassed;

    public AbstractMachineEntity(SlotDefinition slotDefinition) {
        this.slotDefinition = slotDefinition;
        this.facing = (short)3;
        this.capacitorType = Capacitors.BASIC_CAPACITOR;
        this.powerHandler = PowerHandlerUtil.createHandler(this.capacitorType.capacitor);
        this.inventory = new wm[slotDefinition.getNumSlots()];
        this.redstoneControlMode = RedstoneControlMode.IGNORE;
    }

    public SlotDefinition getSlotDefinition() {
        return this.slotDefinition;
    }

    public boolean isValidUpgrade(wm itemstack) {
        for (int i = this.slotDefinition.getMinUpgradeSlot(); i <= this.slotDefinition.getMaxUpgradeSlot(); ++i) {
            if (!this.b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidInput(wm itemstack) {
        for (int i = this.slotDefinition.getMinInputSlot(); i <= this.slotDefinition.getMaxInputSlot(); ++i) {
            if (!this.b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidOutput(wm itemstack) {
        for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot(); ++i) {
            if (!this.b(i, itemstack)) continue;
            return true;
        }
        return false;
    }

    public final boolean b(int i, wm itemstack) {
        if (this.slotDefinition.isUpgradeSlot(i)) {
            return itemstack.c == ModObject.itemBasicCapacitor.actualId && itemstack.k() > 0;
        }
        return this.isMachineItemValidForSlot(i, itemstack);
    }

    protected abstract boolean isMachineItemValidForSlot(int var1, wm var2);

    public RedstoneControlMode getRedstoneControlMode() {
        return this.redstoneControlMode;
    }

    public void setRedstoneControlMode(RedstoneControlMode redstoneControlMode) {
        this.redstoneControlMode = redstoneControlMode;
    }

    @Override
    public EnderPowerProvider getPowerHandler() {
        return this.powerHandler;
    }

    @Override
    public void applyPerdition() {
    }

    public short getFacing() {
        return this.facing;
    }

    public void setFacing(short facing) {
        this.facing = facing;
    }

    public abstract boolean isActive();

    public abstract float getProgress();

    public int getProgressScaled(int scale) {
        int result = (int)(this.getProgress() * (float)scale);
        return result;
    }

    public boolean hasPower() {
        boolean hasPower = this.powerHandler.getEnergyStored() > 0.0f;
        return hasPower;
    }

    public ICapacitor getCapacitor() {
        return this.capacitorType.capacitor;
    }

    public int getEnergyStoredScaled(int scale) {
        return VecmathUtil.clamp(Math.round((float)scale * (this.storedEnergy / (float)this.capacitorType.capacitor.getMaxEnergyStored())), 0, scale);
    }

    public float getEnergyStored() {
        return this.storedEnergy;
    }

    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        PowerHandlerUtil.configure(this.powerHandler, capacitorType.capacitor);
        this.forceClientUpdate = true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerHandler;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        return (int)((float)this.powerHandler.getMaxEnergyStored() - this.powerHandler.getEnergyStored());
    }

    protected float getPowerUsePerTick() {
        return this.capacitorType.capacitor.getMaxEnergyExtracted();
    }

    public void h() {
        if (this.k == null) {
            return;
        }
        if (this.k.I) {
            if (this.isActive() != this.lastActive) {
                this.k.p(this.l, this.m, this.n);
            }
            this.lastActive = this.isActive();
            return;
        }
        boolean requiresClientSync = false;
        if (this.forceClientUpdate) {
            this.forceClientUpdate = false;
            requiresClientSync = true;
        }
        boolean prevRedCheck = this.redstoneCheckPassed;
        this.redstoneCheckPassed = RedstoneControlMode.isConditionMet(this.redstoneControlMode, this);
        requiresClientSync |= prevRedCheck != this.redstoneCheckPassed;
        requiresClientSync |= this.processTasks(this.redstoneCheckPassed);
        if (requiresClientSync |= this.lastSyncPowerStored != this.powerHandler.getEnergyStored() && this.k.H() % 16L == 0L) {
            this.lastSyncPowerStored = this.powerHandler.getEnergyStored();
            this.k.j(this.l, this.m, this.n);
            this.k.b(this.l, this.m, this.n, (aqp)this);
        }
    }

    protected abstract boolean processTasks(boolean var1);

    public ei m() {
        return PacketHandler.getPacket(this);
    }

    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.facing = nbtRoot.d("facing");
        this.setCapacitor(Capacitors.values()[nbtRoot.d("capacitorType")]);
        float storedEnergy = nbtRoot.g("storedEnergy");
        this.powerHandler.setEnergy(storedEnergy);
        this.storedEnergy = storedEnergy;
        this.redstoneCheckPassed = nbtRoot.n("redstoneCheckPassed");
        this.inventory = new wm[this.slotDefinition.getNumSlots()];
        ca itemList = nbtRoot.m("Items");
        for (int i = 0; i < itemList.c(); ++i) {
            bs itemStack = (bs)itemList.b(i);
            byte slot = itemStack.c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = wm.a((bs)itemStack);
        }
        int rsContr = nbtRoot.e("redstoneControlMode");
        if (rsContr < 0 || rsContr >= RedstoneControlMode.values().length) {
            rsContr = 0;
        }
        this.redstoneControlMode = RedstoneControlMode.values()[rsContr];
    }

    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        nbtRoot.a("facing", this.facing);
        nbtRoot.a("storedEnergy", this.powerHandler.getEnergyStored());
        nbtRoot.a("capacitorType", (short)this.capacitorType.ordinal());
        nbtRoot.a("redstoneCheckPassed", this.redstoneCheckPassed);
        ca itemList = new ca();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            bs itemStackNBT = new bs();
            itemStackNBT.a("Slot", (byte)i);
            this.inventory[i].b(itemStackNBT);
            itemList.a((cf)itemStackNBT);
        }
        nbtRoot.a("Items", (cf)itemList);
        nbtRoot.a("redstoneControlMode", this.redstoneControlMode.ordinal());
    }

    public boolean c() {
        return false;
    }

    public boolean a(sq player) {
        if (this.k == null) {
            return true;
        }
        if (this.k.r(this.l, this.m, this.n) != this) {
            return false;
        }
        return player.e((double)this.l + 0.5, (double)this.m + 0.5, (double)this.n + 0.5) <= 64.0;
    }

    public int j_() {
        return this.slotDefinition.getNumSlots();
    }

    public int d() {
        return 64;
    }

    public wm a(int slot) {
        return this.inventory[slot];
    }

    public wm a(int fromSlot, int amount) {
        wm fromStack = this.inventory[fromSlot];
        if (fromStack == null) {
            return null;
        }
        if (fromStack.a <= amount) {
            this.inventory[fromSlot] = null;
            this.updateCapacitorFromSlot();
            return fromStack;
        }
        wm result = new wm(fromStack.c, amount, fromStack.k());
        if (fromStack.d != null) {
            result.d = (bs)fromStack.d.b();
        }
        fromStack.a -= amount;
        return result;
    }

    public void a(int slot, wm contents) {
        this.inventory[slot] = contents == null ? contents : contents.m();
        if (contents != null && contents.a > this.d()) {
            contents.a = this.d();
        }
        if (this.slotDefinition.isUpgradeSlot(slot)) {
            this.updateCapacitorFromSlot();
        }
    }

    private void updateCapacitorFromSlot() {
        wm contents = this.inventory[this.slotDefinition.minUpgradeSlot];
        if (contents == null || contents.c != ModObject.itemBasicCapacitor.actualId) {
            this.setCapacitor(Capacitors.BASIC_CAPACITOR);
        } else {
            this.setCapacitor(Capacitors.values()[contents.k()]);
        }
    }

    public wm b(int i) {
        return null;
    }

    public void f() {
    }

    public void g() {
    }

    public void onNeighborBlockChange(int blockId) {
    }
}

