/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.PoweredTask;
import crazypants.enderio.machine.RecipeInput;
import crazypants.enderio.machine.SlotDefinition;
import java.util.Random;

public abstract class AbstractPoweredTaskEntity
extends AbstractMachineEntity
implements md {
    protected PoweredTask currentTask = null;
    protected IMachineRecipe lastCompletedRecipe;
    private final Random random = new Random();

    public AbstractPoweredTaskEntity(SlotDefinition slotDefinition) {
        super(slotDefinition);
    }

    public int[] c(int var1) {
        int[] res = new int[this.inventory.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i;
        }
        return res;
    }

    public boolean a(int i, wm itemstack, int j) {
        if (!this.slotDefinition.isInputSlot(i)) {
            return false;
        }
        if (!this.b(i, itemstack)) {
            return false;
        }
        if (this.inventory[i] == null) {
            return true;
        }
        if (this.inventory[i].a + itemstack.a > this.inventory[i].e()) {
            return false;
        }
        return this.inventory[i].a(itemstack);
    }

    public boolean b(int i, wm itemstack, int j) {
        if (!this.slotDefinition.isOutputSlot(i)) {
            return false;
        }
        if (this.inventory[i] == null || this.inventory[i].a < itemstack.a) {
            return false;
        }
        return itemstack.c == this.inventory[i].c;
    }

    @Override
    public boolean isActive() {
        return this.currentTask == null ? false : this.currentTask.getProgress() > 0.0f && this.hasPower() && this.redstoneCheckPassed;
    }

    @Override
    public float getProgress() {
        return this.currentTask == null ? 0.0f : this.currentTask.getProgress();
    }

    public float getExperienceForOutput(wm output) {
        if (this.lastCompletedRecipe == null) {
            return 0.0f;
        }
        return this.lastCompletedRecipe.getExperianceForOutput(output);
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (!redstoneChecksPassed) {
            return false;
        }
        if (this.inventory[0] != null) {
            boolean i = true;
        }
        boolean requiresClientSync = false;
        requiresClientSync |= this.checkProgress();
        float chance = this.random.nextFloat();
        IMachineRecipe nextRecipe = this.canStartNextTask(chance);
        if (nextRecipe != null) {
            requiresClientSync |= this.startNextTask(nextRecipe, chance);
        }
        return requiresClientSync;
    }

    protected boolean checkProgress() {
        if (this.currentTask == null || !this.hasPower()) {
            return false;
        }
        float used = this.powerHandler.useEnergy(0.0f, this.getPowerUsePerTick(), true);
        this.currentTask.update(used);
        if (this.currentTask.isComplete()) {
            this.taskComplete();
        }
        return true;
    }

    protected void taskComplete() {
        if (this.currentTask != null) {
            this.lastCompletedRecipe = this.currentTask.getRecipe();
            wm[] output = this.currentTask.getCompletedResult();
            if (output != null && output.length > 0) {
                wm[] results;
                for (wm result : results = this.currentTask.getCompletedResult()) {
                    if (result == null) continue;
                    int toMerge = result.a;
                    for (int i = this.slotDefinition.getMinOutputSlot(); i <= this.slotDefinition.getMaxOutputSlot() && toMerge > 0; ++i) {
                        int outputIndex = i;
                        if (this.inventory[outputIndex] == null) {
                            this.inventory[outputIndex] = result.m();
                            toMerge = 0;
                            continue;
                        }
                        int newStackSize = Math.min(this.inventory[outputIndex].a + this.getNumCanMerge(this.inventory[outputIndex], result), this.inventory[outputIndex].e());
                        int merged = newStackSize - this.inventory[outputIndex].a;
                        toMerge -= merged;
                        if (merged <= 0) continue;
                        this.inventory[outputIndex] = result.m();
                        this.inventory[outputIndex].a = newStackSize;
                    }
                }
            }
        }
        this.currentTask = null;
    }

    protected RecipeInput[] getInputs() {
        RecipeInput[] res = new RecipeInput[this.slotDefinition.getNumInputSlots()];
        int fromSlot = this.slotDefinition.minInputSlot;
        for (int i = 0; i < res.length; ++i) {
            res[i] = new RecipeInput(fromSlot, this.inventory[fromSlot]);
            ++fromSlot;
        }
        return res;
    }

    protected IMachineRecipe canStartNextTask(float chance) {
        if (this.currentTask != null) {
            return null;
        }
        if (!this.hasPower()) {
            return null;
        }
        IMachineRecipe nextRecipe = MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), this.getInputs());
        if (nextRecipe == null) {
            return null;
        }
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            if (this.inventory[i] != null) continue;
            return nextRecipe;
        }
        wm[] nextResults = nextRecipe.getCompletedResult(chance, this.getInputs());
        wm[] outputStacks = new wm[this.slotDefinition.getNumOutputSlots()];
        int copyIndex = 0;
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            wm inv = this.inventory[i];
            if (inv != null) {
                outputStacks[copyIndex] = inv.m();
            }
            ++copyIndex;
        }
        for (wm result : nextResults) {
            int canMerge = 0;
            for (wm outStack : outputStacks) {
                canMerge += this.getNumCanMerge(outStack, result);
            }
            if (canMerge >= result.a) continue;
            return null;
        }
        return nextRecipe;
    }

    protected int getNumCanMerge(wm itemStack, wm result) {
        if (!itemStack.a(result)) {
            return 0;
        }
        return Math.min(itemStack.e() - itemStack.a, result.a);
    }

    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        if (this.hasPower() && nextRecipe.isRecipe(this.getInputs())) {
            RecipeInput[] consumed;
            this.currentTask = new PoweredTask(nextRecipe, chance, this.getInputs());
            for (RecipeInput item : consumed = nextRecipe.getQuantitiesConsumed(this.getInputs())) {
                if (item == null || item.item == null || item.item.a <= 0) continue;
                this.a(item.slotNumber, item.item.a);
            }
            return true;
        }
        return false;
    }

    @Override
    public void a(bs nbtRoot) {
        super.a(nbtRoot);
        this.currentTask = PoweredTask.readFromNBT(nbtRoot.l("currentTask"));
        String uid = nbtRoot.i("lastCompletedRecipe");
        this.lastCompletedRecipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
    }

    @Override
    public void b(bs nbtRoot) {
        super.b(nbtRoot);
        if (this.currentTask != null) {
            bs currentTaskNBT = new bs();
            this.currentTask.writeToNBT(currentTaskNBT);
            nbtRoot.a("currentTask", currentTaskNBT);
        }
        if (this.lastCompletedRecipe != null) {
            nbtRoot.a("lastCompletedRecipe", this.lastCompletedRecipe.getUid());
        }
    }
}

