/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MachineRecipeRegistry {
    public static final MachineRecipeRegistry instance = new MachineRecipeRegistry();
    private final Map machineRecipes = new HashMap();

    public void registerRecipe(String machine, IMachineRecipe recipe) {
        this.getRecipesForMachine(machine).put(recipe.getUid(), recipe);
    }

    public Map getRecipesForMachine(String machineName) {
        HashMap res = (HashMap)this.machineRecipes.get(machineName);
        if (res == null) {
            res = new HashMap();
            this.machineRecipes.put(machineName, res);
        }
        return res;
    }

    public IMachineRecipe getRecipeForUid(String uid) {
        if (uid == null) {
            return null;
        }
        for (Map recipes : this.machineRecipes.values()) {
            for (IMachineRecipe recipe : recipes.values()) {
                if (!uid.equals(recipe.getUid())) continue;
                return recipe;
            }
        }
        return null;
    }

    public IMachineRecipe getRecipeForInputs(String machineName, RecipeInput ... inputs) {
        Map recipes = this.getRecipesForMachine(machineName);
        if (recipes == null) {
            return null;
        }
        for (IMachineRecipe recipe : recipes.values()) {
            if (!recipe.isRecipe(inputs)) continue;
            return recipe;
        }
        return null;
    }

    public List getRecipesForInput(String machineName, RecipeInput input) {
        if (input == null) {
            return Collections.emptyList();
        }
        ArrayList<IMachineRecipe> result = new ArrayList<IMachineRecipe>();
        Map recipes = this.getRecipesForMachine(machineName);
        for (IMachineRecipe recipe : recipes.values()) {
            if (!recipe.isValidInput(input)) continue;
            result.add(recipe);
        }
        return result;
    }
}

