/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.RecipeInput;

public class PoweredTask {
    public static final String KEY_INPUTS_SLOTS = "inputsSlots";
    public static final String KEY_INPUTS_STACKS = "inputsStacks";
    public static final String KEY_RECIPE = "recipeUid";
    public static final String KEY_USED_ENERGY = "usedEnergy";
    private static final String KEY_CHANCE = "chance";
    private float usedEnergy = 0.0f;
    private RecipeInput[] inputs;
    private float requiredEnergy;
    private IMachineRecipe recipe;
    private float chance;

    public PoweredTask(IMachineRecipe recipe, float chance, RecipeInput ... inputs) {
        this(recipe, 0.0f, chance, inputs);
    }

    protected PoweredTask(IMachineRecipe recipe, float usedEnergy, float chance, RecipeInput ... inputsIn) {
        this.inputs = inputsIn;
        int numInputs = 0;
        for (int i = 0; i < inputsIn.length; ++i) {
            if (inputsIn[i] == null || inputsIn[i].item == null) continue;
            ++numInputs;
        }
        this.inputs = new RecipeInput[numInputs];
        int index = 0;
        for (int i = 0; i < inputsIn.length; ++i) {
            if (inputsIn[i] == null || inputsIn[i].item == null) continue;
            this.inputs[index] = new RecipeInput(inputsIn[i].slotNumber, inputsIn[i].item.m());
            ++index;
        }
        this.recipe = recipe;
        this.usedEnergy = usedEnergy;
        this.chance = chance;
        this.requiredEnergy = recipe.getEnergyRequired(inputsIn);
    }

    public void update(float availableEnergy) {
        this.usedEnergy += availableEnergy;
    }

    public boolean isComplete() {
        return this.usedEnergy >= this.requiredEnergy;
    }

    public float getProgress() {
        return kx.a((float)(this.usedEnergy / this.requiredEnergy), (float)0.0f, (float)1.0f);
    }

    public wm[] getCompletedResult() {
        return this.recipe.getCompletedResult(this.chance, this.inputs);
    }

    public void writeToNBT(bs nbtRoot) {
        int[] inputSlots = new int[this.inputs.length];
        for (int i = 0; i < inputSlots.length; ++i) {
            inputSlots[i] = this.inputs[i].slotNumber;
        }
        nbtRoot.a(KEY_INPUTS_SLOTS, inputSlots);
        ca inputItems = new ca();
        for (RecipeInput ri : this.inputs) {
            bs stackRoot = new bs();
            ri.item.b(stackRoot);
            inputItems.a((cf)stackRoot);
        }
        nbtRoot.a(KEY_INPUTS_STACKS, (cf)inputItems);
        nbtRoot.a(KEY_RECIPE, this.recipe.getUid());
        nbtRoot.a(KEY_USED_ENERGY, this.usedEnergy);
        nbtRoot.a(KEY_CHANCE, this.chance);
    }

    public static PoweredTask readFromNBT(bs nbtRoot) {
        if (nbtRoot == null) {
            return null;
        }
        float usedEnergy = nbtRoot.g(KEY_USED_ENERGY);
        float chance = nbtRoot.g(KEY_CHANCE);
        int[] inputSlots = nbtRoot.k(KEY_INPUTS_SLOTS);
        if (inputSlots == null || inputSlots.length <= 0) {
            return null;
        }
        ca inputItems = nbtRoot.m(KEY_INPUTS_STACKS);
        if (inputItems == null || inputItems.c() != inputSlots.length) {
            return null;
        }
        RecipeInput[] inputs = new RecipeInput[inputSlots.length];
        for (int i = 0; i < inputSlots.length; ++i) {
            cf stackTag = inputItems.b(i);
            wm item = wm.a((bs)((bs)stackTag));
            inputs[i] = new RecipeInput(inputSlots[i], item);
        }
        String uid = nbtRoot.i(KEY_RECIPE);
        IMachineRecipe recipe = MachineRecipeRegistry.instance.getRecipeForUid(uid);
        if (recipe != null) {
            return new PoweredTask(recipe, usedEnergy, chance, inputs);
        }
        return null;
    }

    public IMachineRecipe getRecipe() {
        return this.recipe;
    }
}

