/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import cpw.mods.fml.common.network.Player;
import crazypants.enderio.IPacketProcessor;
import crazypants.enderio.Log;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.machine.power.TileCapacitorBank;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class RedstoneModePacketProcessor
implements IPacketProcessor {
    public static ei getRedstoneControlPacket(AbstractMachineEntity te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(2);
            dos.writeInt(te.l);
            dos.writeInt(te.m);
            dos.writeInt(te.n);
            dos.writeShort((short)te.getRedstoneControlMode().ordinal());
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    public static ei getRedstoneControlPacket(TileCapacitorBank te) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(140);
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(3);
            dos.writeInt(te.l);
            dos.writeInt(te.m);
            dos.writeInt(te.n);
            dos.writeShort((short)te.getInputControlMode().ordinal());
            dos.writeShort((short)te.getOutputControlMode().ordinal());
        }
        catch (IOException e) {
            // empty catch block
        }
        dk pkt = new dk();
        pkt.a = "EnderIO";
        pkt.c = bos.toByteArray();
        pkt.b = bos.size();
        pkt.s = true;
        return pkt;
    }

    @Override
    public boolean canProcessPacket(int packetID) {
        return packetID == 2 || packetID == 3;
    }

    @Override
    public void processPacket(int id, cg manager, DataInputStream data, Player player) throws IOException {
        if (id == 2) {
            this.handleRedstoneControlPacket(data, manager, player);
        } else if (id == 3) {
            this.handleCapBankRedstoneControlPacket(data, manager, player);
        } else {
            Log.warn("RedstoneModePacketProcessor: Recieved unknow packet: " + id);
        }
    }

    private void handleRedstoneControlPacket(DataInputStream data, cg manager, Player player) throws IOException {
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short ordinal = data.readShort();
        jc p = (jc)player;
        aqp te = p.q.r(x, y, z);
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            me.setRedstoneControlMode(RedstoneControlMode.values()[ordinal]);
            p.q.j(x, y, z);
        }
    }

    private void handleCapBankRedstoneControlPacket(DataInputStream data, cg manager, Player player) throws IOException {
        int x = data.readInt();
        int y = data.readInt();
        int z = data.readInt();
        short inputOrdinal = data.readShort();
        short outputOrdinal = data.readShort();
        jc p = (jc)player;
        aqp te = p.q.r(x, y, z);
        if (te instanceof TileCapacitorBank) {
            TileCapacitorBank cb = (TileCapacitorBank)te;
            cb.setInputControlMode(RedstoneControlMode.values()[inputOrdinal]);
            cb.setOutputControlMode(RedstoneControlMode.values()[outputOrdinal]);
            p.q.j(x, y, z);
        }
    }
}

