/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class BasicAlloyRecipe
implements IMachineRecipe {
    public static final int DEFAULT_ENERGY_USE = 1600;
    private final String uid;
    private float energyRequired = 1600.0f;
    private wm[] inputs;
    private Set inputKeys;
    private wm output;

    public BasicAlloyRecipe(wm output, String uid, wm ... recipeInputs) {
        this.output = output.m();
        this.uid = uid;
        this.inputs = new wm[recipeInputs.length];
        this.inputKeys = new HashSet();
        for (int i = 0; i < this.inputs.length; ++i) {
            if (recipeInputs[i] != null) {
                this.inputs[i] = recipeInputs[i].m();
                this.inputKeys.add(new InputKey(this.inputs[i].c, this.inputs[i].k()));
                continue;
            }
            this.inputs[i] = null;
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public float getEnergyRequired(RecipeInput ... inputs) {
        return this.energyRequired;
    }

    @Override
    public boolean isRecipe(RecipeInput ... checking) {
        if (this.inputs.length != (checking = this.getNonNullInputs(checking)).length) {
            return false;
        }
        HashSet keys = new HashSet(this.inputKeys);
        for (RecipeInput input : checking) {
            wm ing = this.getIngrediantForInput(input.item);
            if (ing == null || ing.a > input.item.a) {
                return false;
            }
            keys.remove(new InputKey(ing.c, ing.k()));
        }
        return keys.isEmpty();
    }

    private RecipeInput[] getNonNullInputs(RecipeInput[] checking) {
        int numNonNulls = 0;
        for (int i = 0; i < checking.length; ++i) {
            if (checking[i] == null || checking[i].item == null) continue;
            ++numNonNulls;
        }
        RecipeInput[] result = new RecipeInput[numNonNulls];
        int index = 0;
        for (int i = 0; i < checking.length; ++i) {
            if (checking[i] == null || checking[i].item == null) continue;
            result[index] = checking[i];
            ++index;
        }
        return result;
    }

    @Override
    public wm[] getCompletedResult(float chance, RecipeInput ... inputs) {
        return new wm[]{this.output.m()};
    }

    @Override
    public boolean isValidInput(RecipeInput input) {
        if (input == null) {
            return false;
        }
        return this.getIngrediantForInput(input.item) != null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAlloySmelter.unlocalisedName;
    }

    public int getQuantityConsumed(RecipeInput input) {
        wm ing = this.getIngrediantForInput(input.item);
        return ing == null ? 0 : ing.a;
    }

    private wm getIngrediantForInput(wm input) {
        if (input == null) {
            return null;
        }
        for (wm st : this.inputs) {
            if (st == null || st.c != input.c) continue;
            return st;
        }
        return null;
    }

    @Override
    public RecipeInput[] getQuantitiesConsumed(RecipeInput[] inputs) {
        ArrayList<RecipeInput> result = new ArrayList<RecipeInput>();
        for (RecipeInput input : inputs) {
            int numConsumed = this.getQuantityConsumed(input);
            if (numConsumed <= 0) continue;
            wm consumed = input.item.m();
            consumed.a = numConsumed;
            result.add(new RecipeInput(input.slotNumber, consumed));
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new RecipeInput[result.size()]);
    }

    @Override
    public float getExperianceForOutput(wm output) {
        return 0.0f;
    }

    static class InputKey {
        int itemID;
        int damage;

        InputKey(int itemID, int damage) {
            this.itemID = itemID;
            this.damage = damage;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.damage;
            result = 31 * result + this.itemID;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InputKey other = (InputKey)obj;
            if (this.damage != other.damage) {
                return false;
            }
            return this.itemID == other.itemID;
        }
    }
}

