/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.alloy;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import java.util.ArrayList;

public class VanillaSmeltingRecipe
implements IMachineRecipe {
    private static float MJ_PER_ITEM = aqg.a((wm)new wm(wk.n)) / 8;

    @Override
    public String getUid() {
        return "VanillaSmeltingRecipe";
    }

    @Override
    public float getEnergyRequired(RecipeInput ... inputs) {
        int numInputs = this.getNumInputs(inputs);
        return (float)numInputs * MJ_PER_ITEM;
    }

    private int getNumInputs(RecipeInput[] inputs) {
        int numInputs = 0;
        for (RecipeInput input : inputs) {
            if (input == null || !this.isValidInput(input)) continue;
            numInputs += input.item.a;
        }
        return Math.min(numInputs, 3);
    }

    @Override
    public boolean isRecipe(RecipeInput ... inputs) {
        wm output = null;
        for (RecipeInput ri : inputs) {
            wm newOutput;
            if (ri == null || ri.item == null || !(output == null ? (output = yg.a().getSmeltingResult(ri.item)) == null : (newOutput = yg.a().getSmeltingResult(ri.item)) == null || !newOutput.a(output))) continue;
            return false;
        }
        return output != null;
    }

    @Override
    public wm[] getCompletedResult(float chance, RecipeInput ... inputs) {
        wm output = null;
        boolean inputCount = false;
        for (RecipeInput ri : inputs) {
            if (ri == null || ri.item == null || output != null) continue;
            output = yg.a().getSmeltingResult(ri.item);
        }
        if (output == null) {
            return new wm[0];
        }
        wm result = output.m();
        result.a *= this.getNumInputs(inputs);
        return new wm[]{result};
    }

    @Override
    public float getExperianceForOutput(wm output) {
        if (output == null) {
            return 0.0f;
        }
        float result = yg.a().getExperience(output);
        return result * (float)output.a;
    }

    @Override
    public boolean isValidInput(RecipeInput input) {
        if (input == null) {
            return false;
        }
        wm itemstack = yg.a().getSmeltingResult(input.item);
        return itemstack != null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockAlloySmelter.unlocalisedName;
    }

    @Override
    public RecipeInput[] getQuantitiesConsumed(RecipeInput[] inputs) {
        int consumed = 0;
        ArrayList<RecipeInput> result = new ArrayList<RecipeInput>();
        for (RecipeInput ri : inputs) {
            int available;
            int canUse;
            int use;
            if (!this.isValidInput(new RecipeInput(ri.slotNumber, ri.item)) || consumed >= 3 || ri == null || ri.item == null || (use = Math.min(canUse = 3 - consumed, available = ri.item.a)) <= 0) continue;
            wm st = ri.item.m();
            st.a = use;
            result.add(new RecipeInput(ri.slotNumber, st));
            consumed += use;
        }
        return result.toArray(new RecipeInput[result.size()]);
    }
}

