/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.crusher;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.RecipeInput;
import crazypants.enderio.machine.crusher.CrusherOutput;
import crazypants.enderio.machine.crusher.CrusherRecipe;
import crazypants.enderio.machine.crusher.CrusherRecipeManager;
import java.util.ArrayList;

public class CrusherMachineRecipe
implements IMachineRecipe {
    @Override
    public String getUid() {
        return "CrusherRecipe";
    }

    @Override
    public float getEnergyRequired(RecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return 0.0f;
        }
        CrusherRecipe recipe = CrusherRecipeManager.instance.getRecipeForInput(inputs[0].item);
        return recipe == null ? 0.0f : recipe.getEnergyRequired();
    }

    @Override
    public boolean isRecipe(RecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return false;
        }
        CrusherRecipe recipe = CrusherRecipeManager.instance.getRecipeForInput(inputs[0].item);
        return recipe != null;
    }

    @Override
    public wm[] getCompletedResult(float chance, RecipeInput ... inputs) {
        if (inputs == null || inputs.length <= 0) {
            return new wm[0];
        }
        CrusherRecipe recipe = CrusherRecipeManager.instance.getRecipeForInput(inputs[0].item);
        if (recipe == null) {
            return new wm[0];
        }
        CrusherOutput[] outputs = recipe.getOutput();
        if (outputs == null) {
            return new wm[0];
        }
        ArrayList<wm> result = new ArrayList<wm>();
        for (CrusherOutput output : outputs) {
            if (!(output.getChance() >= chance)) continue;
            result.add(output.getOutput());
        }
        return result.toArray(new wm[result.size()]);
    }

    @Override
    public boolean isValidInput(RecipeInput input) {
        if (input == null) {
            return false;
        }
        return CrusherRecipeManager.instance.getRecipeForInput(input.item) != null;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockCrusher.unlocalisedName;
    }

    @Override
    public RecipeInput[] getQuantitiesConsumed(RecipeInput[] inputs) {
        RecipeInput[] res = new RecipeInput[inputs.length];
        int i = 0;
        for (RecipeInput input : inputs) {
            RecipeInput ri;
            wm used = input.item.m();
            used.a = 1;
            res[i] = ri = new RecipeInput(input.slotNumber, used);
            ++i;
        }
        return res;
    }

    @Override
    public float getExperianceForOutput(wm output) {
        return 0.0f;
    }
}

